/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.constraint;

import org.jboss.as.controller.access.constraint.AbstractSensitivity;

public class SensitivityClassification
extends AbstractSensitivity {
    public static final SensitivityClassification ACCESS_CONTROL = new SensitivityClassification("access-control", true, true, true);
    public static final SensitivityClassification CREDENTIAL = new SensitivityClassification("credential", false, true, true);
    public static final SensitivityClassification DOMAIN_CONTROLLER = new SensitivityClassification("domain-controller", false, false, true);
    public static final SensitivityClassification DOMAIN_NAMES = new SensitivityClassification("domain-names", false, false, true);
    public static final SensitivityClassification EXTENSIONS = new SensitivityClassification("extensions", false, false, true);
    public static final SensitivityClassification JVM = new SensitivityClassification("jvm", false, false, true);
    public static final SensitivityClassification MANAGEMENT_INTERFACES = new SensitivityClassification("management-interfaces", false, false, true);
    public static final SensitivityClassification MODULE_LOADING = new SensitivityClassification("module-loading", false, false, true);
    public static final SensitivityClassification PATCHING = new SensitivityClassification("patching", false, false, true);
    public static final SensitivityClassification READ_WHOLE_CONFIG = new SensitivityClassification("read-whole-config", false, true, true);
    public static final SensitivityClassification SECURITY_REALM = new SensitivityClassification("security-realm", true, true, true);
    public static final SensitivityClassification SECURITY_REALM_REF = new SensitivityClassification("security-realm-ref", true, true, true);
    public static final SensitivityClassification SECURITY_DOMAIN = new SensitivityClassification("security-domain", true, true, true);
    public static final SensitivityClassification SECURITY_DOMAIN_REF = new SensitivityClassification("security-domain-ref", true, true, true);
    public static final SensitivityClassification SECURITY_VAULT = new SensitivityClassification("security-vault", false, true, true);
    public static final SensitivityClassification SERVER_SSL = new SensitivityClassification("server-ssl", true, true, true);
    public static final SensitivityClassification SERVICE_CONTAINER = new SensitivityClassification("service-container", false, false, true);
    public static final SensitivityClassification SOCKET_BINDING_REF = new SensitivityClassification("socket-binding-ref", false, false, false);
    public static final SensitivityClassification SOCKET_CONFIG = new SensitivityClassification("socket-config", false, false, true);
    public static final SensitivityClassification SNAPSHOTS = new SensitivityClassification("snapshots", false, false, false);
    public static final SensitivityClassification SYSTEM_PROPERTY = new SensitivityClassification("system-property", false, false, true);
    private final boolean core;
    private final String subsystem;
    private final String name;

    private SensitivityClassification(String name, boolean accessDefault, boolean readDefault, boolean writeDefault) {
        super(accessDefault, readDefault, writeDefault);
        this.core = true;
        this.subsystem = null;
        this.name = name;
    }

    public SensitivityClassification(String subsystem, String name, boolean accessDefault, boolean readDefault, boolean writeDefault) {
        super(accessDefault, readDefault, writeDefault);
        assert (subsystem != null) : "subsystem is null";
        assert (name != null) : "name is null";
        this.core = false;
        this.subsystem = subsystem;
        this.name = name;
    }

    public boolean isCore() {
        return this.core;
    }

    public String getSubsystem() {
        return this.subsystem;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SensitivityClassification that = (SensitivityClassification)o;
        return this.core == that.core && this.name.equals(that.name) && !(this.subsystem == null ? that.subsystem != null : !this.subsystem.equals(that.subsystem));
    }

    public int hashCode() {
        int result = this.core ? 1 : 0;
        result = 31 * result + (this.subsystem != null ? this.subsystem.hashCode() : 0);
        result = 31 * result + this.name.hashCode();
        return result;
    }

    Key getKey() {
        return new Key();
    }

    class Key {
        private final SensitivityClassification sensitivity;

        Key() {
            this.sensitivity = SensitivityClassification.this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key thatKey = (Key)o;
            SensitivityClassification that = thatKey.sensitivity;
            return SensitivityClassification.this.core == that.core && SensitivityClassification.this.name.equals(that.name) && !(SensitivityClassification.this.subsystem == null ? that.subsystem != null : !SensitivityClassification.this.subsystem.equals(that.subsystem));
        }

        public int hashCode() {
            int result = SensitivityClassification.this.core ? 1 : 0;
            result = 31 * result + (SensitivityClassification.this.subsystem != null ? SensitivityClassification.this.subsystem.hashCode() : 0);
            result = 31 * result + SensitivityClassification.this.name.hashCode();
            return result;
        }
    }
}

