/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.management;

import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.dmr.ModelNode;

public class AccessConstraintDescriptionProviderUtil {
    public static void addAccessConstraints(ModelNode result, List<AccessConstraintDefinition> accessConstraints, Locale locale) {
        if (accessConstraints.size() > 0) {
            ModelNode constraints = new ModelNode();
            for (AccessConstraintDefinition constraint : accessConstraints) {
                ModelNode details;
                ModelNode constraintDesc = constraints.get(constraint.getType(), constraint.getName());
                constraintDesc.get("type").set(constraint.isCore() ? "core" : constraint.getSubsystemName());
                String textDesc = constraint.getDescription(locale);
                if (textDesc != null) {
                    constraintDesc.get("description").set(textDesc);
                }
                if ((details = constraint.getModelDescriptionDetails(locale)) == null || !details.isDefined()) continue;
                constraintDesc.get("details").set(details);
            }
            result.get("access-constraints").set(constraints);
        }
    }
}

