/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.vdx.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.projectodd.vdx.core.thirdparty.Levenshtein;

public class Util {
    private static final Pattern XMLNS_RE = Pattern.compile("xmlns\\s*=\\s*[\"'](.*?)[\"']");
    private static final Pattern ELEMENT_RE = Pattern.compile("<([^?].*?)[\\s/>]");
    private static final Pattern TARGET_NS_RE = Pattern.compile("targetNamespace\\s*=\\s*[\"'](.*?)[\"']");

    public static Set<String> extractXMLNS(List<String> lines) {
        TreeSet<String> xmlnses = new TreeSet<String>();
        lines.forEach(l -> {
            Matcher m = XMLNS_RE.matcher((CharSequence)l);
            if (m.find()) {
                xmlnses.add(m.group(1));
            }
        });
        return xmlnses;
    }

    public static QName extractFirstElement(List<String> lines) {
        QName name = null;
        for (int idx = 0; name == null && idx < lines.size(); ++idx) {
            String line = lines.get(idx);
            Matcher elm = ELEMENT_RE.matcher(line);
            if (!elm.find()) continue;
            String el = elm.group(1);
            Matcher xm = XMLNS_RE.matcher(line);
            name = xm.find() ? new QName(xm.group(1), el) : QName.valueOf(el);
        }
        return name;
    }

    public static boolean providesXMLNS(Set<String> xmlnses, URL url) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
            String line = reader.readLine();
            while (line != null) {
                Matcher m = TARGET_NS_RE.matcher(line);
                if (m.find() && xmlnses.contains(m.group(1))) {
                    boolean bl = true;
                    return bl;
                }
                line = reader.readLine();
            }
        }
        return false;
    }

    public static String alternateSpelling(String current, Collection<String> alternates) {
        return Util.alternateSpelling(current, alternates, Util.dynamicThreshold(current));
    }

    private static int dynamicThreshold(String s) {
        int len = s.length();
        if (len < 6) {
            return 2;
        }
        if (len < 10) {
            return 3;
        }
        if (len < 14) {
            return 4;
        }
        return 5;
    }

    public static String alternateSpelling(String current, Collection<String> alternates, int threshold) {
        String alternate = alternates.stream().map(s -> {
            int dist = Levenshtein.getLevenshteinDistance(current, s, threshold);
            if (dist > 0) {
                return String.format("%s:%s", dist, s);
            }
            return null;
        }).filter(x -> x != null).sorted().findFirst().orElse(null);
        if (alternate != null) {
            String[] parts = alternate.split(":");
            return parts[1];
        }
        return null;
    }

    public static String withPrefix(String prefix, String v) {
        boolean addNewLine = v.endsWith("\n");
        return String.join((CharSequence)"\n", Arrays.stream(v.split("\\n")).map(x -> String.format("%s%s", prefix, x)).collect(Collectors.toList())) + (addNewLine ? "\n" : "");
    }

    public static <T> List<T> asSortedList(Collection<? extends T> col) {
        if (col == null) {
            return Collections.EMPTY_LIST;
        }
        return col.stream().sorted().collect(Collectors.toList());
    }

    public static String asCommaString(Collection<?> col) {
        return String.join((CharSequence)", ", col.stream().map(Object::toString).collect(Collectors.toList()));
    }

    public static String pathToString(List<String> path) {
        return String.join((CharSequence)" > ", path);
    }

    public static Function<String, String> possiblyUnderscoredName(Set<String> possibles) {
        return s -> {
            if (possibles.contains(s)) {
                return s;
            }
            String sans_ = s.replace("_", "-");
            if (possibles.contains(sans_)) {
                return sans_;
            }
            return s;
        };
    }
}

