/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.vdx.core.handlers;

import java.util.regex.Pattern;
import javax.xml.stream.Location;
import org.projectodd.vdx.core.ErrorHandler;
import org.projectodd.vdx.core.I18N;
import org.projectodd.vdx.core.Position;
import org.projectodd.vdx.core.ValidationContext;
import org.projectodd.vdx.core.ValidationError;

public class DuplicateAttributeHandler
implements ErrorHandler {
    @Override
    public ErrorHandler.HandledResult handle(ValidationContext ctx, ValidationError error) {
        String attr = error.attribute().getLocalPart();
        String el = error.element() == null ? null : error.element().getLocalPart();
        Location loc = error.location();
        Pattern attrPattern = Pattern.compile(String.format("\\s%s\\s*=", attr));
        Position pos = ctx.searchBackward(loc.getLineNumber() - 1, loc.getColumnNumber(), attrPattern);
        ErrorHandler.HandledResult result = ErrorHandler.HandledResult.from(error);
        if (el == null) {
            result.primaryMessage(I18N.Key.ATTRIBUTE_DUPLICATED_NO_ELEMENT, attr);
        } else {
            result.primaryMessage(I18N.Key.ATTRIBUTE_DUPLICATED, attr, el);
        }
        if (pos != null) {
            result.line(pos.line).column(pos.col + 1);
            Position firstPos = ctx.searchForward(pos.line - 1, 0, attrPattern);
            if (firstPos == null || firstPos.equals(pos)) {
                firstPos = ctx.searchBackward(pos.line - 2, Integer.MAX_VALUE, attrPattern);
            }
            if (firstPos != null) {
                result.secondaryMessage(I18N.Key.ATTRIBUTE_DUPLICATED_FIRST_OCCURRENCE, attr).secondaryResult(new ErrorHandler.HandledResult(firstPos.line, firstPos.col + 1, null));
            }
        }
        return result;
    }
}

