/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.interfaces;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Arrays;
import org.jboss.as.controller.interfaces.AbstractInterfaceCriteria;
import org.wildfly.common.Assert;

public class SubnetMatchInterfaceCriteria
extends AbstractInterfaceCriteria {
    private static final long serialVersionUID = 149404752878332750L;
    private byte[] network;
    private int mask;

    public SubnetMatchInterfaceCriteria(byte[] network, int mask) {
        Assert.checkNotNullParam("network", network);
        this.network = network;
        this.mask = mask;
    }

    @Override
    protected InetAddress isAcceptable(NetworkInterface networkInterface, InetAddress address) throws SocketException {
        return this.verifyAddressByMask(address.getAddress()) ? address : null;
    }

    boolean verifyAddressByMask(byte[] addr) {
        if (addr.length != this.network.length) {
            return false;
        }
        int max = this.network.length * 8;
        int bitMask = 255;
        for (int maskOffset = 0; maskOffset < this.mask && maskOffset < max; maskOffset += 8) {
            if (this.mask - maskOffset < 8) {
                bitMask = 255 << 8 - (this.mask - maskOffset);
            }
            if ((addr[maskOffset / 8] & bitMask) == (this.network[maskOffset / 8] & bitMask)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int i = 17;
        i = 31 * i + this.mask;
        i = 31 * i + Arrays.hashCode(this.network);
        return i;
    }

    public boolean equals(Object o) {
        return o instanceof SubnetMatchInterfaceCriteria && Arrays.equals(this.network, ((SubnetMatchInterfaceCriteria)o).network) && this.mask == ((SubnetMatchInterfaceCriteria)o).mask;
    }
}

