/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.vdx.core.handlers;

import java.util.List;
import org.projectodd.vdx.core.DocElement;
import org.projectodd.vdx.core.ErrorHandler;
import org.projectodd.vdx.core.I18N;
import org.projectodd.vdx.core.ValidationContext;
import org.projectodd.vdx.core.ValidationError;

public class DuplicateElementHandler
implements ErrorHandler {
    @Override
    public ErrorHandler.HandledResult handle(ValidationContext ctx, ValidationError error) {
        List<DocElement> firstPath;
        List<List<DocElement>> docElements;
        List<DocElement> path;
        String el = error.element().getLocalPart();
        String attr = error.attribute() != null ? error.attribute().getLocalPart() : null;
        String attrValue = error.attributeValue();
        ErrorHandler.HandledResult result = ErrorHandler.HandledResult.from(error);
        if (attr != null) {
            result.primaryMessage(I18N.Key.ELEMENT_WITH_ATTRIBUTE_DUPLICATED, el, attr, attrValue);
        } else {
            path = ctx.pathToDocElement(error.element(), error.position());
            String parentName = "parent";
            if (!path.isEmpty() && path.size() > 1) {
                parentName = path.get(path.size() - 2).name();
            }
            result.primaryMessage(I18N.Key.ELEMENT_DUPLICATED, el, parentName);
        }
        path = ctx.pathToDocElement(error.element(), error.position());
        if (!(path.isEmpty() || (docElements = ctx.docElementSiblings(path, e -> e.qname().equals(error.element()) && (attr == null || attrValue.equals(e.attributes().get(attr))))).isEmpty() || (firstPath = docElements.get(0)).isEmpty())) {
            DocElement otherEl = firstPath.get(firstPath.size() - 1);
            if (attr != null) {
                result.secondaryMessage(I18N.Key.ELEMENT_WITH_ATTRIBUTE_DUPLICATED_FIRST_OCCURRENCE, el, attr);
            } else {
                result.secondaryMessage(I18N.Key.ELEMENT_DUPLICATED_FIRST_OCCURRENCE, el);
            }
            result.secondaryResult(new ErrorHandler.HandledResult(otherEl.startPosition().line, otherEl.startPosition().col, null));
        }
        return result;
    }
}

