/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.util.ArrayList;
import java.util.Collections;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.CommandRegistry;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.impl.ArgumentWithoutValue;

public class HelpHandler
extends CommandHandlerWithHelp {
    private final CommandRegistry cmdRegistry;
    private final ArgumentWithoutValue commands = new ArgumentWithoutValue(this, "--commands");

    public HelpHandler(CommandRegistry cmdRegistry) {
        this("help", cmdRegistry);
    }

    public HelpHandler(String command, CommandRegistry cmdRegistry) {
        super(command);
        if (cmdRegistry == null) {
            throw new IllegalArgumentException("CommandRegistry is null");
        }
        this.cmdRegistry = cmdRegistry;
        this.helpArg.setExclusive(false);
        this.helpArg.addCantAppearAfter(this.commands);
        this.helpArg.addRequiredPreceding(this.commands);
    }

    @Override
    public void handle(CommandContext ctx) throws CommandLineException {
        boolean printCommands;
        try {
            printCommands = this.commands.isPresent(ctx.getParsedCommandLine());
        }
        catch (CommandFormatException e) {
            throw new CommandFormatException(e.getLocalizedMessage());
        }
        if (printCommands) {
            ArrayList<String> commands = new ArrayList<String>();
            for (String cmd : this.cmdRegistry.getTabCompletionCommands()) {
                CommandHandler handler = this.cmdRegistry.getCommandHandler(cmd);
                if (!handler.isAvailable(ctx)) continue;
                commands.add(cmd);
            }
            Collections.sort(commands);
            ctx.printLine("Commands available in the current context:");
            ctx.printColumns(commands);
            ctx.printLine("To read a description of a specific command execute 'command_name --help'.");
        } else {
            this.printHelp(ctx);
        }
    }

    @Override
    protected void doHandle(CommandContext ctx) {
    }
}

