/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.operation.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.impl.CapabilityReferenceCompleter;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class AttributeTypeDescrValueCompleter
extends DefaultCompleter {
    private static final List<String> BOOLEAN = Arrays.asList("false", "true");

    public AttributeTypeDescrValueCompleter(final ModelNode attrDescr, final OperationRequestAddress address) {
        super(new DefaultCompleter.CandidatesProvider(){

            @Override
            public Collection<String> getAllCandidates(CommandContext ctx) {
                ModelNode typeNode = attrDescr.get("type");
                if (typeNode.isDefined() && typeNode.asType().equals((Object)ModelType.BOOLEAN)) {
                    return BOOLEAN;
                }
                if (attrDescr.has("allowed")) {
                    ModelNode allowedNode = attrDescr.get("allowed");
                    if (allowedNode.isDefined()) {
                        List<ModelNode> nodeList = allowedNode.asList();
                        ArrayList<String> values = new ArrayList<String>(nodeList.size());
                        for (ModelNode node : nodeList) {
                            values.add(node.asString());
                        }
                        return values;
                    }
                } else if (attrDescr.has("capability-reference")) {
                    return CapabilityReferenceCompleter.getCapabilityNames(ctx, address, attrDescr.get("capability-reference").asString());
                }
                return Collections.emptyList();
            }
        });
    }
}

