/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.MapAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.global.FilteredData;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public final class QueryOperationHandler
extends GlobalOperationHandlers.AbstractMultiTargetHandler {
    public static final QueryOperationHandler INSTANCE = new QueryOperationHandler();
    public static final PropertiesAttributeDefinition WHERE_ATT = ((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder("where", true).setCorrector(MapAttributeDefinition.LIST_TO_MAP_CORRECTOR)).setValidator(new StringLengthValidator(1, true, true))).setAllowExpression(true)).build();
    private static final AttributeDefinition OPERATOR_ATT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("operator", ModelType.STRING).setAllowNull(true)).setDefaultValue(new ModelNode().set(Operator.AND.name()))).setValidator(EnumValidator.create(Operator.class, true, false))).build();
    private static final AttributeDefinition SELECT_ATT = ((PrimitiveListAttributeDefinition.Builder)new PrimitiveListAttributeDefinition.Builder("select", ModelType.STRING).setAllowNull(true)).build();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("query", ControllerResolver.getResolver("global")).addParameter(SELECT_ATT).addParameter(WHERE_ATT).setReplyType(ModelType.LIST).setReplyValueType(ModelType.OBJECT).setReadOnly().build();
    public static final OperationTransformer TRANSFORMER = new OperationTransformer(){

        @Override
        public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
            ModelNode transformedOp = Util.createEmptyOperation("read-resource", address);
            transformedOp.get("include-runtime").set(true);
            ResultTransformer rt = new ResultTransformer(operation, address);
            return new OperationTransformer.TransformedOperation(transformedOp, rt);
        }
    };

    private QueryOperationHandler() {
        super(null, true, item -> !item.hasDefined("result"));
    }

    @Override
    void doExecute(OperationContext parentContext, ModelNode operation, FilteredData filteredData, boolean ignoreMissingResources) throws OperationFailedException {
        ModelNode where = WHERE_ATT.validateOperation(operation);
        Operator operator = Operator.valueOf(OPERATOR_ATT.resolveModelAttribute(parentContext, operation).asString());
        ModelNode select = SELECT_ATT.validateOperation(operation);
        ImmutableManagementResourceRegistration mrr = parentContext.getResourceRegistration();
        OperationStepHandler readResourceHandler = mrr.getOperationHandler(PathAddress.EMPTY_ADDRESS, "read-resource");
        ModelNode readResourceOp = new ModelNode();
        readResourceOp.get("address").set(operation.get("address"));
        readResourceOp.get("operation").set("read-resource");
        readResourceOp.get("include-runtime").set(true);
        parentContext.addStep(operation, new FilterReduceHandler(where, operator, select), OperationContext.Stage.MODEL);
        parentContext.addStep(readResourceOp, readResourceHandler, OperationContext.Stage.MODEL);
    }

    private static class ResultTransformer
    implements OperationResultTransformer {
        private final boolean multiTarget;
        private final ModelNode filter;
        private final Operator operator;
        private final ModelNode select;

        private ResultTransformer(ModelNode operation, PathAddress address) {
            this.multiTarget = address.isMultiTarget();
            try {
                this.filter = WHERE_ATT.validateOperation(operation);
                this.select = SELECT_ATT.validateOperation(operation);
                this.operator = Operator.valueOf(OPERATOR_ATT.resolveModelAttribute(ExpressionResolver.SIMPLE, operation).asString());
            }
            catch (OperationFailedException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public ModelNode transformResult(ModelNode response) {
            ModelNode transformedResponse;
            ControllerLogger.MGMT_OP_LOGGER.tracef("Transforming response %s", (Object)response);
            if (response.hasDefined("result")) {
                transformedResponse = response.clone();
                if (this.multiTarget) {
                    ModelNode transformedResults = transformedResponse.get("result");
                    for (int i = 0; i < transformedResults.asInt(); ++i) {
                        ModelNode item = transformedResults.get(i);
                        this.transformResponseItem(item);
                        if (item.hasDefined("result")) continue;
                        transformedResults.remove(i);
                        --i;
                        ControllerLogger.MGMT_OP_LOGGER.tracef("Removed response item %s", (Object)item);
                    }
                } else {
                    this.transformResponseItem(transformedResponse);
                }
                ControllerLogger.MGMT_OP_LOGGER.tracef("Transformed response is %s", (Object)transformedResponse);
            } else {
                transformedResponse = response;
            }
            return transformedResponse;
        }

        private void transformResponseItem(ModelNode responseItem) {
            block3: {
                if (responseItem.hasDefined("result") || this.filter.isDefined()) {
                    ModelNode result = responseItem.get("result");
                    try {
                        FilterReduceHandler.filterAndReduce(this.filter, this.operator, this.select, result);
                        ControllerLogger.MGMT_OP_LOGGER.tracef("Transformed response item to %s", (Object)responseItem);
                    }
                    catch (OperationFailedException e) {
                        if (responseItem.hasDefined("failure-description")) break block3;
                        responseItem.get("failure-description").set(e.getMessage());
                    }
                }
            }
        }
    }

    static class FilterReduceHandler
    implements OperationStepHandler {
        private static final String UNDEFINED = "undefined";
        private final ModelNode filter;
        private final Operator operator;
        private final ModelNode select;

        FilterReduceHandler(ModelNode filter, Operator operator, ModelNode select) {
            this.filter = filter;
            this.operator = operator;
            this.select = select;
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.completeStep(new OperationContext.ResultHandler(){

                @Override
                public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                    block3: {
                        if (context.hasResult() || filter.isDefined()) {
                            ModelNode result = context.getResult();
                            try {
                                FilterReduceHandler.filterAndReduce(filter, operator, select, result);
                            }
                            catch (OperationFailedException e) {
                                if (context.hasFailureDescription()) break block3;
                                context.getFailureDescription().set(e.getMessage());
                            }
                        }
                    }
                }
            });
        }

        private static void filterAndReduce(ModelNode filter, Operator operator, ModelNode select, ModelNode result) throws OperationFailedException {
            boolean matches;
            assert (result != null);
            if (filter.isDefined() && !(matches = FilterReduceHandler.matchesFilter(result, filter, operator))) {
                result.set(new ModelNode());
            }
            if (select.isDefined() && result.isDefined()) {
                ModelNode reduced = FilterReduceHandler.reduce(result, select);
                result.set(reduced);
            }
        }

        private static boolean matchesFilter(ModelNode resource, ModelNode filter, Operator operator) throws OperationFailedException {
            boolean isMatching = false;
            List<Property> filterProperties = filter.asPropertyList();
            ArrayList<Boolean> matches = new ArrayList<Boolean>(filterProperties.size());
            for (Property property : filterProperties) {
                String filterName = property.getName();
                ModelNode filterValue = property.getValue();
                boolean isEqual = false;
                if (!filterValue.isDefined() || filterValue.asString().equals(UNDEFINED)) {
                    isEqual = !resource.get(filterName).isDefined();
                } else {
                    ModelType targetValueType = resource.get(filterName).getType();
                    try {
                        switch (targetValueType) {
                            case BOOLEAN: {
                                isEqual = filterValue.asBoolean() == resource.get(filterName).asBoolean();
                                break;
                            }
                            case LONG: {
                                isEqual = filterValue.asLong() == resource.get(filterName).asLong();
                                break;
                            }
                            case INT: {
                                isEqual = filterValue.asInt() == resource.get(filterName).asInt();
                                break;
                            }
                            case DOUBLE: {
                                isEqual = filterValue.asDouble() == resource.get(filterName).asDouble();
                                break;
                            }
                            default: {
                                isEqual = filterValue.equals(resource.get(filterName));
                                break;
                            }
                        }
                    }
                    catch (IllegalArgumentException e) {
                        throw ControllerLogger.MGMT_OP_LOGGER.selectFailedCouldNotConvertAttributeToType(filterName, targetValueType);
                    }
                }
                if (!isEqual) continue;
                matches.add(resource.get(filterName).equals(filterValue));
            }
            if (Operator.AND.equals((Object)operator)) {
                isMatching = matches.size() == filterProperties.size();
            } else if (Operator.OR.equals((Object)operator)) {
                for (Boolean match : matches) {
                    if (!match.booleanValue()) continue;
                    isMatching = true;
                    break;
                }
            } else {
                throw new IllegalArgumentException(ControllerLogger.MGMT_OP_LOGGER.invalidValue(operator.toString(), "operator", Arrays.asList(Operator.values())));
            }
            return isMatching;
        }

        private static ModelNode reduce(ModelNode payload, ModelNode attributes) throws OperationFailedException {
            ModelNode outcome = new ModelNode();
            for (ModelNode attribute : attributes.asList()) {
                String name = attribute.asString();
                ModelNode value = payload.get(name);
                if (!value.isDefined()) continue;
                outcome.get(name).set(value);
            }
            return outcome;
        }
    }

    public static enum Operator {
        AND,
        OR;

    }
}

