/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.vdx.core.handlers;

import java.util.Set;
import java.util.stream.Collectors;
import org.projectodd.vdx.core.ErrorHandler;
import org.projectodd.vdx.core.I18N;
import org.projectodd.vdx.core.Util;
import org.projectodd.vdx.core.ValidationContext;
import org.projectodd.vdx.core.ValidationError;

public class RequiredAttributeMissingHandler
implements ErrorHandler {
    @Override
    public ErrorHandler.HandledResult handle(ValidationContext ctx, ValidationError error) {
        String el = error.element().getLocalPart();
        Set<String> alts = error.alternatives();
        ErrorHandler.HandledResult result = ErrorHandler.HandledResult.from(error).primaryMessage(I18N.Key.ATTRIBUTE_REQUIRED_MISSING, el);
        if (!alts.isEmpty()) {
            Set<String> attributesForElement = ctx.attributesForElement(ctx.mapDocLocationToSchemaPath(error.element(), error.position()));
            result.primaryMessage(I18N.Key.ATTRIBUTE_REQUIRED_MISSING_LIST, Util.asSortedList(alts).stream().map(String::toLowerCase).map(Util.possiblyUnderscoredName(attributesForElement)).collect(Collectors.toList()));
        }
        return result;
    }
}

