/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.security.Principal;
import java.util.function.Function;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.principal.AnonymousPrincipal;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SupportLevel;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.credential.AlgorithmCredential;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;

public interface RealmIdentity {
    public static final RealmIdentity ANONYMOUS = new RealmIdentity(){

        @Override
        public Principal getRealmIdentityPrincipal() {
            return AnonymousPrincipal.getInstance();
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam("credentialType", credentialType);
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam("evidenceType", evidenceType);
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            Assert.checkNotNullParam("credentialType", credentialType);
            return null;
        }

        @Override
        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            Assert.checkNotNullParam("evidence", evidence);
            return false;
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return true;
        }
    };
    public static final RealmIdentity NON_EXISTENT = new RealmIdentity(){

        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam("credentialType", credentialType);
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam("evidenceType", evidenceType);
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            Assert.checkNotNullParam("credentialType", credentialType);
            return null;
        }

        @Override
        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            Assert.checkNotNullParam("evidence", evidence);
            return false;
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return false;
        }
    };

    default public Principal getRealmIdentityPrincipal() {
        return null;
    }

    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> var1, String var2) throws RealmUnavailableException;

    public <C extends Credential> C getCredential(Class<C> var1) throws RealmUnavailableException;

    default public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
        if (algorithmName != null) {
            C credential = this.getCredential(credentialType);
            return credential instanceof AlgorithmCredential && algorithmName.equals(((AlgorithmCredential)credential).getAlgorithm()) ? (C)credential : null;
        }
        return this.getCredential(credentialType);
    }

    default public <C extends Credential, R> R applyToCredential(Class<C> credentialType, Function<C, R> function) throws RealmUnavailableException {
        C credential = this.getCredential(credentialType);
        return credential == null ? null : (R)credential.castAndApply(credentialType, function);
    }

    default public <C extends Credential, R> R applyToCredential(Class<C> credentialType, String algorithmName, Function<C, R> function) throws RealmUnavailableException {
        C credential = this.getCredential(credentialType, algorithmName);
        return credential == null ? null : (R)credential.castAndApply(credentialType, algorithmName, function);
    }

    default public void updateCredential(Credential credential) throws RealmUnavailableException {
        throw ElytronMessages.log.credentialUpdateNotSupportedByRealm();
    }

    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> var1, String var2) throws RealmUnavailableException;

    public boolean verifyEvidence(Evidence var1) throws RealmUnavailableException;

    public boolean exists() throws RealmUnavailableException;

    default public void dispose() {
    }

    default public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
        if (this.exists()) {
            return AuthorizationIdentity.EMPTY;
        }
        throw ElytronMessages.log.userDoesNotExist();
    }

    default public Attributes getAttributes() throws RealmUnavailableException {
        return null;
    }
}

