/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.MapValidator;
import org.jboss.as.controller.operations.validation.NillableOrExpressionParameterValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.common.Assert;

public abstract class MapAttributeDefinition
extends AttributeDefinition {
    private final ParameterValidator elementValidator;
    public static final ParameterCorrector LIST_TO_MAP_CORRECTOR = new ParameterCorrector(){

        @Override
        public ModelNode correct(ModelNode newValue, ModelNode currentValue) {
            if (newValue.isDefined() && newValue.getType() == ModelType.LIST) {
                int listSize = newValue.asList().size();
                List<Property> propertyList = newValue.asPropertyList();
                if (propertyList.size() == 0) {
                    if (listSize == 0) {
                        return new ModelNode();
                    }
                    if (listSize > 0) {
                        return newValue;
                    }
                }
                ModelNode corrected = new ModelNode();
                for (Property p : newValue.asPropertyList()) {
                    corrected.get(p.getName()).set(p.getValue());
                }
                return corrected;
            }
            return newValue;
        }
    };

    @Deprecated
    public MapAttributeDefinition(String name, boolean allowNull, ParameterValidator elementValidator) {
        super(name, name, null, ModelType.OBJECT, allowNull, false, null, null, (ParameterValidator)new MapValidator(elementValidator, allowNull, 0, Integer.MAX_VALUE), false, null, null, null, false, null, null, null, null, new AttributeAccess.Flag[0]);
        this.elementValidator = elementValidator;
    }

    protected MapAttributeDefinition(Builder<? extends Builder, ? extends MapAttributeDefinition> builder) {
        super(builder);
        this.elementValidator = builder.getElementValidator();
    }

    public ModelNode parse(String value, Location location) throws XMLStreamException {
        ModelNode node = ParseUtils.parseAttributeValue(value, this.isAllowExpression(), this.getType());
        try {
            this.elementValidator.validateParameter(this.getXmlName(), node);
        }
        catch (OperationFailedException e) {
            throw new XMLStreamException(e.getFailureDescription().toString(), location);
        }
        return node;
    }

    public void parseAndAddParameterElement(String key, String value, ModelNode operation, XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode paramVal = this.parse(value, reader.getLocation());
        operation.get(this.getName()).get(key).set(paramVal);
    }

    @Override
    public ModelNode addResourceAttributeDescription(ResourceBundle bundle2, String prefix, ModelNode resourceDescription) {
        ModelNode result = super.addResourceAttributeDescription(bundle2, prefix, resourceDescription);
        this.addValueTypeDescription(result, bundle2);
        return result;
    }

    @Override
    public ModelNode addOperationParameterDescription(ResourceBundle bundle2, String prefix, ModelNode operationDescription) {
        ModelNode result = super.addOperationParameterDescription(bundle2, prefix, operationDescription);
        this.addValueTypeDescription(result, bundle2);
        return result;
    }

    public ParameterValidator getElementValidator() {
        return this.elementValidator;
    }

    protected abstract void addValueTypeDescription(ModelNode var1, ResourceBundle var2);

    @Override
    public ModelNode addResourceAttributeDescription(ModelNode resourceDescription, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode result = super.addResourceAttributeDescription(resourceDescription, resolver, locale, bundle2);
        this.addAttributeValueTypeDescription(result, resolver, locale, bundle2);
        return result;
    }

    protected abstract void addAttributeValueTypeDescription(ModelNode var1, ResourceDescriptionResolver var2, Locale var3, ResourceBundle var4);

    @Override
    public ModelNode addOperationParameterDescription(ModelNode resourceDescription, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode result = super.addOperationParameterDescription(resourceDescription, operationName, resolver, locale, bundle2);
        this.addOperationParameterValueTypeDescription(result, operationName, resolver, locale, bundle2);
        return result;
    }

    @Override
    public ModelNode addOperationReplyDescription(ModelNode resourceDescription, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode result = super.addOperationReplyDescription(resourceDescription, operationName, resolver, locale, bundle2);
        this.addOperationParameterValueTypeDescription(result, operationName, resolver, locale, bundle2);
        return result;
    }

    protected abstract void addOperationParameterValueTypeDescription(ModelNode var1, String var2, ResourceDescriptionResolver var3, Locale var4, ResourceBundle var5);

    @Override
    public void marshallAsElement(ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
        if (this.attributeMarshaller.isMarshallable(this, resourceModel, marshallDefault)) {
            this.attributeMarshaller.marshallAsElement(this, resourceModel, marshallDefault, writer);
        }
    }

    @Override
    protected ModelNode convertParameterExpressions(ModelNode parameter) {
        List<Property> asList;
        ModelNode result = parameter;
        try {
            asList = parameter.asPropertyList();
        }
        catch (IllegalArgumentException iae) {
            asList = null;
        }
        if (asList != null) {
            boolean changeMade = false;
            ModelNode newMap = new ModelNode().setEmptyObject();
            for (Property prop : parameter.asPropertyList()) {
                ModelNode converted = this.convertParameterElementExpressions(prop.getValue());
                newMap.get(prop.getName()).set(converted);
                changeMade |= !converted.equals(prop.getValue());
            }
            if (changeMade) {
                result = newMap;
            }
        }
        return result;
    }

    protected ModelNode convertParameterElementExpressions(ModelNode parameterElementValue) {
        return this.isAllowExpression() ? MapAttributeDefinition.convertStringExpression(parameterElementValue) : parameterElementValue;
    }

    public static abstract class Builder<BUILDER extends Builder, ATTRIBUTE extends MapAttributeDefinition>
    extends AbstractAttributeDefinitionBuilder<BUILDER, ATTRIBUTE> {
        protected ParameterValidator elementValidator;
        private Boolean allowNullElement;

        protected Builder(String attributeName) {
            super(attributeName, ModelType.OBJECT);
        }

        protected Builder(String attributeName, boolean optional) {
            super(attributeName, ModelType.OBJECT, optional);
        }

        public Builder(MapAttributeDefinition basis) {
            super(basis);
            this.elementValidator = basis.getElementValidator();
            if (this.elementValidator instanceof NillableOrExpressionParameterValidator) {
                this.allowNullElement = ((NillableOrExpressionParameterValidator)this.elementValidator).getAllowNull();
            }
        }

        public ParameterValidator getElementValidator() {
            if (this.elementValidator == null) {
                return null;
            }
            ParameterValidator toWrap = this.elementValidator;
            NillableOrExpressionParameterValidator wrappedElementValidator = null;
            if (this.elementValidator instanceof NillableOrExpressionParameterValidator) {
                NillableOrExpressionParameterValidator wrapped = (NillableOrExpressionParameterValidator)this.elementValidator;
                Boolean allow = wrapped.getAllowNull();
                if ((allow == null || allow != false) == this.getAllowNullElement() && wrapped.isAllowExpression() == this.isAllowExpression()) {
                    wrappedElementValidator = wrapped;
                } else {
                    toWrap = wrapped.getDelegate();
                }
            }
            if (wrappedElementValidator == null) {
                this.elementValidator = new NillableOrExpressionParameterValidator(toWrap, this.getAllowNullElement(), this.isAllowExpression());
            }
            return this.elementValidator;
        }

        public final BUILDER setElementValidator(ParameterValidator elementValidator) {
            Assert.checkNotNullParam("elementValidator", elementValidator);
            this.elementValidator = elementValidator;
            this.validator = null;
            return (BUILDER)this;
        }

        @Override
        public BUILDER setValidator(ParameterValidator validator) {
            return this.setElementValidator(validator);
        }

        public BUILDER setMapValidator(ParameterValidator validator) {
            return (BUILDER)((Builder)super.setValidator(validator));
        }

        @Override
        public int getMinSize() {
            if (this.minSize < 0) {
                this.minSize = 0;
            }
            return this.minSize;
        }

        @Override
        public int getMaxSize() {
            if (this.maxSize < 1) {
                this.maxSize = Integer.MAX_VALUE;
            }
            return this.maxSize;
        }

        public boolean getAllowNullElement() {
            return this.allowNullElement == null ? this.isAllowNull() : this.allowNullElement.booleanValue();
        }

        public BUILDER setAllowNullElement(boolean allowNullElement) {
            this.allowNullElement = allowNullElement;
            return (BUILDER)this;
        }

        @Override
        public ParameterValidator getValidator() {
            ParameterValidator result = super.getValidator();
            if (result == null) {
                ParameterValidator mapElementValidator = this.getElementValidator();
                assert (mapElementValidator != null);
                result = new MapValidator(this.getElementValidator(), this.isAllowNull(), this.getMinSize(), this.getMaxSize());
            }
            return result;
        }
    }
}

