/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.global.EnhancedSyntaxSupport;
import org.jboss.as.controller.operations.global.GlobalOperationAttributes;
import org.jboss.as.controller.operations.global.ReadAttributeHandler;
import org.jboss.as.controller.operations.global.WriteAttributeHandler;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

abstract class AbstractCollectionHandler
implements OperationStepHandler {
    static final SimpleAttributeDefinition NAME = new SimpleAttributeDefinition("name", ModelType.STRING, false);
    static final SimpleAttributeDefinition VALUE = GlobalOperationAttributes.VALUE;
    private final AttributeDefinition[] attributes;
    private final boolean requiredReadWriteAccess;

    AbstractCollectionHandler(AttributeDefinition ... attributes) {
        this.attributes = attributes;
        this.requiredReadWriteAccess = true;
    }

    AbstractCollectionHandler(boolean requiredReadWrite, AttributeDefinition ... attributes) {
        this.attributes = attributes;
        this.requiredReadWriteAccess = requiredReadWrite;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        NAME.validateAndSet(operation, model);
        for (AttributeDefinition attr : this.attributes) {
            if (attr == VALUE) {
                model.get(VALUE.getName()).set(operation.get(VALUE.getName()));
                continue;
            }
            attr.validateAndSet(operation, model);
        }
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        AttributeAccess attributeAccess;
        ModelNode operationModel = new ModelNode();
        this.populateModel(operation, operationModel);
        String attributeName = NAME.resolveModelAttribute(context, operationModel).asString();
        ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
        boolean useEnhancedSyntax = EnhancedSyntaxSupport.containsEnhancedSyntax(attributeName, registry);
        String attributeExpression = attributeName;
        if (useEnhancedSyntax) {
            attributeName = EnhancedSyntaxSupport.extractAttributeName(attributeName);
        }
        if ((attributeAccess = context.getResourceRegistration().getAttributeAccess(PathAddress.EMPTY_ADDRESS, attributeName)) == null) {
            throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.unknownAttribute(attributeName));
        }
        PathAddress address = PathAddress.pathAddress(operation.get("address"));
        ModelNode readResponse = new ModelNode();
        ModelNode writeOperation = Util.createOperation(WriteAttributeHandler.DEFINITION, address);
        writeOperation.get(NAME.getName()).set(useEnhancedSyntax ? attributeExpression : attributeName);
        ModelNode writeOperationValue = writeOperation.get("value");
        if (attributeAccess.getStorageType() == AttributeAccess.Storage.CONFIGURATION) {
            context.addStep((context1, operation1) -> {
                this.updateModel(context, operationModel, attributeAccess.getAttributeDefinition(), readResponse.get("result"));
                if (this.requiredReadWriteAccess) {
                    writeOperationValue.set(readResponse.get("result"));
                    context.addStep(writeOperation, WriteAttributeHandler.INSTANCE, OperationContext.Stage.MODEL, true);
                }
            }, OperationContext.Stage.MODEL, true);
            ModelNode readAttributeOperation = Util.getReadAttributeOperation(address, useEnhancedSyntax ? attributeExpression : attributeName);
            context.addStep(readResponse, readAttributeOperation, ReadAttributeHandler.INSTANCE, OperationContext.Stage.MODEL, true);
        } else {
            assert (attributeAccess.getStorageType() == AttributeAccess.Storage.RUNTIME);
            if (this.requiredReadWriteAccess) {
                context.addStep(readResponse, writeOperation, WriteAttributeHandler.INSTANCE, OperationContext.Stage.MODEL, true);
            }
            context.addStep((context1, operation1) -> context.addStep((context2, operation2) -> {
                this.updateModel(context2, operationModel, attributeAccess.getAttributeDefinition(), readResponse.get("result"));
                writeOperationValue.set(readResponse.get("result"));
            }, OperationContext.Stage.RUNTIME), OperationContext.Stage.MODEL, true);
            ModelNode readAttributeOperation = Util.getReadAttributeOperation(address, useEnhancedSyntax ? attributeExpression : attributeName);
            context.addStep(readResponse, readAttributeOperation, ReadAttributeHandler.INSTANCE, OperationContext.Stage.MODEL, true);
        }
    }

    abstract void updateModel(OperationContext var1, ModelNode var2, AttributeDefinition var3, ModelNode var4) throws OperationFailedException;
}

