/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.generator;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.generator.PatchConfigBuilder;
import org.jboss.as.patching.generator.PatchElementConfigBuilder;
import org.jboss.as.patching.metadata.BundleItem;
import org.jboss.as.patching.metadata.MiscContentItem;
import org.jboss.as.patching.metadata.ModificationType;
import org.jboss.as.patching.metadata.ModuleItem;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class PatchConfigXml_1_0
implements XMLStreamConstants,
XMLElementReader<PatchConfigBuilder> {
    private boolean patchTypeConfigured;

    PatchConfigXml_1_0() {
    }

    @Override
    public void readElement(XMLExtendedStreamReader reader, PatchConfigBuilder patchConfigBuilder) throws XMLStreamException {
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case NAME: {
                    patchConfigBuilder.setPatchId(reader.getElementText());
                    continue block11;
                }
                case DESCRIPTION: {
                    patchConfigBuilder.setDescription(reader.getElementText());
                    continue block11;
                }
                case ELEMENT: {
                    this.parseElement(reader, patchConfigBuilder);
                    continue block11;
                }
                case UPGRADE: {
                    this.parseCumulativePatchType(reader, patchConfigBuilder);
                    continue block11;
                }
                case ONE_OFF: {
                    this.parseOneOffPatchType(reader, patchConfigBuilder);
                    continue block11;
                }
                case GENERATE_BY_DIFF: {
                    PatchConfigXml_1_0.parseGenerateByDiff(reader, patchConfigBuilder);
                    continue block11;
                }
                case SPECIFIED_CONTENT: {
                    this.parseSpecifiedContent(reader, patchConfigBuilder);
                    continue block11;
                }
                case MISC_FILES: {
                    this.parseMiscFiles(reader, patchConfigBuilder);
                    continue block11;
                }
                case OPTIONAL_PATHS: {
                    this.parseOptionalPaths(reader, patchConfigBuilder);
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseElement(XMLExtendedStreamReader reader, PatchConfigBuilder patchConfigBuilder) throws XMLStreamException {
        String patchID = null;
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATCH_ID: {
                    patchID = value;
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (patchID == null) {
            throw ParseUtils.missingRequired(reader, EnumSet.of(Attribute.PATCH_ID));
        }
        PatchElementConfigBuilder builder = null;
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case UPGRADE: {
                    builder = this.createBuilder(reader, patchConfigBuilder, patchID, Patch.PatchType.CUMULATIVE);
                    continue block10;
                }
                case ONE_OFF: {
                    builder = this.createBuilder(reader, patchConfigBuilder, patchID, Patch.PatchType.ONE_OFF);
                    continue block10;
                }
                case DESCRIPTION: {
                    if (builder == null) {
                        throw ParseUtils.missingRequired(reader, "cumulative", "one-off");
                    }
                    builder.setDescription(reader.getElementText());
                    continue block10;
                }
                case SPECIFIED_CONTENT: {
                    if (builder == null) {
                        throw ParseUtils.missingRequired(reader, "cumulative", "one-off");
                    }
                    this.parseSpecifiedContent(reader, builder);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private PatchElementConfigBuilder createBuilder(XMLExtendedStreamReader reader, PatchConfigBuilder parent, String patchID, Patch.PatchType type) throws XMLStreamException {
        String layerName = null;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    layerName = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (layerName == null) {
            throw ParseUtils.missingRequired(reader, "name");
        }
        ParseUtils.requireNoContent(reader);
        PatchElementConfigBuilder builder = parent.addElement(layerName);
        builder.setPatchId(patchID);
        builder.setPatchType(type);
        return builder;
    }

    private void parseDistributionStructure(XMLExtendedStreamReader reader, PatchConfigBuilder patchConfigBuilder) throws XMLStreamException {
        if (!this.patchTypeConfigured) {
            throw ParseUtils.missingOneOf(reader, EnumSet.of(Element.UPGRADE, Element.ONE_OFF));
        }
        ParseUtils.requireNoAttributes(reader);
        if (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                default: 
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseSlottedContentSearchPaths(XMLExtendedStreamReader reader, PatchConfigBuilder patchConfigBuilder, Element type) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (element == type) {
                this.parseSlottedContentSearchPath(reader, patchConfigBuilder, type);
                continue;
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseSlottedContentSearchPath(XMLExtendedStreamReader reader, PatchConfigBuilder patchConfigBuilder, Element type) throws XMLStreamException {
        String name = null;
        String path = null;
        PatchConfigBuilder.AffectsType affectsType = PatchConfigBuilder.AffectsType.BOTH;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.PATH);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block4;
                }
                case PATH: {
                    path = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired(reader, required);
        }
    }

    private void parseSlottedContentDefaultExclusion(XMLExtendedStreamReader reader, PatchConfigBuilder patchConfigBuilder, Element type) throws XMLStreamException {
        Object affectsType = null;
        int i = 0;
        int count = reader.getAttributeCount();
        if (i < count) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            throw ParseUtils.unexpectedAttribute(reader, i);
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseIgnoredPath(XMLExtendedStreamReader reader, PatchConfigBuilder patchConfigBuilder) throws XMLStreamException {
        String path = null;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATH: {
                    path = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
        if (path == null) {
            throw ParseUtils.missingRequired(reader, EnumSet.of(Attribute.PATH));
        }
    }

    private void parseCumulativePatchType(XMLExtendedStreamReader reader, PatchConfigBuilder builder) throws XMLStreamException {
        String name = null;
        String appliesTo = null;
        String resulting = null;
        Set required = Collections.emptySet();
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block5;
                }
                case APPLIES_TO_VERSION: {
                    appliesTo = value;
                    continue block5;
                }
                case RESULTING_VERSION: {
                    resulting = value;
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired(reader, required);
        }
        builder.setAppliesToName(name);
        builder.setCumulativeType(appliesTo, resulting);
        this.patchTypeConfigured = true;
    }

    private void parseOneOffPatchType(XMLExtendedStreamReader reader, PatchConfigBuilder builder) throws XMLStreamException {
        String name = null;
        String appliesTo = null;
        Set required = Collections.emptySet();
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block4;
                }
                case APPLIES_TO_VERSION: {
                    appliesTo = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired(reader, required);
        }
        builder.setOneOffType(appliesTo);
        builder.setAppliesToName(name);
        this.patchTypeConfigured = true;
    }

    private static void parseGenerateByDiff(XMLExtendedStreamReader reader, PatchConfigBuilder patchConfigBuilder) throws XMLStreamException {
        patchConfigBuilder.setGenerateByDiff(true);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case IN_RUNTIME_USE: {
                    PatchConfigXml_1_0.parseInRuntimeUse(reader, patchConfigBuilder);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private static void parseInRuntimeUse(XMLExtendedStreamReader reader, PatchConfigBuilder patchConfigBuilder) throws XMLStreamException {
        String path = null;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATH: {
                    path = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (path == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.PATH.name));
        }
        ParseUtils.requireNoContent(reader);
        patchConfigBuilder.addRuntimeUseItem(path);
    }

    private void parseSpecifiedContent(XMLExtendedStreamReader reader, PatchElementConfigBuilder patchConfigBuilder) throws XMLStreamException {
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case MODULES: {
                    this.parseModules(reader, patchConfigBuilder);
                    continue block4;
                }
                case BUNDLES: {
                    this.parseBundles(reader, patchConfigBuilder);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseSpecifiedContent(XMLExtendedStreamReader reader, PatchConfigBuilder patchConfigBuilder) throws XMLStreamException {
        patchConfigBuilder.setGenerateByDiff(false);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case MISC_FILES: {
                    this.parseMiscFiles(reader, patchConfigBuilder);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseModules(XMLExtendedStreamReader reader, PatchElementConfigBuilder builder) throws XMLStreamException {
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ADDED: {
                    this.parseSlottedItem(reader, ModificationType.ADD, false, builder);
                    continue block5;
                }
                case UPDATED: {
                    this.parseSlottedItem(reader, ModificationType.MODIFY, false, builder);
                    continue block5;
                }
                case REMOVED: {
                    this.parseSlottedItem(reader, ModificationType.REMOVE, false, builder);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseMiscFiles(XMLExtendedStreamReader reader, PatchConfigBuilder builder) throws XMLStreamException {
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ADDED: {
                    this.parseMiscModification(reader, ModificationType.ADD, builder);
                    continue block5;
                }
                case UPDATED: {
                    this.parseMiscModification(reader, ModificationType.MODIFY, builder);
                    continue block5;
                }
                case REMOVED: {
                    this.parseMiscModification(reader, ModificationType.REMOVE, builder);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseBundles(XMLExtendedStreamReader reader, PatchElementConfigBuilder builder) throws XMLStreamException {
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ADDED: {
                    this.parseSlottedItem(reader, ModificationType.ADD, true, builder);
                    continue block5;
                }
                case UPDATED: {
                    this.parseSlottedItem(reader, ModificationType.MODIFY, true, builder);
                    continue block5;
                }
                case REMOVED: {
                    this.parseSlottedItem(reader, ModificationType.REMOVE, true, builder);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseSlottedItem(XMLExtendedStreamReader reader, ModificationType modificationType, boolean bundle2, PatchElementConfigBuilder builder) throws XMLStreamException {
        String name = null;
        String slot = "main";
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block4;
                }
                case SLOT: {
                    slot = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
        ModuleItem item = bundle2 ? new BundleItem(name, slot, IoUtils.NO_CONTENT) : new ModuleItem(name, slot, IoUtils.NO_CONTENT);
        builder.getSpecifiedContent().add(item);
    }

    private void parseMiscModification(XMLExtendedStreamReader reader, ModificationType modificationType, PatchConfigBuilder builder) throws XMLStreamException {
        String[] parsed;
        String path = null;
        boolean affectsRuntime = false;
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DIRECTORY: {
                    boolean directory = Boolean.parseBoolean(value);
                    continue block5;
                }
                case PATH: {
                    path = value;
                    continue block5;
                }
                case IN_RUNTIME_USE: {
                    affectsRuntime = Boolean.parseBoolean(value);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
        if (affectsRuntime) {
            builder.addRuntimeUseItem(path);
        }
        MiscContentItem item = (parsed = path.split("/")).length > 0 ? new MiscContentItem(parsed[parsed.length - 1], Arrays.copyOf(parsed, parsed.length - 1), IoUtils.NO_CONTENT) : new MiscContentItem(path, new String[0], IoUtils.NO_CONTENT);
        builder.getSpecifiedContent().add(item);
    }

    private void parseOptionalPaths(XMLExtendedStreamReader reader, PatchConfigBuilder builder) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PATH: {
                    this.parseOptionalPath(reader, builder);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseOptionalPath(XMLExtendedStreamReader reader, PatchConfigBuilder builder) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String value = null;
        String requires = null;
        block4: for (int i = 0; i < count; ++i) {
            String attrValue = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case VALUE: {
                    value = attrValue;
                    continue block4;
                }
                case REQUIRES: {
                    requires = attrValue;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        builder.addOptionalPath(value, requires);
        ParseUtils.requireNoContent(reader);
    }

    static enum Attribute {
        APPLIES_TO_VERSION("applies-to-version"),
        DIRECTORY("directory"),
        IN_RUNTIME_USE("in-runtime-use"),
        NAME("name"),
        PATCH_ID("patch-id"),
        PATH("path"),
        REQUIRES("requires"),
        RESULTING_VERSION("resulting-version"),
        SLOT("slot"),
        VALUE("value"),
        UNKNOWN(null);

        private final String name;
        static Map<String, Attribute> attributes;

        private Attribute(String name) {
            this.name = name;
        }

        static Attribute forName(String name) {
            Attribute attribute = attributes.get(name);
            return attribute == null ? UNKNOWN : attribute;
        }

        static {
            attributes = new HashMap<String, Attribute>();
            for (Attribute attribute : Attribute.values()) {
                if (attribute == UNKNOWN) continue;
                attributes.put(attribute.name, attribute);
            }
        }
    }

    static enum Element {
        ADDED("added"),
        APPLIES_TO_VERSION("applies-to-version"),
        BUNDLES("bundles"),
        DESCRIPTION("description"),
        ELEMENT("element"),
        GENERATE_BY_DIFF("generate-by-diff"),
        IN_RUNTIME_USE("in-runtime-use"),
        MISC_FILES("misc-files"),
        MODULES("modules"),
        NAME("name"),
        ONE_OFF("one-off"),
        OPTIONAL_PATHS("optional-paths"),
        PATCH_CONFIG("patch-config"),
        PATH("path"),
        REMOVED("removed"),
        SPECIFIED_CONTENT("specified-content"),
        UPDATED("updated"),
        UPGRADE("cumulative"),
        UNKNOWN(null);

        final String name;
        static Map<String, Element> elements;

        private Element(String name) {
            this.name = name;
        }

        static Element forName(String name) {
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        static {
            elements = new HashMap<String, Element>();
            for (Element element : Element.values()) {
                if (element == UNKNOWN) continue;
                elements.put(element.name, element);
            }
        }
    }
}

