/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations;

import java.util.ArrayList;
import java.util.Map;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.NonResolvingResourceDescriptionResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;

public final class MultistepUtil {
    private MultistepUtil() {
    }

    public static <T> void recordOperationSteps(OperationContext context, Map<T, ModelNode> operations, Map<T, ModelNode> responses) throws OperationFailedException {
        MultistepUtil.recordOperationSteps(context, operations, responses, OperationHandlerResolver.DEFAULT, false, true);
    }

    public static <T> void recordOperationSteps(OperationContext context, Map<T, ModelNode> operations, Map<T, ModelNode> responses, OperationHandlerResolver handlerResolver, boolean adjustAddresses, boolean rejectPrivateOperations) throws OperationFailedException {
        assert (responses != null);
        assert (responses.isEmpty() || operations.size() == responses.size());
        boolean responsesProvided = !responses.isEmpty();
        PathAddress currentAddress = adjustAddresses ? context.getCurrentAddress() : null;
        ArrayList<OpData> opdatas = new ArrayList<OpData>();
        OpData previousOpData = null;
        for (Map.Entry<T, ModelNode> entry : operations.entrySet()) {
            ModelNode response;
            ModelNode modelNode = response = responsesProvided ? responses.get(entry.getKey()) : new ModelNode();
            assert (response != null) : "No response provided for " + entry.getValue();
            ModelNode op = entry.getValue();
            PathAddress stepAddress = PathAddress.pathAddress(op.get("address"));
            if (adjustAddresses) {
                stepAddress = currentAddress.append(stepAddress);
                op.get("address").set(stepAddress.toModelNode());
            }
            boolean allowDeferredResolution = previousOpData != null && previousOpData.allowDeferredResolution;
            boolean requireReResolution = previousOpData != null && previousOpData.requireReResolution;
            OpData opData = MultistepUtil.getOpData(context, op, response, stepAddress, handlerResolver, rejectPrivateOperations, allowDeferredResolution, requireReResolution);
            opdatas.add(0, opData);
            previousOpData = opData;
            if (responsesProvided) continue;
            responses.put(entry.getKey(), response);
        }
        for (OpData opData : opdatas) {
            context.addModelStep(opData.response, opData.operation, opData.definition, opData.handler, true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static OpData getOpData(OperationContext context, ModelNode subOperation, ModelNode response, PathAddress stepAddress, OperationHandlerResolver handlerResolver, boolean rejectPrivateOperations, boolean allowDeferredResolution, boolean requireReResolution) throws OperationFailedException {
        OperationDefinition operationDefinition;
        OperationStepHandler osh;
        String stepOpName;
        block7: {
            ImmutableManagementResourceRegistration registry = context.getRootResourceRegistration();
            stepOpName = subOperation.require("operation").asString();
            OperationEntry operationEntry = registry.getOperationEntry(stepAddress, stepOpName);
            ControllerLogger.MGMT_OP_LOGGER.tracef("Getting OpDate for op %s at %s with deferred resolution %s", (Object)stepOpName, (Object)stepAddress, (Object)allowDeferredResolution);
            if (operationEntry == null) {
                ImmutableManagementResourceRegistration child = registry.getSubModel(stepAddress);
                if (child != null) {
                    throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.noHandlerForOperation(stepOpName, stepAddress));
                }
                if (allowDeferredResolution && MultistepUtil.isSubsystem(stepAddress)) {
                    ControllerLogger.MGMT_OP_LOGGER.tracef("Deferred resolution for op %s at %s", (Object)stepOpName, (Object)stepAddress);
                    osh = new DeferredResolutionHandler(subOperation, response, stepAddress, handlerResolver, rejectPrivateOperations);
                    operationDefinition = SimpleOperationDefinitionBuilder.of(stepOpName, NonResolvingResourceDescriptionResolver.INSTANCE).build();
                    break block7;
                } else {
                    ControllerLogger.MGMT_OP_LOGGER.tracef("No resource registration for op %s at %s", (Object)stepOpName, (Object)stepAddress);
                    throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.noSuchResourceType(stepAddress));
                }
            }
            if (operationEntry.getType() == OperationEntry.EntryType.PRIVATE && (rejectPrivateOperations || subOperation.hasDefined("operation-headers", "caller-type") && "user".equals(subOperation.get("operation-headers", "caller-type").asString()))) {
                throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.noHandlerForOperation(stepOpName, stepAddress));
            }
            operationDefinition = operationEntry.getOperationDefinition();
            if (requireReResolution && MultistepUtil.isSubsystem(stepAddress)) {
                ControllerLogger.MGMT_OP_LOGGER.tracef("Re-resolution for op %s at %s", (Object)stepOpName, (Object)stepAddress);
                osh = new DeferredResolutionHandler(subOperation, response, stepAddress, handlerResolver, rejectPrivateOperations);
            } else {
                osh = handlerResolver.getOperationStepHandler(stepOpName, stepAddress, subOperation, operationEntry);
            }
        }
        boolean allowDeferred = allowDeferredResolution || "add".equals(stepOpName) && MultistepUtil.isExtensionAddress(stepAddress);
        boolean requireReRes = requireReResolution || "remove".equals(stepOpName) && MultistepUtil.isExtensionAddress(stepAddress);
        return new OpData(subOperation, operationDefinition, osh, response, allowDeferred, requireReRes);
    }

    private static boolean isSubsystem(PathAddress stepAddress) {
        int size = stepAddress.size();
        if (size == 1) {
            return "subsystem".equals(stepAddress.getElement(0).getKey());
        }
        if (size > 1) {
            String firstKey = stepAddress.getElement(0).getKey();
            return "subsystem".equals(stepAddress.getElement(1).getKey()) && ("profile".equals(firstKey) || "host".equals(firstKey));
        }
        return false;
    }

    private static boolean isExtensionAddress(PathAddress address) {
        return address.size() == 1 && "extension".equals(address.getElement(0).getKey()) || address.size() == 2 && "extension".equals(address.getElement(1).getKey()) && "host".equals(address.getElement(0).getKey());
    }

    public static interface OperationHandlerResolver {
        public static final OperationHandlerResolver DEFAULT = new OperationHandlerResolver(){};

        default public OperationStepHandler getOperationStepHandler(String operationName, PathAddress address, ModelNode operation, OperationEntry operationEntry) {
            return operationEntry.getOperationHandler();
        }
    }

    private static class DeferredResolutionHandler
    implements OperationStepHandler {
        private final ModelNode deferredOperation;
        private final ModelNode deferredResponse;
        private final PathAddress deferredAddress;
        private final OperationHandlerResolver handlerResolver;
        private final boolean rejectPrivateOperations;

        private DeferredResolutionHandler(ModelNode deferredOperation, ModelNode deferredResponse, PathAddress deferredAddress, OperationHandlerResolver handlerResolver, boolean rejectPrivateOperations) {
            this.deferredOperation = deferredOperation;
            this.deferredResponse = deferredResponse;
            this.deferredAddress = deferredAddress;
            this.handlerResolver = handlerResolver;
            this.rejectPrivateOperations = rejectPrivateOperations;
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            OpData opData = MultistepUtil.getOpData(context, this.deferredOperation, this.deferredResponse, this.deferredAddress, this.handlerResolver, this.rejectPrivateOperations, false, false);
            context.addModelStep(opData.response, opData.operation, opData.definition, opData.handler, true);
        }
    }

    private static class OpData {
        private final ModelNode operation;
        private final OperationDefinition definition;
        private final OperationStepHandler handler;
        private final ModelNode response;
        private final boolean allowDeferredResolution;
        private final boolean requireReResolution;

        private OpData(ModelNode operation, OperationDefinition definition, OperationStepHandler handler, ModelNode response, boolean allowDeferredResolution, boolean requireReResolution) {
            this.definition = definition;
            this.operation = operation;
            this.handler = handler;
            this.response = response;
            this.allowDeferredResolution = allowDeferredResolution;
            this.requireReResolution = requireReResolution;
        }
    }
}

