/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.remote.ResponseAttachmentInputStreamSupport;
import org.jboss.as.protocol.mgmt.support.ManagementChannelInitialization;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.threads.EnhancedQueueExecutor;
import org.jboss.threads.JBossThreadFactory;

public abstract class AbstractModelControllerOperationHandlerFactoryService
implements Service<AbstractModelControllerOperationHandlerFactoryService>,
ManagementChannelInitialization {
    public static final ServiceName OPERATION_HANDLER_NAME_SUFFIX = ServiceName.of("operation", "handler");
    private static final int WORK_QUEUE_SIZE = 512;
    private static final int POOL_CORE_SIZE = 4;
    private static final int POOL_MAX_SIZE = 4;
    private final Consumer<AbstractModelControllerOperationHandlerFactoryService> serviceConsumer;
    private final Supplier<ModelController> modelControllerSupplier;
    private final Supplier<ExecutorService> executorSupplier;
    private final Supplier<ScheduledExecutorService> scheduledExecutorSupplier;
    private ResponseAttachmentInputStreamSupport responseAttachmentSupport;
    private ExecutorService clientRequestExecutor;

    protected AbstractModelControllerOperationHandlerFactoryService(Consumer<AbstractModelControllerOperationHandlerFactoryService> serviceConsumer, Supplier<ModelController> modelControllerSupplier, Supplier<ExecutorService> executorSupplier, Supplier<ScheduledExecutorService> scheduledExecutorSupplier) {
        this.serviceConsumer = serviceConsumer;
        this.modelControllerSupplier = modelControllerSupplier;
        this.executorSupplier = executorSupplier;
        this.scheduledExecutorSupplier = scheduledExecutorSupplier;
    }

    @Override
    public synchronized void start(StartContext context) throws StartException {
        ControllerLogger.MGMT_OP_LOGGER.debugf("Starting operation handler service %s", (Object)context.getController().getName());
        this.responseAttachmentSupport = new ResponseAttachmentInputStreamSupport(this.scheduledExecutorSupplier.get());
        ThreadFactory threadFactory = AccessController.doPrivileged(new PrivilegedAction<JBossThreadFactory>(){

            @Override
            public JBossThreadFactory run() {
                return new JBossThreadFactory(new ThreadGroup("management-handler-thread"), Boolean.FALSE, null, "%G - %t", null, null);
            }
        });
        if (EnhancedQueueExecutor.DISABLE_HINT) {
            ThreadPoolExecutor executor = new ThreadPoolExecutor(4, 4, 600L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(512), threadFactory);
            executor.allowCoreThreadTimeOut(true);
            this.clientRequestExecutor = executor;
        } else {
            this.clientRequestExecutor = new EnhancedQueueExecutor.Builder().setCorePoolSize(4).setMaximumPoolSize(4).setKeepAliveTime(600L, TimeUnit.SECONDS).setMaximumQueueSize(512).setThreadFactory(threadFactory).allowCoreThreadTimeOut(true).build();
        }
        this.serviceConsumer.accept(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop(final StopContext stopContext) {
        this.serviceConsumer.accept(null);
        ExecutorService executorService = this.executorSupplier.get();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractModelControllerOperationHandlerFactoryService.this.responseAttachmentSupport.shutdown();
                    AbstractModelControllerOperationHandlerFactoryService.this.clientRequestExecutor.shutdown();
                }
                finally {
                    stopContext.complete();
                }
            }
        };
        try {
            executorService.execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            stopContext.asynchronous();
        }
    }

    @Override
    public synchronized AbstractModelControllerOperationHandlerFactoryService getValue() throws IllegalStateException {
        return this;
    }

    protected ModelController getController() {
        return this.modelControllerSupplier.get();
    }

    protected ExecutorService getExecutor() {
        return this.executorSupplier.get();
    }

    protected ResponseAttachmentInputStreamSupport getResponseAttachmentSupport() {
        return this.responseAttachmentSupport;
    }

    protected final ExecutorService getClientRequestExecutor() {
        return this.clientRequestExecutor;
    }
}

