/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.jboss.modules.DelegatingModuleLoader;
import org.jboss.modules.LocalModuleFinder;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.PathFilter;
import org.wildfly.security.manager.WildFlySecurityManager;

class TemporaryModuleLayer
implements Closeable {
    private final ModuleLoader loader;
    private final LocalModuleFinder moduleFinder;

    private TemporaryModuleLayer(ModuleLoader loader, LocalModuleFinder moduleFinder) {
        this.loader = loader;
        this.moduleFinder = moduleFinder;
    }

    static TemporaryModuleLayer create(PathFilter filter) {
        ModuleClassLoader classLoader = (ModuleClassLoader)WildFlySecurityManager.getClassLoaderPrivileged(TemporaryModuleLayer.class);
        ModuleLoader systemLoader = classLoader.getModule().getModuleLoader();
        File[] roots = InternalLayeredModulePathFactory.resolveLayeredModulePath(TemporaryModuleLayer.getModulePathFiles());
        LocalModuleFinder cliModuleFinder = new LocalModuleFinder(roots, filter);
        DelegatingModuleLoader cliLoader = new DelegatingModuleLoader(systemLoader, cliModuleFinder);
        return new TemporaryModuleLayer(cliLoader, cliModuleFinder);
    }

    private static File[] getModulePathFiles() {
        return TemporaryModuleLayer.getFiles(WildFlySecurityManager.getPropertyPrivileged("module.path", WildFlySecurityManager.getSystemEnvironmentPrivileged().get("JAVA_MODULEPATH")), 0, 0);
    }

    private static File[] getFiles(String modulePath, int stringIdx, int arrayIdx) {
        File[] files;
        if (modulePath == null) {
            return new File[0];
        }
        int i = modulePath.indexOf(File.pathSeparatorChar, stringIdx);
        if (i == -1) {
            files = new File[arrayIdx + 1];
            files[arrayIdx] = new File(modulePath.substring(stringIdx)).getAbsoluteFile();
        } else {
            files = TemporaryModuleLayer.getFiles(modulePath, i + 1, arrayIdx + 1);
            files[arrayIdx] = new File(modulePath.substring(stringIdx, i)).getAbsoluteFile();
        }
        return files;
    }

    ModuleLoader getModuleLoader() {
        return this.loader;
    }

    @Override
    public void close() throws IOException {
        this.moduleFinder.close();
    }

    private static class InternalLayeredModulePathFactory {
        private static final String OVERLAYS = ".overlays";

        private InternalLayeredModulePathFactory() {
        }

        static File[] resolveLayeredModulePath(File ... modulePath) {
            boolean foundLayers = false;
            ArrayList<File> layeredPath = new ArrayList<File>();
            for (File file : modulePath) {
                layeredPath.add(file);
                LayersConfig layersConfig = InternalLayeredModulePathFactory.getLayersConfig(file);
                File layersDir = new File(file, layersConfig.getLayersPath());
                if (!layersDir.exists()) {
                    if (!layersConfig.isConfigured()) continue;
                    throw new IllegalStateException("No layers directory found at " + layersDir);
                }
                boolean validLayers = true;
                ArrayList<File> layerFiles = new ArrayList<File>();
                for (String layerName : layersConfig.getLayers()) {
                    File layer = new File(layersDir, layerName);
                    if (!layer.exists()) {
                        if (layersConfig.isConfigured()) {
                            throw new IllegalStateException(String.format("Cannot find layer %s under directory %s", layerName, layersDir));
                        }
                        validLayers = false;
                        break;
                    }
                    InternalLayeredModulePathFactory.loadOverlays(layer, layerFiles);
                }
                if (!validLayers) continue;
                foundLayers = true;
                layeredPath.addAll(layerFiles);
                File[] addOns = new File(file, layersConfig.getAddOnsPath()).listFiles();
                if (addOns == null) continue;
                for (File addOn : addOns) {
                    if (!addOn.isDirectory()) continue;
                    InternalLayeredModulePathFactory.loadOverlays(addOn, layeredPath);
                }
            }
            return foundLayers ? layeredPath.toArray(new File[layeredPath.size()]) : modulePath;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static LayersConfig getLayersConfig(File repoRoot) {
            File layersList = new File(repoRoot, "layers.conf");
            if (!layersList.exists()) {
                return new LayersConfig();
            }
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(layersList), "UTF-8");){
                Properties props = new Properties();
                props.load(reader);
                LayersConfig layersConfig = new LayersConfig(props);
                return layersConfig;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        static void loadOverlays(File layeringRoot, List<File> path) {
            File refs;
            File overlays = new File(layeringRoot, OVERLAYS);
            if (overlays.exists() && (refs = new File(overlays, OVERLAYS)).exists()) {
                try {
                    for (String overlay : InternalLayeredModulePathFactory.readRefs(refs)) {
                        File root = new File(overlays, overlay);
                        path.add(root);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            path.add(layeringRoot);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static List<String> readRefs(File file) throws IOException {
            if (!file.exists()) {
                return Collections.emptyList();
            }
            FileInputStream is = new FileInputStream(file);
            try {
                List<String> list = InternalLayeredModulePathFactory.readRefs(is);
                return list;
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }

        static List<String> readRefs(InputStream is) throws IOException {
            ArrayList<String> refs = new ArrayList<String>();
            StringBuffer buffer = new StringBuffer();
            do {
                String ref;
                if (buffer.length() <= 0 || (ref = buffer.toString().trim()).length() <= 0) continue;
                refs.add(ref);
            } while (InternalLayeredModulePathFactory.readLine(is, buffer));
            return refs;
        }

        static boolean readLine(InputStream is, StringBuffer buffer) throws IOException {
            buffer.setLength(0);
            block5: while (true) {
                int c = is.read();
                switch (c) {
                    case 9: 
                    case 13: {
                        continue block5;
                    }
                    case -1: {
                        return false;
                    }
                    case 10: {
                        return true;
                    }
                }
                buffer.append((char)c);
            }
        }

        private static class LayersConfig {
            private static final String DEFAULT_LAYERS_PATH = "system/layers";
            private static final String DEFAULT_ADD_ONS_PATH = "system/add-ons";
            private final boolean configured;
            private final String layersPath;
            private final String addOnsPath;
            private final List<String> layers;

            private LayersConfig() {
                this.configured = false;
                this.layersPath = DEFAULT_LAYERS_PATH;
                this.addOnsPath = DEFAULT_ADD_ONS_PATH;
                this.layers = Collections.singletonList("base");
            }

            private LayersConfig(Properties properties) {
                this.configured = true;
                this.layersPath = DEFAULT_LAYERS_PATH;
                this.addOnsPath = DEFAULT_ADD_ONS_PATH;
                boolean excludeBase = false;
                String layersProp = (String)properties.get("layers");
                if (layersProp == null || (layersProp = layersProp.trim()).length() == 0) {
                    this.layers = excludeBase ? Collections.emptyList() : Collections.singletonList("base");
                } else {
                    String[] layerNames = layersProp.split(",");
                    this.layers = new ArrayList<String>();
                    boolean hasBase = false;
                    for (String layerName : layerNames) {
                        if ("base".equals(layerName)) {
                            hasBase = true;
                        }
                        this.layers.add(layerName);
                    }
                    if (!hasBase && !excludeBase) {
                        this.layers.add("base");
                    }
                }
            }

            boolean isConfigured() {
                return this.configured;
            }

            String getLayersPath() {
                return this.layersPath;
            }

            String getAddOnsPath() {
                return this.addOnsPath;
            }

            List<String> getLayers() {
                return this.layers;
            }
        }
    }
}

