/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ManagementModel;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectMapAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

final class ValidateModelStepHandler
implements OperationStepHandler {
    static final String INTERNAL_MODEL_VALIDATION_NAME = "internal-model-validation";
    private final ManagementModel managementModel;
    private final Set<PathAddress> toValidate;
    private final OperationStepHandler extraValidationStepHandler;

    ValidateModelStepHandler(ManagementModel managementModel, Set<PathAddress> toValidate, OperationStepHandler extraValidationStepHandler) {
        this.managementModel = managementModel;
        this.toValidate = new HashSet<PathAddress>(toValidate);
        this.extraValidationStepHandler = extraValidationStepHandler;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        HashMap<PathAddress, ResAndReg> resolved = new HashMap<PathAddress, ResAndReg>();
        for (PathAddress pa : this.toValidate) {
            this.validateAddress(context, pa, resolved);
        }
    }

    private void validateAddress(OperationContext context, PathAddress address, Map<PathAddress, ResAndReg> resolved) throws OperationFailedException {
        Set<String> definedKeys;
        ModelNode model;
        ResAndReg resAndReg = this.loadResource(address, resolved);
        if (resAndReg == null || resAndReg.resource == null) {
            return;
        }
        if (this.extraValidationStepHandler != null) {
            ModelNode op = Util.createOperation(INTERNAL_MODEL_VALIDATION_NAME, address);
            context.addStep(op, this.extraValidationStepHandler, OperationContext.Stage.MODEL);
        }
        if ((model = resAndReg.resource.getModel()).isDefined()) {
            Set<String> keys = model.keys();
            definedKeys = new HashSet(keys.size());
            for (String string : keys) {
                if (!model.hasDefined(string)) continue;
                definedKeys.add(string);
            }
        } else {
            definedKeys = Collections.emptySet();
        }
        final Map<String, AttributeAccess> attributes = resAndReg.reg.getAttributes(PathAddress.EMPTY_ADDRESS);
        for (Map.Entry entry : attributes.entrySet()) {
            AttributeAccess access = (AttributeAccess)entry.getValue();
            if (access.getStorageType() != AttributeAccess.Storage.CONFIGURATION) continue;
            final String attributeName = (String)entry.getKey();
            final AttributeDefinition attr = access.getAttributeDefinition();
            if (!definedKeys.contains(attributeName)) {
                if (!this.isRequired(attr, definedKeys)) continue;
                this.attemptReadMissingAttributeValueFromHandler(context, address, access, attributeName, new ErrorHandler(){

                    @Override
                    public void throwError() throws OperationFailedException {
                        String[] alternatives = attr.getAlternatives();
                        if (alternatives == null) {
                            throw ControllerLogger.ROOT_LOGGER.required(attributeName);
                        }
                        HashSet<String> requiredAlternatives = new HashSet<String>();
                        for (int i = 0; i < alternatives.length; ++i) {
                            AttributeDefinition requiredAttr = ValidateModelStepHandler.getAttributeDefinition(alternatives[i], attributes);
                            if (requiredAttr == null || !requiredAttr.isRequired() || requiredAttr.isResourceOnly()) continue;
                            requiredAlternatives.add(alternatives[i]);
                        }
                        throw ControllerLogger.ROOT_LOGGER.requiredWithAlternatives(attributeName, requiredAlternatives);
                    }
                });
                continue;
            }
            String[] requires = attr.getRequires();
            if (requires != null) {
                for (final String required : requires) {
                    if (definedKeys.contains(required)) continue;
                    AttributeDefinition requiredAttr = ValidateModelStepHandler.getAttributeDefinition(required, attributes);
                    if (requiredAttr == null) {
                        ControllerLogger.ROOT_LOGGER.debugf("AttributeDefinition for %s required by %s is null", (Object)required, (Object)attributeName);
                        continue;
                    }
                    if (this.hasAlternative(this.getRelevantAlteratives(requiredAttr.getAlternatives(), requires), definedKeys)) continue;
                    this.attemptReadMissingAttributeValueFromHandler(context, address, access, attributeName, new ErrorHandler(){

                        @Override
                        public void throwError() throws OperationFailedException {
                            throw ControllerLogger.ROOT_LOGGER.requiredAttributeNotSet(required, attr.getName());
                        }
                    });
                }
            }
            if (!this.isAllowed(attr, definedKeys)) {
                String[] alts = attr.getAlternatives();
                StringBuilder sb = null;
                if (alts != null) {
                    for (String alt : alts) {
                        if (!definedKeys.contains(alt)) continue;
                        if (sb == null) {
                            sb = new StringBuilder();
                        } else {
                            sb.append(", ");
                        }
                        sb.append(alt);
                    }
                }
                throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.invalidAttributeCombo(attributeName, sb));
            }
            this.handleObjectAttributes(model, attr, attributeName);
        }
    }

    private static AttributeDefinition getAttributeDefinition(String name, Map<String, AttributeAccess> attributes) {
        AttributeAccess aa = attributes.get(name);
        return aa == null ? null : aa.getAttributeDefinition();
    }

    private static AttributeDefinition getAttributeDefinition(String name, AttributeDefinition[] attrs) {
        for (AttributeDefinition peer : attrs) {
            if (!name.equals(peer.getName())) continue;
            return peer;
        }
        return null;
    }

    private void attemptReadMissingAttributeValueFromHandler(OperationContext context, PathAddress address, AttributeAccess attributeAccess, String attributeName, final ErrorHandler errorHandler) throws OperationFailedException {
        OperationStepHandler handler = attributeAccess.getReadHandler();
        if (handler == null) {
            errorHandler.throwError();
        } else {
            ModelNode readAttr = Util.getReadAttributeOperation(address, attributeName);
            final ModelNode resultHolder = new ModelNode();
            context.addStep(resultHolder, readAttr, handler, OperationContext.Stage.MODEL, true);
            context.addStep(new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    if (!resultHolder.isDefined() && !resultHolder.hasDefined("result")) {
                        errorHandler.throwError();
                    }
                }
            }, OperationContext.Stage.MODEL);
        }
    }

    private void handleObjectAttributes(ModelNode model, AttributeDefinition attr, String absoluteParentName) throws OperationFailedException {
        block3: {
            block4: {
                block2: {
                    if (!(attr instanceof ObjectTypeAttributeDefinition)) break block2;
                    this.validateNestedAttributes(model.get(attr.getName()), (ObjectTypeAttributeDefinition)attr, absoluteParentName);
                    break block3;
                }
                if (!(attr instanceof ObjectListAttributeDefinition)) break block4;
                ObjectTypeAttributeDefinition valueType = ((ObjectListAttributeDefinition)attr).getValueType();
                ModelNode list = model.get(attr.getName());
                for (int i = 0; i < list.asInt(); ++i) {
                    this.validateNestedAttributes(list.get(i), valueType, absoluteParentName + "[" + i + "]");
                }
                break block3;
            }
            if (!(attr instanceof ObjectMapAttributeDefinition)) break block3;
            ObjectTypeAttributeDefinition valueType = ((ObjectMapAttributeDefinition)attr).getValueType();
            ModelNode map = model.get(attr.getName());
            for (String key : map.keys()) {
                this.validateNestedAttributes(map.get(key), valueType, absoluteParentName + "." + key);
            }
        }
    }

    private void validateNestedAttributes(ModelNode subModel, ObjectTypeAttributeDefinition attr, String absoluteParentName) throws OperationFailedException {
        AttributeDefinition[] subAttrs;
        if (!subModel.isDefined()) {
            return;
        }
        Set<String> keys = subModel.keys();
        HashSet<String> definedKeys = new HashSet<String>(keys.size());
        for (String key : keys) {
            if (!subModel.hasDefined(key)) continue;
            definedKeys.add(key);
        }
        for (AttributeDefinition subAttr : subAttrs = attr.getValueTypes()) {
            String subAttributeName = subAttr.getName();
            String absoluteName = absoluteParentName + "." + subAttributeName;
            if (!definedKeys.contains(subAttributeName)) {
                if (!this.isRequired(subAttr, definedKeys)) continue;
                String[] alternatives = attr.getAlternatives();
                if (alternatives == null) {
                    throw ControllerLogger.ROOT_LOGGER.required(subAttributeName);
                }
                HashSet requiredAlternatives = new HashSet();
                for (int i = 0; i < alternatives.length; ++i) {
                    AttributeDefinition requiredAttr = ValidateModelStepHandler.getAttributeDefinition(alternatives[i], subAttrs);
                    if (requiredAttr == null || !requiredAttr.isRequired() || requiredAttr.isResourceOnly()) continue;
                    requiredAlternatives.add(alternatives[i]);
                }
                throw ControllerLogger.ROOT_LOGGER.requiredWithAlternatives(subAttributeName, requiredAlternatives);
            }
            String[] requires = subAttr.getRequires();
            if (requires != null) {
                for (String required : requires) {
                    if (definedKeys.contains(required)) continue;
                    AttributeDefinition requiredAttr = ValidateModelStepHandler.getAttributeDefinition(required, subAttrs);
                    if (requiredAttr == null) {
                        ControllerLogger.ROOT_LOGGER.debugf("AttributeDefinition for %s required by %s of %s is null", (Object)required, (Object)subAttributeName, (Object)absoluteParentName);
                        continue;
                    }
                    if (this.hasAlternative(this.getRelevantAlteratives(requiredAttr.getAlternatives(), requires), definedKeys)) continue;
                    throw ControllerLogger.ROOT_LOGGER.requiredAttributeNotSet(absoluteParentName + "." + required, absoluteName);
                }
            }
            if (!this.isAllowed(subAttr, definedKeys)) {
                String[] alts = subAttr.getAlternatives();
                StringBuilder sb = null;
                if (alts != null) {
                    for (String alt : alts) {
                        if (!definedKeys.contains(alt)) continue;
                        if (sb == null) {
                            sb = new StringBuilder();
                        } else {
                            sb.append(", ");
                        }
                        sb.append(absoluteParentName).append(".").append(alt);
                    }
                }
                throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.invalidAttributeCombo(absoluteName, sb));
            }
            this.handleObjectAttributes(subModel, subAttr, absoluteName);
        }
    }

    private boolean isRequired(AttributeDefinition def, Set<String> definedKeys) {
        return def.isRequired() && !def.isResourceOnly() && !this.hasAlternative(def.getAlternatives(), definedKeys);
    }

    private boolean isAllowed(AttributeDefinition def, Set<String> definedKeys) {
        String[] alternatives = def.getAlternatives();
        if (alternatives != null) {
            for (String alternative : alternatives) {
                if (!definedKeys.contains(alternative)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean hasAlternative(String[] alternatives, Set<String> definedKeys) {
        if (alternatives != null) {
            for (String alternative : alternatives) {
                if (!definedKeys.contains(alternative)) continue;
                return true;
            }
        }
        return false;
    }

    private String[] getRelevantAlteratives(String[] alternatives, String[] relevant) {
        if (alternatives == null || relevant == null || relevant.length == 0) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(alternatives.length);
        block0: for (String alt : alternatives) {
            for (String rel : relevant) {
                if (!alt.equals(rel)) continue;
                result.add(alt);
                continue block0;
            }
        }
        return result.size() == 0 ? null : result.toArray(new String[result.size()]);
    }

    private ResAndReg loadResource(PathAddress address, Map<PathAddress, ResAndReg> resolved) {
        Resource resource;
        ResAndReg resAndReg = resolved.get(PathAddress.EMPTY_ADDRESS);
        if (resAndReg == null) {
            ManagementResourceRegistration mrr = this.managementModel.getRootResourceRegistration();
            resource = this.managementModel.getRootResource();
            resAndReg = new ResAndReg(resource, mrr);
            resolved.put(PathAddress.EMPTY_ADDRESS, resAndReg);
        }
        PathAddress current = PathAddress.EMPTY_ADDRESS;
        resource = resAndReg.resource;
        ImmutableManagementResourceRegistration mrr = resAndReg.reg;
        for (PathElement element : address) {
            if (resource == null || resource.isRuntime()) {
                return null;
            }
            resAndReg = resolved.get(current = current.append(element));
            ImmutableManagementResourceRegistration subMrr = resAndReg != null ? resAndReg.reg : mrr.getSubModel(current);
            if (subMrr == null || subMrr.isRuntimeOnly() || subMrr.isRemote() || !resource.hasChild(element)) {
                if (resAndReg == null) {
                    resAndReg = new ResAndReg(null, subMrr);
                    resolved.put(current, resAndReg);
                }
                return null;
            }
            if (resAndReg != null) {
                resource = resAndReg.resource;
                continue;
            }
            resource = resource.getChild(element);
            resAndReg = new ResAndReg(resource, subMrr);
            resolved.put(current, resAndReg);
        }
        if (resource.isRuntime()) {
            return null;
        }
        return resAndReg;
    }

    private static interface ErrorHandler {
        public void throwError() throws OperationFailedException;
    }

    private static class ResAndReg {
        private final Resource resource;
        private final ImmutableManagementResourceRegistration reg;

        private ResAndReg(Resource resource, ImmutableManagementResourceRegistration reg) {
            this.resource = resource;
            this.reg = reg;
        }
    }
}

