/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.cli;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.handlers.DefaultFilenameTabCompleter;
import org.jboss.as.cli.handlers.FilenameTabCompleter;
import org.jboss.as.cli.handlers.SimpleTabCompleter;
import org.jboss.as.cli.handlers.WindowsFilenameTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithListValue;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.impl.FileSystemPathArgument;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.util.SimpleTable;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.cli.CandidatesProviders;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.patching.metadata.BundledPatch;
import org.jboss.as.patching.metadata.Identity;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.patching.metadata.PatchBundleXml;
import org.jboss.as.patching.metadata.PatchElement;
import org.jboss.as.patching.metadata.PatchXml;
import org.jboss.as.patching.tool.PatchOperationBuilder;
import org.jboss.as.patching.tool.PatchOperationTarget;
import org.jboss.dmr.ModelNode;
import org.wildfly.security.manager.action.ReadEnvironmentPropertyAction;
import org.wildfly.security.manager.action.ReadPropertyAction;

public class PatchHandler
extends CommandHandlerWithHelp {
    static final String PATCH = "patch";
    static final String APPLY = "apply";
    static final String ROLLBACK = "rollback";
    static final String HISTORY = "history";
    static final String INFO = "info";
    static final String INSPECT = "inspect";
    private final ArgumentWithValue host;
    private final ArgumentWithValue action = new ArgumentWithValue((CommandHandlerWithArguments)this, (CommandLineCompleter)new SimpleTabCompleter(new String[]{"apply", "rollback", "history", "info", "inspect"}), 0, "--action");
    private final ArgumentWithoutValue path;
    private final ArgumentWithValue patchId;
    private final ArgumentWithValue patchStream;
    private final ArgumentWithoutValue rollbackTo;
    private final ArgumentWithValue resetConfiguration;
    private final ArgumentWithoutValue overrideModules;
    private final ArgumentWithoutValue overrideAll;
    private final ArgumentWithListValue override;
    private final ArgumentWithListValue preserve;
    private final ArgumentWithoutValue distribution;
    private final ArgumentWithoutValue modulePath;
    private final ArgumentWithoutValue bundlePath;
    private final ArgumentWithoutValue verbose;
    private final ArgumentWithoutValue streams;
    private final ArgumentWithoutValue excludeAgedOut;
    private final ArgumentWithoutValue jsonOutput;
    private static final String lineSeparator = System.getSecurityManager() == null ? System.getProperty("line.separator") : AccessController.doPrivileged(new ReadPropertyAction("line.separator"));
    private static final String HOME = "JBOSS_HOME";
    private static final String HOME_DIR = "jboss.home.dir";

    public PatchHandler(CommandContext context) {
        super(PATCH, false);
        this.host = new ArgumentWithValue(this, new DefaultCompleter(CandidatesProviders.HOSTS), "--host"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                boolean connected = ctx.getControllerHost() != null;
                return connected && ctx.isDomainMode() && super.canAppearNext(ctx);
            }
        };
        this.overrideModules = new ArgumentWithoutValue(this, "--override-modules"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (PatchHandler.this.canOnlyAppearAfterActions(ctx, new String[]{PatchHandler.APPLY, PatchHandler.ROLLBACK})) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.overrideModules.addRequiredPreceding(this.action);
        this.overrideAll = new ArgumentWithoutValue(this, "--override-all"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (PatchHandler.this.canOnlyAppearAfterActions(ctx, new String[]{PatchHandler.APPLY, PatchHandler.ROLLBACK})) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.overrideAll.addRequiredPreceding(this.action);
        this.override = new ArgumentWithListValue(this, "--override"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (PatchHandler.this.canOnlyAppearAfterActions(ctx, new String[]{PatchHandler.APPLY, PatchHandler.ROLLBACK})) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.override.addRequiredPreceding(this.action);
        this.preserve = new ArgumentWithListValue(this, "--preserve"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (PatchHandler.this.canOnlyAppearAfterActions(ctx, new String[]{PatchHandler.APPLY, PatchHandler.ROLLBACK})) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.preserve.addRequiredPreceding(this.action);
        FilenameTabCompleter pathCompleter = Util.isWindows() ? new WindowsFilenameTabCompleter(context) : new DefaultFilenameTabCompleter(context);
        this.path = new FileSystemPathArgument(this, pathCompleter, 1, "--path"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (PatchHandler.this.canOnlyAppearAfterActions(ctx, new String[]{PatchHandler.APPLY, PatchHandler.INSPECT})) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.path.addRequiredPreceding(this.action);
        this.patchId = new ArgumentWithValue(this, 1, "--patch-id"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (PatchHandler.this.canOnlyAppearAfterActions(ctx, new String[]{PatchHandler.INFO, PatchHandler.ROLLBACK})) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.patchId.addRequiredPreceding(this.action);
        this.patchStream = new ArgumentWithValue(this, "--patch-stream"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (PatchHandler.this.canOnlyAppearAfterActions(ctx, new String[]{PatchHandler.HISTORY, PatchHandler.INFO, PatchHandler.ROLLBACK})) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.patchStream.addRequiredPreceding(this.action);
        this.rollbackTo = new ArgumentWithoutValue(this, "--rollback-to"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (PatchHandler.this.canOnlyAppearAfterActions(ctx, new String[]{PatchHandler.ROLLBACK})) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.rollbackTo.addRequiredPreceding(this.action);
        this.resetConfiguration = new ArgumentWithValue(this, SimpleTabCompleter.BOOLEAN, "--reset-configuration"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (PatchHandler.this.canOnlyAppearAfterActions(ctx, new String[]{PatchHandler.ROLLBACK})) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.resetConfiguration.addRequiredPreceding(this.action);
        this.distribution = new FileSystemPathArgument(this, pathCompleter, "--distribution"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (ctx.getModelControllerClient() == null && PatchHandler.this.canOnlyAppearAfterActions(ctx, new String[]{PatchHandler.APPLY, PatchHandler.ROLLBACK, PatchHandler.HISTORY, PatchHandler.INFO})) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.modulePath = new FileSystemPathArgument(this, pathCompleter, "--module-path"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (ctx.getModelControllerClient() == null && PatchHandler.this.canOnlyAppearAfterActions(ctx, new String[]{PatchHandler.APPLY, PatchHandler.ROLLBACK, PatchHandler.HISTORY, PatchHandler.INFO})) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.bundlePath = new FileSystemPathArgument(this, pathCompleter, "--bundle-path"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (ctx.getModelControllerClient() == null && PatchHandler.this.canOnlyAppearAfterActions(ctx, new String[]{PatchHandler.APPLY, PatchHandler.ROLLBACK, PatchHandler.HISTORY, PatchHandler.INFO})) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.verbose = new ArgumentWithoutValue(this, "--verbose", "-v"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (PatchHandler.this.canOnlyAppearAfterActions(ctx, new String[]{PatchHandler.INFO, PatchHandler.INSPECT})) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.verbose.addRequiredPreceding(this.action);
        this.jsonOutput = new ArgumentWithoutValue(this, "--json-output"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                return false;
            }
        };
        this.streams = new ArgumentWithoutValue(this, "--streams"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (PatchHandler.this.canOnlyAppearAfterActions(ctx, new String[]{PatchHandler.INFO})) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.streams.addRequiredPreceding(this.action);
        this.streams.addCantAppearAfter(this.verbose);
        this.verbose.addCantAppearAfter(this.streams);
        this.streams.addCantAppearAfter(this.patchStream);
        this.patchStream.addCantAppearAfter(this.streams);
        this.streams.addCantAppearAfter(this.patchId);
        this.patchId.addCantAppearAfter(this.streams);
        this.excludeAgedOut = new ArgumentWithoutValue(this, "--exclude-aged-out"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (PatchHandler.this.canOnlyAppearAfterActions(ctx, new String[]{PatchHandler.HISTORY})) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.excludeAgedOut.addRequiredPreceding(this.action);
    }

    private boolean canOnlyAppearAfterActions(CommandContext ctx, String ... actions) {
        String actionStr = this.action.getValue(ctx.getParsedCommandLine());
        if (actionStr == null || actions.length == 0) {
            return false;
        }
        return Arrays.asList(actions).contains(actionStr);
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        ModelNode response;
        ParsedCommandLine parsedLine = ctx.getParsedCommandLine();
        if (this.host.isPresent(parsedLine) && !ctx.isDomainMode()) {
            throw new CommandFormatException("The --host option is not available in the current context. Connection to the controller might be unavailable or not running in domain mode.");
        }
        String action = this.action.getValue(parsedLine);
        if (INSPECT.equals(action)) {
            this.doInspect(ctx);
            return;
        }
        PatchOperationTarget target = this.createPatchOperationTarget(ctx);
        PatchOperationBuilder builder = this.createPatchOperationBuilder(parsedLine);
        try {
            response = builder.execute(target);
        }
        catch (Exception e) {
            throw new CommandLineException(action + " failed", e);
        }
        if (!Util.isSuccess(response)) {
            ModelNode fd = response.get("failure-description");
            if (!fd.isDefined()) {
                throw new CommandLineException("Failed to apply patch: " + response.asString());
            }
            if (fd.has("conflicts")) {
                StringBuilder buf = new StringBuilder();
                buf.append(fd.get("message").asString()).append(": ");
                ModelNode conflicts = fd.get("conflicts");
                String title = "";
                if (conflicts.has("bundles")) {
                    this.formatConflictsList(buf, conflicts, "", "bundles");
                    title = ", ";
                }
                if (conflicts.has("modules")) {
                    this.formatConflictsList(buf, conflicts, title, "modules");
                    title = ", ";
                }
                if (conflicts.has("misc")) {
                    this.formatConflictsList(buf, conflicts, title, "misc");
                }
                buf.append(lineSeparator).append("Use the --override-all, --override=[] or --preserve=[] arguments in order to resolve the conflict.");
                throw new CommandLineException(buf.toString());
            }
            throw new CommandLineException(Util.getFailureDescription(response));
        }
        if (INFO.equals(action)) {
            if (this.patchId.getValue(parsedLine) != null) {
                ModelNode result = response.get("result");
                if (!result.isDefined()) {
                    return;
                }
                SimpleTable table = new SimpleTable(2, ctx.getTerminalWidth());
                table.addLine("Patch ID:", result.get("patch-id").asString());
                table.addLine("Type:", result.get("type").asString());
                table.addLine("Identity name:", result.get("identity-name").asString());
                table.addLine("Identity version:", result.get("identity-version").asString());
                table.addLine("Description:", result.get("description").asString());
                if (result.hasDefined("link")) {
                    table.addLine("Link:", result.get("link").asString());
                }
                ctx.printLine(table.toString(false));
                ModelNode elements = result.get("elements");
                if (elements.isDefined()) {
                    ctx.printLine("");
                    ctx.printLine("ELEMENTS");
                    for (ModelNode e : elements.asList()) {
                        table = new SimpleTable(2, ctx.getTerminalWidth());
                        table.addLine("Patch ID:", e.get("patch-id").asString());
                        table.addLine("Name:", e.get("name").asString());
                        table.addLine("Type:", e.get("type").asString());
                        table.addLine("Description:", e.get("description").asString());
                        ctx.printLine("");
                        ctx.printLine(table.toString(false));
                    }
                }
            } else if (this.jsonOutput.isPresent(parsedLine)) {
                ctx.printLine(response.toJSONString(false));
            } else if (this.streams.isPresent(parsedLine)) {
                List<ModelNode> list = response.get("result").asList();
                if (list.size() == 1) {
                    ctx.printLine(list.get(0).asString());
                } else {
                    ArrayList<String> streams = new ArrayList<String>(list.size());
                    for (ModelNode stream : list) {
                        streams.add(stream.asString());
                    }
                    ctx.printColumns(streams);
                }
            } else {
                ModelNode result = response.get("result");
                if (!result.isDefined()) {
                    return;
                }
                SimpleTable table = new SimpleTable(2, ctx.getTerminalWidth());
                table.addLine("Version:", result.get("version").asString());
                this.addPatchesInfo(result, table);
                ctx.printLine(table.toString(false));
                if (this.verbose.isPresent(parsedLine)) {
                    this.printLayerPatches(ctx, result, "add-on");
                    this.printLayerPatches(ctx, result, "layer");
                }
            }
        } else {
            ctx.printLine(response.toJSONString(false));
        }
    }

    protected void printLayerPatches(CommandContext ctx, ModelNode result, String type) {
        ModelNode layer = result.get(type);
        if (layer.isDefined()) {
            String header = Character.toUpperCase(type.charAt(0)) + type.substring(1) + ':';
            for (String name : layer.keys()) {
                ModelNode node = layer.get(name);
                SimpleTable table = new SimpleTable(2, ctx.getTerminalWidth());
                table.addLine(header, name);
                this.addPatchesInfo(node, table);
                ctx.printLine(lineSeparator + table.toString(false));
            }
        }
    }

    protected void addPatchesInfo(ModelNode result, SimpleTable table) {
        String patchesStr;
        table.addLine("Cumulative patch ID:", result.get("cumulative-patch-id").asString());
        List<ModelNode> patches = result.get("patches").asList();
        if (patches.isEmpty()) {
            patchesStr = "none";
        } else {
            StringBuilder buf = new StringBuilder();
            buf.append(patches.get(0).asString());
            for (int i = 1; i < patches.size(); ++i) {
                buf.append(',').append(patches.get(i).asString());
            }
            patchesStr = buf.toString();
        }
        table.addLine("One-off patches:", patchesStr);
    }

    protected void doInspect(CommandContext ctx) throws CommandLineException {
        ParsedCommandLine parsedLine = ctx.getParsedCommandLine();
        String patchPath = this.path.getValue(parsedLine, true);
        File patchFile = new File(patchPath);
        if (!patchFile.exists()) {
            throw new CommandLineException("Failed to locate " + patchFile.getAbsolutePath());
        }
        ZipFile patchZip = null;
        InputStream is = null;
        try {
            patchZip = new ZipFile(patchFile);
            ZipEntry patchXmlEntry = patchZip.getEntry("patches.xml");
            if (patchXmlEntry == null) {
                patchXmlEntry = patchZip.getEntry("patch.xml");
                if (patchXmlEntry == null) {
                    throw new CommandLineException("Neither patches.xml nor patch.xml were found in " + patchFile.getAbsolutePath());
                }
                is = patchZip.getInputStream(patchXmlEntry);
                Patch patch = PatchXml.parse(is).resolvePatch(null, null);
                this.displayPatchXml(ctx, patch);
            } else {
                is = patchZip.getInputStream(patchXmlEntry);
                List<BundledPatch.BundledPatchEntry> patches = PatchBundleXml.parse(is).getPatches();
                this.displayPatchBundleXml(ctx, patches, patchZip);
            }
        }
        catch (ZipException e) {
            throw new CommandLineException("Failed to open " + patchFile.getAbsolutePath(), e);
        }
        catch (IOException e) {
            throw new CommandLineException("Failed to open " + patchFile.getAbsolutePath(), e);
        }
        catch (PatchingException e) {
            throw new CommandLineException("Failed to resolve parsed patch", e);
        }
        catch (XMLStreamException e) {
            throw new CommandLineException("Failed to parse patch.xml", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (patchZip != null) {
                try {
                    patchZip.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void displayPatchBundleXml(CommandContext ctx, List<BundledPatch.BundledPatchEntry> patches, ZipFile patchZip) throws CommandLineException {
        if (patches.isEmpty()) {
            return;
        }
        for (BundledPatch.BundledPatchEntry bundledPatch : patches) {
            ZipEntry bundledZip = patchZip.getEntry(bundledPatch.getPatchPath());
            if (bundledZip == null) {
                throw new CommandLineException("Patch file not found in the bundle: " + bundledPatch.getPatchPath());
            }
            InputStream is = null;
            ZipInputStream bundledPatchIs = null;
            try {
                is = patchZip.getInputStream(bundledZip);
                bundledPatchIs = new ZipInputStream(is);
                ZipEntry bundledPatchXml = bundledPatchIs.getNextEntry();
                while (bundledPatchXml != null && !"patch.xml".equals(bundledPatchXml.getName())) {
                    bundledPatchXml = bundledPatchIs.getNextEntry();
                }
                if (bundledPatchXml == null) {
                    throw new CommandLineException("Failed to locate patch.xml in bundled patch " + bundledPatch.getPatchPath());
                }
                Patch patch = PatchXml.parse(bundledPatchIs).resolvePatch(null, null);
                if (this.verbose.isPresent(ctx.getParsedCommandLine())) {
                    ctx.printLine("CONTENT OF " + bundledPatch.getPatchPath() + ':' + Util.LINE_SEPARATOR);
                }
                this.displayPatchXml(ctx, patch);
                ctx.printLine("");
            }
            catch (Exception e) {
                try {
                    throw new CommandLineException("Failed to inspect " + bundledPatch.getPatchPath(), e);
                }
                catch (Throwable throwable) {
                    IoUtils.safeClose(bundledPatchIs);
                    IoUtils.safeClose(is);
                    throw throwable;
                }
            }
            IoUtils.safeClose(bundledPatchIs);
            IoUtils.safeClose(is);
        }
    }

    private void displayPatchXml(CommandContext ctx, Patch patch) throws CommandLineException {
        Identity identity = patch.getIdentity();
        SimpleTable table = new SimpleTable(2, ctx.getTerminalWidth());
        table.addLine("Patch ID:", patch.getPatchId());
        table.addLine("Type:", identity.getPatchType().getName());
        table.addLine("Identity name:", identity.getName());
        table.addLine("Identity version:", identity.getVersion());
        table.addLine("Description:", patch.getDescription() == null ? "n/a" : patch.getDescription());
        if (patch.getLink() != null) {
            table.addLine("Link:", patch.getLink());
        }
        ctx.printLine(table.toString(false));
        if (this.verbose.isPresent(ctx.getParsedCommandLine())) {
            ctx.printLine("");
            ctx.printLine("ELEMENTS");
            for (PatchElement e : patch.getElements()) {
                table = new SimpleTable(2, ctx.getTerminalWidth());
                table.addLine("Patch ID:", e.getId());
                table.addLine("Name:", e.getProvider().getName());
                table.addLine("Type:", e.getProvider().isAddOn() ? "add-on" : "layer");
                table.addLine("Description:", e.getDescription());
                ctx.printLine("");
                ctx.printLine(table.toString(false));
            }
        }
    }

    protected void formatConflictsList(StringBuilder buf, ModelNode conflicts, String title, String contentType) {
        buf.append(title);
        List<ModelNode> list = conflicts.get(contentType).asList();
        int i = 0;
        while (i < list.size()) {
            ModelNode item = list.get(i++);
            buf.append(item.asString());
            if (i >= list.size()) continue;
            buf.append(", ");
        }
    }

    private PatchOperationBuilder createPatchOperationBuilder(ParsedCommandLine args) throws CommandFormatException {
        PatchOperationBuilder builder;
        String action = this.action.getValue(args, true);
        if (APPLY.equals(action)) {
            String path = this.path.getValue(args, true);
            File f = new File(path);
            if (!f.exists()) {
                throw new CommandFormatException("Path " + f.getAbsolutePath() + " doesn't exist.");
            }
            if (f.isDirectory()) {
                throw new CommandFormatException(f.getAbsolutePath() + " is a directory.");
            }
            builder = PatchOperationBuilder.Factory.patch(f);
        } else if (ROLLBACK.equals(action)) {
            boolean resetConfig;
            String resetConfigValue = this.resetConfiguration.getValue(args, true);
            if ("true".equalsIgnoreCase(resetConfigValue)) {
                resetConfig = true;
            } else if ("false".equalsIgnoreCase(resetConfigValue)) {
                resetConfig = false;
            } else {
                throw new CommandFormatException("Unexpected value for --reset-configuration (only true and false are allowed): " + resetConfigValue);
            }
            String patchStream = this.patchStream.getValue(args);
            if (this.patchId.isPresent(args)) {
                String id = this.patchId.getValue(args, true);
                boolean rollbackTo = this.rollbackTo.isPresent(args);
                builder = PatchOperationBuilder.Factory.rollback(patchStream, id, rollbackTo, resetConfig);
            } else {
                builder = PatchOperationBuilder.Factory.rollbackLast(patchStream, resetConfig);
            }
        } else {
            if (INFO.equals(action)) {
                if (this.streams.isPresent(args)) {
                    return PatchOperationBuilder.Factory.streams();
                }
                String patchStream = this.patchStream.getValue(args);
                String pId = this.patchId.getValue(args);
                PatchOperationBuilder builder2 = pId == null ? PatchOperationBuilder.Factory.info(patchStream) : PatchOperationBuilder.Factory.info(patchStream, pId, this.verbose.isPresent(args));
                return builder2;
            }
            if (HISTORY.equals(action)) {
                String patchStream = this.patchStream.getValue(args);
                PatchOperationBuilder builder3 = PatchOperationBuilder.Factory.history(patchStream, this.excludeAgedOut.isPresent(args));
                return builder3;
            }
            throw new CommandFormatException("Unrecognized action '" + action + "'");
        }
        if (this.overrideModules.isPresent(args)) {
            builder.ignoreModuleChanges();
        }
        if (this.overrideAll.isPresent(args)) {
            builder.overrideAll();
        }
        if (this.override.isPresent(args)) {
            String overrideList = this.override.getValue(args);
            if (overrideList == null || overrideList.isEmpty()) {
                throw new CommandFormatException(this.override.getFullName() + " is missing value.");
            }
            for (String path : overrideList.split(",+")) {
                builder.overrideItem(path);
            }
        }
        if (this.preserve.isPresent(args)) {
            String preserveList = this.preserve.getValue(args);
            if (preserveList == null || preserveList.isEmpty()) {
                throw new CommandFormatException(this.preserve.getFullName() + " is missing value.");
            }
            for (String path : preserveList.split(",+")) {
                builder.preserveItem(path);
            }
        }
        return builder;
    }

    private PatchOperationTarget createPatchOperationTarget(CommandContext ctx) throws CommandLineException {
        PatchOperationTarget target;
        ParsedCommandLine args = ctx.getParsedCommandLine();
        if (ctx.getModelControllerClient() != null) {
            if (this.distribution.isPresent(args)) {
                throw new CommandFormatException(this.distribution.getFullName() + " is not allowed when connected to the controller.");
            }
            if (this.modulePath.isPresent(args)) {
                throw new CommandFormatException(this.modulePath.getFullName() + " is not allowed when connected to the controller.");
            }
            if (this.bundlePath.isPresent(args)) {
                throw new CommandFormatException(this.bundlePath.getFullName() + " is not allowed when connected to the controller.");
            }
            if (ctx.isDomainMode()) {
                String hostName = this.host.getValue(args, true);
                target = PatchOperationTarget.createHost(hostName, ctx.getModelControllerClient());
            } else {
                target = PatchOperationTarget.createStandalone(ctx.getModelControllerClient());
            }
        } else {
            String jbossHome = this.getJBossHome(args);
            File root = new File(jbossHome);
            List<File> modules = PatchHandler.getFSArgument(this.modulePath, args, root, "modules");
            List<File> bundles = PatchHandler.getFSArgument(this.bundlePath, args, root, "bundles");
            try {
                target = PatchOperationTarget.createLocal(root, modules, bundles);
            }
            catch (Exception e) {
                throw new CommandLineException("Unable to apply patch to local JBOSS_HOME=" + jbossHome, e);
            }
        }
        return target;
    }

    private String getJBossHome(ParsedCommandLine args) {
        String resolved;
        String targetDistro = this.distribution.getValue(args);
        if (targetDistro != null) {
            return targetDistro;
        }
        String string = resolved = System.getSecurityManager() == null ? System.getenv(HOME) : AccessController.doPrivileged(new ReadEnvironmentPropertyAction(HOME));
        if (resolved == null) {
            String string2 = resolved = System.getSecurityManager() == null ? System.getProperty(HOME_DIR) : AccessController.doPrivileged(new ReadPropertyAction(HOME_DIR));
        }
        if (resolved == null) {
            throw PatchLogger.ROOT_LOGGER.cliFailedToResolveDistribution();
        }
        return resolved;
    }

    private static List<File> getFSArgument(ArgumentWithoutValue arg, ParsedCommandLine args, File root, String param) {
        String value = arg.getValue(args);
        if (value != null) {
            String[] values = value.split(Pattern.quote(File.pathSeparator));
            if (values.length == 1) {
                return Collections.singletonList(new File(value));
            }
            ArrayList<File> resolved = new ArrayList<File>(values.length);
            for (String path : values) {
                resolved.add(new File(path));
            }
            return resolved;
        }
        return Collections.singletonList(new File(root, param));
    }
}

