/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.generator;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract class DistributionContentItem
implements Comparable<DistributionContentItem> {
    static final char PATH_DELIMITER = '/';
    static final Set<DistributionContentItem> NO_CHILDREN = Collections.emptySet();
    protected final DistributionContentItem parent;
    protected final String name;
    private static final Pattern GLOB_PATTERN = Pattern.compile("(\\*\\*?)|(\\?)|(\\\\.)|(/+)|([^*?]+)");

    protected DistributionContentItem(DistributionContentItem parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public abstract byte[] getMetadataHash();

    public abstract byte[] getComparisonHash();

    public abstract boolean isLeaf();

    public abstract Collection<DistributionContentItem> getChildren();

    public String getName() {
        return this.name;
    }

    public DistributionContentItem getParent() {
        return this.parent;
    }

    public File getFile(File rootFile) {
        if (this.parent == null) {
            return rootFile;
        }
        return new File(this.parent.getFile(rootFile), this.getName());
    }

    public String getPath() {
        return this.getPath('/');
    }

    public String getPath(char delimiter) {
        StringBuilder sb = new StringBuilder();
        this.recordPath(sb, delimiter);
        return sb.toString();
    }

    private void recordPath(StringBuilder sb, char delimiter) {
        if (this.parent != null) {
            this.parent.recordPath(sb, delimiter);
            if (sb.length() > 0) {
                sb.append(delimiter);
            }
        }
        if (this.name != null) {
            sb.append(this.name);
        }
    }

    public List<String> getPathAsList() {
        ArrayList<String> list = new ArrayList<String>();
        this.recordPath(list);
        return list;
    }

    private void recordPath(List<String> list) {
        if (this.parent != null) {
            this.parent.recordPath(list);
        }
        if (this.name != null) {
            list.add(this.name);
        }
    }

    public int getDepth() {
        int depth = 1;
        DistributionContentItem ancestor = this.parent;
        while (ancestor != null) {
            ++depth;
            ancestor = ancestor.parent;
        }
        return depth;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = this == obj;
        if (!result && obj instanceof DistributionContentItem) {
            DistributionContentItem other = (DistributionContentItem)obj;
            result = this.parent == other.parent || this.parent != null && this.parent.equals(other.parent);
            result = result && (DistributionContentItem.same(this.name, other.name) || this.name != null && this.name.equals(other.name));
        }
        return result;
    }

    @Override
    public int compareTo(DistributionContentItem o) {
        int theirDepth;
        int myDepth = this.getDepth();
        if (myDepth != (theirDepth = o.getDepth())) {
            DistributionContentItem me = this;
            DistributionContentItem them = o;
            if (myDepth < theirDepth) {
                them = o.getAncestor(theirDepth - myDepth);
            } else if (theirDepth < myDepth) {
                me = this.getAncestor(myDepth - theirDepth);
            }
            int result = me.compareTo(them);
            if (result != 0) {
                return result;
            }
            return myDepth > theirDepth ? 1 : -1;
        }
        if (this.parent != o.parent) {
            if (this.parent == null) {
                return -1;
            }
            if (o.parent == null) {
                return 1;
            }
            int result = this.parent.compareTo(o.parent);
            if (result != 0) {
                return result;
            }
        }
        if (DistributionContentItem.same(this.name, o.name)) {
            return 0;
        }
        if (this.name == null) {
            return -1;
        }
        if (o.name == null) {
            return 1;
        }
        return this.name.compareTo(o.name);
    }

    private DistributionContentItem getAncestor(int generationsAbove) {
        DistributionContentItem ancestor = this;
        for (int i = 0; i < generationsAbove; ++i) {
            ancestor = ancestor.parent;
        }
        return ancestor;
    }

    private static boolean same(Object a, Object b) {
        return a == b;
    }

    private static Pattern getGlobPattern(String glob) {
        StringBuilder patternBuilder = new StringBuilder();
        Matcher m = GLOB_PATTERN.matcher(glob);
        boolean lastWasSlash = false;
        while (m.find()) {
            lastWasSlash = false;
            String grp = m.group(1);
            if (grp != null) {
                if (grp.length() == 2) {
                    patternBuilder.append(".*");
                    continue;
                }
                patternBuilder.append("[^/]*");
                continue;
            }
            grp = m.group(2);
            if (grp != null) {
                patternBuilder.append("[^/]");
                continue;
            }
            grp = m.group(3);
            if (grp != null) {
                patternBuilder.append(Pattern.quote(m.group().substring(1)));
                continue;
            }
            grp = m.group(4);
            if (grp != null) {
                patternBuilder.append("/+");
                lastWasSlash = true;
                continue;
            }
            patternBuilder.append(Pattern.quote(m.group()));
        }
        if (lastWasSlash) {
            patternBuilder.append(".*");
        } else {
            patternBuilder.append("(?:/.*)?");
        }
        return Pattern.compile(patternBuilder.toString());
    }

    static class GlobPathFilter
    implements Filter {
        private final String glob;
        private final Pattern pattern;

        GlobPathFilter(String glob) {
            this.pattern = DistributionContentItem.getGlobPattern(glob);
            this.glob = glob;
        }

        @Override
        public boolean accept(DistributionContentItem item) {
            return this.accept(item.getPath());
        }

        public boolean accept(String path) {
            return this.pattern.matcher(path).matches();
        }

        public int hashCode() {
            return this.glob.hashCode() + 13;
        }

        public boolean equals(Object obj) {
            return obj instanceof GlobPathFilter && this.equals((GlobPathFilter)obj);
        }

        public boolean equals(GlobPathFilter obj) {
            return obj != null && obj.pattern.equals(this.pattern);
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("match ");
            if (this.glob != null) {
                b.append('\"').append(this.glob).append('\"');
            } else {
                b.append('/').append(this.pattern).append('/');
            }
            return b.toString();
        }
    }

    static interface Filter {
        public boolean accept(DistributionContentItem var1);
    }
}

