/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.logging;

import java.io.IOException;
import java.io.SyncFailedException;
import java.util.Collection;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.patching.ContentConflictsException;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.metadata.ContentItem;
import org.jboss.as.patching.validation.PatchingArtifact;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;

@MessageLogger(projectCode="WFLYPAT", length=4)
public interface PatchLogger
extends BasicLogger {
    public static final PatchLogger ROOT_LOGGER = Logger.getMessageLogger(PatchLogger.class, "org.jboss.as.patching");

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1, value="Cannot delete file %s")
    public void cannotDeleteFile(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=2, value="Cannot invalidate %s")
    public void cannotInvalidateZip(String var1);

    @Message(id=0, value="Conflicts detected")
    public String detectedConflicts();

    @Message(id=0, value="failed to resolve a jboss.home.dir use the --distribution attribute to point to a valid installation")
    public IllegalStateException cliFailedToResolveDistribution();

    @Message(id=0, value="No layers directory found at %s")
    public IllegalStateException installationNoLayersConfigFound(String var1);

    @Message(id=0, value="Cannot find layer '%s' under directory %s")
    public IllegalStateException installationMissingLayer(String var1, String var2);

    @Message(id=0, value="no associated module or bundle repository with layer '%s'")
    public IllegalStateException installationInvalidLayerConfiguration(String var1);

    @Message(id=0, value="Duplicate %s '%s'")
    public IllegalStateException installationDuplicateLayer(String var1, String var2);

    @Message(id=0, value="Not a directory %s")
    public IllegalStateException notADirectory(String var1);

    @Message(id=0, value="patch types don't match")
    public IllegalStateException patchTypesDontMatch();

    @Message(id=0, value="invalid rollback information")
    public PatchingException invalidRollbackInformation();

    @Message(id=3, value="Patch does not apply - expected (%s), but was (%s)")
    public PatchingException doesNotApply(String var1, String var2);

    @Message(id=4, value="Failed to delete (%s)")
    public IOException failedToDelete(String var1);

    @Message(id=5, value="Failed to create directory (%s)")
    public IOException cannotCreateDirectory(String var1);

    @Message(id=8, value="File at path specified by argument %s does not exist")
    public String fileDoesNotExist(String var1);

    @Message(id=11, value="Cannot rollback patch (%s)")
    public PatchingException cannotRollbackPatch(String var1);

    @Message(id=12, value="Patch '%s' already applied")
    public PatchingException alreadyApplied(String var1);

    @Message(id=13, value="There is no layer called %s installed")
    public PatchingException noSuchLayer(String var1);

    @Message(id=14, value="Failed to resolve a valid patch descriptor for %s %s")
    public PatchingException failedToResolvePatch(String var1, String var2);

    @Message(id=15, value="Requires patch '%s'")
    public PatchingException requiresPatch(String var1);

    @Message(id=16, value="Patch is incompatible with patch '%s'")
    public PatchingException incompatiblePatch(String var1);

    @Message(id=17, value="Conflicts detected")
    public ContentConflictsException conflictsDetected(@Param Collection<ContentItem> var1);

    @Message(id=18, value="copied content does not match expected hash for item: %s")
    public SyncFailedException wrongCopiedContent(ContentItem var1);

    @Message(id=19, value="invalid patch name '%s'")
    public IllegalArgumentException illegalPatchName(String var1);

    @Message(id=20, value="Cannot rollback. No patches applied.")
    public IllegalArgumentException noPatchesApplied();

    @Message(id=21, value="Patch '%s' not found in history.")
    public PatchingException patchNotFoundInHistory(String var1);

    @Message(id=23, value="Failed to show history of patches")
    public OperationFailedException failedToShowHistory(@Cause Throwable var1);

    @Message(id=24, value="Unable to apply or rollback a patch when the server is in a restart-required state.")
    public OperationFailedException serverRequiresRestart();

    @Message(id=25, value="failed to load identity info")
    public String failedToLoadIdentity();

    @Message(id=26, value="No more patches")
    public String noMorePatches();

    @Message(id=27, value="No patch history %s")
    public String noPatchHistory(String var1);

    @Message(id=28, value="Patch is missing file %s")
    public String patchIsMissingFile(String var1);

    @Message(id=29, value="File is not readable %s")
    public String fileIsNotReadable(String var1);

    @Message(id=30, value="Layer not found %s")
    public String layerNotFound(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=31, value="failed to undo change for: '%s'")
    public void failedToUndoChange(String var1);

    @Message(id=32, value="missing: '%s'")
    public String missingArtifact(PatchingArtifact.ArtifactState var1);

    @Message(id=33, value="inconsistent state: '%s'")
    public String inconsistentArtifact(PatchingArtifact.ArtifactState var1);

    @Message(id=34, value="in error: '%s'")
    public String artifactInError(PatchingArtifact.ArtifactState var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=35, value="Cannot rename file %s")
    public void cannotRenameFile(String var1);

    @Message(id=36, value="Cannot process backup by renaming file %s")
    public IllegalStateException cannotRenameFileDuringBackup(String var1);

    @Message(id=37, value="Cannot process restore by renaming file %s")
    public IllegalStateException cannotRenameFileDuringRestore(String var1);

    @Message(id=38, value="Duplicate element patch-id (%s)")
    public IllegalStateException duplicateElementPatchId(String var1);

    @Message(id=39, value="Requested %s version %s did not match the installed version %s")
    public String productVersionDidNotMatchInstalled(String var1, String var2, String var3);

    @Message(id=40, value="failed to load %s info")
    public String failedToLoadInfo(String var1);

    @Message(id=41, value="Patch %s found in more than one stream: %s and %s")
    public String patchIdFoundInMoreThanOneStream(String var1, String var2, String var3);

    @Message(id=42, value="Patch bundle is empty")
    public String patchBundleIsEmpty();

    @Message(id=43, value="Content item type is missing in '%s'")
    public PatchingException contentItemTypeMissing(String var1);

    @Message(id=44, value="Unsupported content type '%s'")
    public String unsupportedContentType(String var1);

    @Message(id=45, value="Unrecognized condition format '%s'")
    public PatchingException unrecognizedConditionFormat(String var1);

    @Message(id=46, value="Cannot copy files to temporary directory %s: %s. Note that '-Djava.io.tmpdir' switch can be used to set different temporary directory.")
    public PatchingException cannotCopyFilesToTempDir(String var1, String var2, @Cause Throwable var3);

    @Message(id=47, value="Cannot copy files from %s to %s: %s")
    public IOException cannotCopyFiles(String var1, String var2, String var3, @Cause Throwable var4);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=48, value="Error when restoring file[%s] - %s")
    public void deleteRollbackError(String var1, String var2);

    @Message(id=49, value="Some backup files were not removed.")
    public IOException failedToDeleteBackup();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=50, value="%s cumulative patch ID is: %s, one-off patches include: %s")
    public void logPatchingInfo(String var1, String var2, String var3);
}

