/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.logging;

import java.io.IOException;
import java.io.Serializable;
import java.io.SyncFailedException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.patching.ContentConflictsException;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.patching.metadata.ContentItem;
import org.jboss.as.patching.validation.PatchingArtifact;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class PatchLogger_$logger
extends DelegatingBasicLogger
implements PatchLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = PatchLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public PatchLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void cannotDeleteFile(String name) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.cannotDeleteFile$str(), (Object)name);
    }

    protected String cannotDeleteFile$str() {
        return "WFLYPAT0001: Cannot delete file %s";
    }

    @Override
    public final void cannotInvalidateZip(String name) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.cannotInvalidateZip$str(), (Object)name);
    }

    protected String cannotInvalidateZip$str() {
        return "WFLYPAT0002: Cannot invalidate %s";
    }

    protected String detectedConflicts$str() {
        return "Conflicts detected";
    }

    @Override
    public final String detectedConflicts() {
        return String.format(this.getLoggingLocale(), this.detectedConflicts$str(), new Object[0]);
    }

    protected String cliFailedToResolveDistribution$str() {
        return "failed to resolve a jboss.home.dir use the --distribution attribute to point to a valid installation";
    }

    @Override
    public final IllegalStateException cliFailedToResolveDistribution() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cliFailedToResolveDistribution$str(), new Object[0]));
        PatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String installationNoLayersConfigFound$str() {
        return "No layers directory found at %s";
    }

    @Override
    public final IllegalStateException installationNoLayersConfigFound(String path) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.installationNoLayersConfigFound$str(), path));
        PatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String installationMissingLayer$str() {
        return "Cannot find layer '%s' under directory %s";
    }

    @Override
    public final IllegalStateException installationMissingLayer(String layer, String path) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.installationMissingLayer$str(), layer, path));
        PatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String installationInvalidLayerConfiguration$str() {
        return "no associated module or bundle repository with layer '%s'";
    }

    @Override
    public final IllegalStateException installationInvalidLayerConfiguration(String layerName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.installationInvalidLayerConfiguration$str(), layerName));
        PatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String installationDuplicateLayer$str() {
        return "Duplicate %s '%s'";
    }

    @Override
    public final IllegalStateException installationDuplicateLayer(String type, String layer) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.installationDuplicateLayer$str(), type, layer));
        PatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notADirectory$str() {
        return "Not a directory %s";
    }

    @Override
    public final IllegalStateException notADirectory(String path) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.notADirectory$str(), path));
        PatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String patchTypesDontMatch$str() {
        return "patch types don't match";
    }

    @Override
    public final IllegalStateException patchTypesDontMatch() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.patchTypesDontMatch$str(), new Object[0]));
        PatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidRollbackInformation$str() {
        return "invalid rollback information";
    }

    @Override
    public final PatchingException invalidRollbackInformation() {
        PatchingException result = new PatchingException(String.format(this.getLoggingLocale(), this.invalidRollbackInformation$str(), new Object[0]));
        PatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String doesNotApply$str() {
        return "WFLYPAT0003: Patch does not apply - expected (%s), but was (%s)";
    }

    @Override
    public final PatchingException doesNotApply(String appliesTo, String version) {
        PatchingException result = new PatchingException(String.format(this.getLoggingLocale(), this.doesNotApply$str(), appliesTo, version));
        PatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToDelete$str() {
        return "WFLYPAT0004: Failed to delete (%s)";
    }

    @Override
    public final IOException failedToDelete(String path) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.failedToDelete$str(), path));
        PatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotCreateDirectory$str() {
        return "WFLYPAT0005: Failed to create directory (%s)";
    }

    @Override
    public final IOException cannotCreateDirectory(String path) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.cannotCreateDirectory$str(), path));
        PatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String fileDoesNotExist$str() {
        return "WFLYPAT0008: File at path specified by argument %s does not exist";
    }

    @Override
    public final String fileDoesNotExist(String arg) {
        return String.format(this.getLoggingLocale(), this.fileDoesNotExist$str(), arg);
    }

    protected String cannotRollbackPatch$str() {
        return "WFLYPAT0011: Cannot rollback patch (%s)";
    }

    @Override
    public final PatchingException cannotRollbackPatch(String id) {
        PatchingException result = new PatchingException(String.format(this.getLoggingLocale(), this.cannotRollbackPatch$str(), id));
        PatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String alreadyApplied$str() {
        return "WFLYPAT0012: Patch '%s' already applied";
    }

    @Override
    public final PatchingException alreadyApplied(String patchId) {
        PatchingException result = new PatchingException(String.format(this.getLoggingLocale(), this.alreadyApplied$str(), patchId));
        PatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noSuchLayer$str() {
        return "WFLYPAT0013: There is no layer called %s installed";
    }

    @Override
    public final PatchingException noSuchLayer(String name) {
        PatchingException result = new PatchingException(String.format(this.getLoggingLocale(), this.noSuchLayer$str(), name));
        PatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToResolvePatch$str() {
        return "WFLYPAT0014: Failed to resolve a valid patch descriptor for %s %s";
    }

    @Override
    public final PatchingException failedToResolvePatch(String product, String version) {
        PatchingException result = new PatchingException(String.format(this.getLoggingLocale(), this.failedToResolvePatch$str(), product, version));
        PatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String requiresPatch$str() {
        return "WFLYPAT0015: Requires patch '%s'";
    }

    @Override
    public final PatchingException requiresPatch(String patchId) {
        PatchingException result = new PatchingException(String.format(this.getLoggingLocale(), this.requiresPatch$str(), patchId));
        PatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String incompatiblePatch$str() {
        return "WFLYPAT0016: Patch is incompatible with patch '%s'";
    }

    @Override
    public final PatchingException incompatiblePatch(String patchId) {
        PatchingException result = new PatchingException(String.format(this.getLoggingLocale(), this.incompatiblePatch$str(), patchId));
        PatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String conflictsDetected$str() {
        return "WFLYPAT0017: Conflicts detected";
    }

    @Override
    public final ContentConflictsException conflictsDetected(Collection<ContentItem> conflicts) {
        ContentConflictsException result = new ContentConflictsException(String.format(this.getLoggingLocale(), this.conflictsDetected$str(), new Object[0]), conflicts);
        PatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String wrongCopiedContent$str() {
        return "WFLYPAT0018: copied content does not match expected hash for item: %s";
    }

    @Override
    public final SyncFailedException wrongCopiedContent(ContentItem item) {
        SyncFailedException result = new SyncFailedException(String.format(this.getLoggingLocale(), this.wrongCopiedContent$str(), item));
        PatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalPatchName$str() {
        return "WFLYPAT0019: invalid patch name '%s'";
    }

    @Override
    public final IllegalArgumentException illegalPatchName(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalPatchName$str(), name));
        PatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noPatchesApplied$str() {
        return "WFLYPAT0020: Cannot rollback. No patches applied.";
    }

    @Override
    public final IllegalArgumentException noPatchesApplied() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noPatchesApplied$str(), new Object[0]));
        PatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String patchNotFoundInHistory$str() {
        return "WFLYPAT0021: Patch '%s' not found in history.";
    }

    @Override
    public final PatchingException patchNotFoundInHistory(String patchId) {
        PatchingException result = new PatchingException(String.format(this.getLoggingLocale(), this.patchNotFoundInHistory$str(), patchId));
        PatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToShowHistory$str() {
        return "WFLYPAT0023: Failed to show history of patches";
    }

    @Override
    public final OperationFailedException failedToShowHistory(Throwable cause) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.failedToShowHistory$str(), new Object[0]), cause);
        PatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String serverRequiresRestart$str() {
        return "WFLYPAT0024: Unable to apply or rollback a patch when the server is in a restart-required state.";
    }

    @Override
    public final OperationFailedException serverRequiresRestart() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.serverRequiresRestart$str(), new Object[0]));
        PatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToLoadIdentity$str() {
        return "WFLYPAT0025: failed to load identity info";
    }

    @Override
    public final String failedToLoadIdentity() {
        return String.format(this.getLoggingLocale(), this.failedToLoadIdentity$str(), new Object[0]);
    }

    protected String noMorePatches$str() {
        return "WFLYPAT0026: No more patches";
    }

    @Override
    public final String noMorePatches() {
        return String.format(this.getLoggingLocale(), this.noMorePatches$str(), new Object[0]);
    }

    protected String noPatchHistory$str() {
        return "WFLYPAT0027: No patch history %s";
    }

    @Override
    public final String noPatchHistory(String path) {
        return String.format(this.getLoggingLocale(), this.noPatchHistory$str(), path);
    }

    protected String patchIsMissingFile$str() {
        return "WFLYPAT0028: Patch is missing file %s";
    }

    @Override
    public final String patchIsMissingFile(String path) {
        return String.format(this.getLoggingLocale(), this.patchIsMissingFile$str(), path);
    }

    protected String fileIsNotReadable$str() {
        return "WFLYPAT0029: File is not readable %s";
    }

    @Override
    public final String fileIsNotReadable(String path) {
        return String.format(this.getLoggingLocale(), this.fileIsNotReadable$str(), path);
    }

    protected String layerNotFound$str() {
        return "WFLYPAT0030: Layer not found %s";
    }

    @Override
    public final String layerNotFound(String name) {
        return String.format(this.getLoggingLocale(), this.layerNotFound$str(), name);
    }

    @Override
    public final void failedToUndoChange(String name) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.failedToUndoChange$str(), (Object)name);
    }

    protected String failedToUndoChange$str() {
        return "WFLYPAT0031: failed to undo change for: '%s'";
    }

    protected String missingArtifact$str() {
        return "WFLYPAT0032: missing: '%s'";
    }

    @Override
    public final String missingArtifact(PatchingArtifact.ArtifactState state) {
        return String.format(this.getLoggingLocale(), this.missingArtifact$str(), state);
    }

    protected String inconsistentArtifact$str() {
        return "WFLYPAT0033: inconsistent state: '%s'";
    }

    @Override
    public final String inconsistentArtifact(PatchingArtifact.ArtifactState state) {
        return String.format(this.getLoggingLocale(), this.inconsistentArtifact$str(), state);
    }

    protected String artifactInError$str() {
        return "WFLYPAT0034: in error: '%s'";
    }

    @Override
    public final String artifactInError(PatchingArtifact.ArtifactState state) {
        return String.format(this.getLoggingLocale(), this.artifactInError$str(), state);
    }

    @Override
    public final void cannotRenameFile(String name) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.cannotRenameFile$str(), (Object)name);
    }

    protected String cannotRenameFile$str() {
        return "WFLYPAT0035: Cannot rename file %s";
    }

    protected String cannotRenameFileDuringBackup$str() {
        return "WFLYPAT0036: Cannot process backup by renaming file %s";
    }

    @Override
    public final IllegalStateException cannotRenameFileDuringBackup(String name) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotRenameFileDuringBackup$str(), name));
        PatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotRenameFileDuringRestore$str() {
        return "WFLYPAT0037: Cannot process restore by renaming file %s";
    }

    @Override
    public final IllegalStateException cannotRenameFileDuringRestore(String name) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotRenameFileDuringRestore$str(), name));
        PatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateElementPatchId$str() {
        return "WFLYPAT0038: Duplicate element patch-id (%s)";
    }

    @Override
    public final IllegalStateException duplicateElementPatchId(String id) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.duplicateElementPatchId$str(), id));
        PatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String productVersionDidNotMatchInstalled$str() {
        return "WFLYPAT0039: Requested %s version %s did not match the installed version %s";
    }

    @Override
    public final String productVersionDidNotMatchInstalled(String product, String expected, String installed) {
        return String.format(this.getLoggingLocale(), this.productVersionDidNotMatchInstalled$str(), product, expected, installed);
    }

    protected String failedToLoadInfo$str() {
        return "WFLYPAT0040: failed to load %s info";
    }

    @Override
    public final String failedToLoadInfo(String name) {
        return String.format(this.getLoggingLocale(), this.failedToLoadInfo$str(), name);
    }

    protected String patchIdFoundInMoreThanOneStream$str() {
        return "WFLYPAT0041: Patch %s found in more than one stream: %s and %s";
    }

    @Override
    public final String patchIdFoundInMoreThanOneStream(String id, String stream1, String stream2) {
        return String.format(this.getLoggingLocale(), this.patchIdFoundInMoreThanOneStream$str(), id, stream1, stream2);
    }

    protected String patchBundleIsEmpty$str() {
        return "WFLYPAT0042: Patch bundle is empty";
    }

    @Override
    public final String patchBundleIsEmpty() {
        return String.format(this.getLoggingLocale(), this.patchBundleIsEmpty$str(), new Object[0]);
    }

    protected String contentItemTypeMissing$str() {
        return "WFLYPAT0043: Content item type is missing in '%s'";
    }

    @Override
    public final PatchingException contentItemTypeMissing(String condition) {
        PatchingException result = new PatchingException(String.format(this.getLoggingLocale(), this.contentItemTypeMissing$str(), condition));
        PatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupportedContentType$str() {
        return "WFLYPAT0044: Unsupported content type '%s'";
    }

    @Override
    public final String unsupportedContentType(String type) {
        return String.format(this.getLoggingLocale(), this.unsupportedContentType$str(), type);
    }

    protected String unrecognizedConditionFormat$str() {
        return "WFLYPAT0045: Unrecognized condition format '%s'";
    }

    @Override
    public final PatchingException unrecognizedConditionFormat(String condition) {
        PatchingException result = new PatchingException(String.format(this.getLoggingLocale(), this.unrecognizedConditionFormat$str(), condition));
        PatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotCopyFilesToTempDir$str() {
        return "WFLYPAT0046: Cannot copy files to temporary directory %s: %s. Note that '-Djava.io.tmpdir' switch can be used to set different temporary directory.";
    }

    @Override
    public final PatchingException cannotCopyFilesToTempDir(String tempDir, String reason, Throwable cause) {
        PatchingException result = new PatchingException(String.format(this.getLoggingLocale(), this.cannotCopyFilesToTempDir$str(), tempDir, reason), cause);
        PatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotCopyFiles$str() {
        return "WFLYPAT0047: Cannot copy files from %s to %s: %s";
    }

    @Override
    public final IOException cannotCopyFiles(String from, String to, String reason, Throwable cause) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.cannotCopyFiles$str(), from, to, reason), cause);
        PatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void deleteRollbackError(String path, String message) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.deleteRollbackError$str(), (Object)path, (Object)message);
    }

    protected String deleteRollbackError$str() {
        return "WFLYPAT0048: Error when restoring file[%s] - %s";
    }

    protected String failedToDeleteBackup$str() {
        return "WFLYPAT0049: Some backup files were not removed.";
    }

    @Override
    public final IOException failedToDeleteBackup() {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.failedToDeleteBackup$str(), new Object[0]));
        PatchLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void logPatchingInfo(String identityName, String cp, String patches) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.logPatchingInfo$str(), (Object)identityName, (Object)cp, (Object)patches);
    }

    protected String logPatchingInfo$str() {
        return "WFLYPAT0050: %s cumulative patch ID is: %s, one-off patches include: %s";
    }
}

