/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.callback;

import java.security.spec.AlgorithmParameterSpec;
import java.util.function.Function;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.callback.ExtendedCallback;
import org.wildfly.security.auth.server._private.ElytronMessages;
import org.wildfly.security.credential.AlgorithmCredential;
import org.wildfly.security.credential.Credential;

public abstract class AbstractCredentialCallback
implements ExtendedCallback {
    private final Class<? extends Credential> credentialType;
    private final String algorithm;
    private final AlgorithmParameterSpec parameterSpec;
    private Credential credential;

    AbstractCredentialCallback(Class<? extends Credential> credentialType, String algorithm, AlgorithmParameterSpec parameterSpec) {
        Assert.checkNotNullParam("credentialType", credentialType);
        if (parameterSpec != null) {
            Assert.checkNotNullParam("algorithm", algorithm);
        }
        this.algorithm = algorithm;
        this.credentialType = credentialType;
        this.parameterSpec = parameterSpec;
    }

    public Credential getCredential() {
        return this.credential;
    }

    public <C extends Credential> C getCredential(Class<C> credentialType) {
        return (C)((Credential)this.applyToCredential(credentialType, Function.identity()));
    }

    public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) {
        return (C)((Credential)this.applyToCredential(credentialType, algorithmName, Function.identity()));
    }

    public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) {
        return (C)((Credential)this.applyToCredential(credentialType, algorithmName, parameterSpec, Function.identity()));
    }

    public <C extends Credential, R> R applyToCredential(Class<C> credentialType, Function<C, R> function) {
        Credential credential = this.credential;
        return credential == null ? null : (R)credential.castAndApply(credentialType, function);
    }

    public <C extends Credential, R> R applyToCredential(Class<C> credentialType, String algorithmName, Function<C, R> function) {
        Credential credential = this.credential;
        return credential == null ? null : (R)credential.castAndApply(credentialType, algorithmName, function);
    }

    public <C extends Credential, R> R applyToCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec, Function<C, R> function) {
        Credential credential = this.credential;
        return credential == null ? null : (R)credential.castAndApply(credentialType, algorithmName, parameterSpec, function);
    }

    public void setCredential(Credential credential) {
        if (credential != null && !this.isCredentialSupported(credential)) {
            throw ElytronMessages.log.credentialNotSupported();
        }
        this.credential = credential;
    }

    public boolean isCredentialTypeSupported(Class<? extends Credential> credentialType) {
        return this.isCredentialTypeSupported(credentialType, null);
    }

    public boolean isCredentialTypeSupported(Class<? extends Credential> credentialType, String algorithmName) {
        Assert.checkNotNullParam("credentialType", credentialType);
        return this.credentialType.isAssignableFrom(credentialType) && (this.algorithm == null || AlgorithmCredential.class.isAssignableFrom(credentialType) && this.algorithm.equals(algorithmName));
    }

    public boolean isCredentialTypeSupported(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) {
        Assert.checkNotNullParam("credentialType", credentialType);
        return this.isCredentialTypeSupported(credentialType, algorithmName) && (this.parameterSpec == null || this.parameterSpec.equals(parameterSpec));
    }

    public boolean isCredentialSupported(Credential credential) {
        Assert.checkNotNullParam("credential", credential);
        return credential.castAs(this.credentialType, this.algorithm, this.parameterSpec) != null;
    }

    public Class<? extends Credential> getCredentialType() {
        return this.credentialType;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public AlgorithmParameterSpec getParameterSpec() {
        return this.parameterSpec;
    }

    @Override
    public boolean needsInformation() {
        return true;
    }
}

