/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.security;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import org.wildfly.common.Assert;

public final class InetAddressPrincipal
implements Principal,
Cloneable,
Serializable {
    private static final long serialVersionUID = -4933833947550618331L;
    private final InetAddress inetAddress;

    public InetAddressPrincipal(InetAddress inetAddress) {
        Assert.checkNotNullParam("inetAddress", inetAddress);
        try {
            this.inetAddress = InetAddress.getByAddress(inetAddress.getHostAddress(), inetAddress.getAddress());
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getName() {
        return this.inetAddress.getHostAddress();
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof InetAddressPrincipal && this.equals((InetAddressPrincipal)other);
    }

    public boolean equals(InetAddressPrincipal other) {
        return other != null && this.inetAddress.equals(other.inetAddress);
    }

    @Override
    public int hashCode() {
        return this.inetAddress.hashCode();
    }

    @Override
    public String toString() {
        return "InetAddressPrincipal <" + this.inetAddress.toString() + ">";
    }

    public InetAddressPrincipal clone() {
        try {
            return (InetAddressPrincipal)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }
}

