/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.MapAttributeDefinition;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectMapAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public interface AttributeParsers {
    public static final AttributeParser SIMPLE = AttributeParser.SIMPLE;
    public static final AttributeParser SIMPLE_ELEMENT = new AttributeParser.WrappedSimpleAttributeParser();
    public static final AttributeParser PROPERTIES_WRAPPED = new PropertiesParser();
    public static final AttributeParser PROPERTIES_UNWRAPPED = new PropertiesParser(false);
    public static final AttributeParser OBJECT_MAP_WRAPPED = new ObjectMapParser();
    public static final AttributeParser OBJECT_MAP_UNWRAPPED = new ObjectMapParser(false);
    public static final AttributeParser WRAPPED_OBJECT_LIST_PARSER = new WrappedObjectListParser();
    public static final AttributeParser UNWRAPPED_OBJECT_LIST_PARSER = new UnWrappedObjectListParser();
    public static final AttributeParser STRING_LIST_NAMED_ELEMENT = new NamedStringListParser();
    public static final AttributeParser STRING_LIST = AttributeParser.STRING_LIST;
    public static final AttributeParser STRING_LIST_COMMA_DELIMITED = AttributeParser.COMMA_DELIMITED_STRING_LIST;

    public static AttributeParser getObjectMapAttributeParser(String keyElementName) {
        return new ObjectMapParser(null, null, true, keyElementName);
    }

    public static AttributeParser getObjectMapAttributeParser(String elementName, String keyElementName, boolean wrapElement) {
        return new ObjectMapParser(null, elementName, wrapElement, keyElementName);
    }

    public static AttributeParser getObjectMapAttributeParser(String elementName, boolean wrapElement) {
        return new ObjectMapParser(null, elementName, wrapElement, null);
    }

    public static AttributeParser getObjectMapAttributeParser(String wrapperElementName, boolean wrapElement, String elementName, String keyElementName) {
        return new ObjectMapParser(wrapperElementName, elementName, wrapElement, keyElementName);
    }

    public static class NamedStringListParser
    extends AttributeElementParser {
        public NamedStringListParser() {
        }

        public NamedStringListParser(String xmlName) {
            super(xmlName);
        }

        @Override
        public void parseElement(AttributeDefinition ad, XMLExtendedStreamReader reader, ModelNode addPermissionMapper) throws XMLStreamException {
            ParseUtils.requireSingleAttribute(reader, "name");
            String name = reader.getAttributeValue(0);
            addPermissionMapper.get(ad.getName()).add(name);
            ParseUtils.requireNoContent(reader);
        }
    }

    public static class UnWrappedObjectListParser
    extends WrappedObjectListParser {
        @Override
        public String getXmlName(AttributeDefinition attribute) {
            return this.getObjectType(attribute).getXmlName();
        }

        @Override
        public void parseElement(AttributeDefinition attribute, XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
            String xmlName;
            ObjectTypeAttributeDefinition objectType = this.getObjectType(attribute);
            ModelNode listValue = operation.get(attribute.getName());
            if (!listValue.isDefined()) {
                listValue.setEmptyList();
            }
            if (!(xmlName = objectType.getXmlName()).equals(reader.getLocalName())) {
                throw ParseUtils.unexpectedElement(reader, Collections.singleton(xmlName));
            }
            ModelNode op = listValue.add();
            ObjectParser.parseEmbeddedElement(objectType, reader, op, new String[0]);
            if (!reader.isEndElement()) {
                ParseUtils.requireNoContent(reader);
            }
        }
    }

    public static class WrappedObjectListParser
    extends AttributeParser {
        @Override
        public boolean isParseAsElement() {
            return true;
        }

        ObjectTypeAttributeDefinition getObjectType(AttributeDefinition attribute) {
            assert (attribute instanceof ObjectListAttributeDefinition);
            ObjectListAttributeDefinition list = (ObjectListAttributeDefinition)attribute;
            return list.getValueType();
        }

        @Override
        public void parseElement(AttributeDefinition attribute, XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
            assert (attribute instanceof ObjectListAttributeDefinition);
            ObjectListAttributeDefinition list = (ObjectListAttributeDefinition)attribute;
            ObjectTypeAttributeDefinition objectType = list.getValueType();
            ModelNode listValue = new ModelNode();
            listValue.setEmptyList();
            while (reader.hasNext() && reader.nextTag() != 2) {
                if (!objectType.getXmlName().equals(reader.getLocalName())) {
                    throw ParseUtils.unexpectedElement(reader, Collections.singleton(objectType.getXmlName()));
                }
                ModelNode op = listValue.add();
                ObjectParser.parseEmbeddedElement(objectType, reader, op, new String[0]);
                if (reader.isEndElement()) continue;
                ParseUtils.requireNoContent(reader);
            }
            operation.get(attribute.getName()).set(listValue);
        }
    }

    public static class ObjectParser
    extends AttributeParser {
        @Override
        public boolean isParseAsElement() {
            return true;
        }

        @Override
        public void parseElement(AttributeDefinition attribute, XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
            assert (attribute instanceof ObjectTypeAttributeDefinition);
            if (operation.hasDefined(attribute.getName())) {
                throw ParseUtils.unexpectedElement(reader);
            }
            if (!attribute.getXmlName().equals(reader.getLocalName())) {
                throw ParseUtils.unexpectedElement(reader, Collections.singleton(attribute.getXmlName()));
            }
            ObjectTypeAttributeDefinition objectType = (ObjectTypeAttributeDefinition)attribute;
            ModelNode op = operation.get(attribute.getName());
            op.setEmptyObject();
            ObjectParser.parseEmbeddedElement(objectType, reader, op, new String[0]);
            if (!reader.isEndElement()) {
                ParseUtils.requireNoContent(reader);
            }
        }

        static void parseEmbeddedElement(ObjectTypeAttributeDefinition attribute, XMLExtendedStreamReader reader, ModelNode op, String ... additionalExpectedAttributes) throws XMLStreamException {
            AttributeDefinition[] valueTypes = attribute.getValueTypes();
            HashMap<String, AttributeDefinition> attributes = new HashMap<String, AttributeDefinition>();
            for (AttributeDefinition valueType : valueTypes) {
                attributes.put(valueType.getXmlName(), valueType);
            }
            HashMap<String, AttributeDefinition> attributeElements = new HashMap<String, AttributeDefinition>();
            for (AttributeDefinition attributeDefinition : valueTypes) {
                if (!attributeDefinition.getParser().isParseAsElement()) continue;
                attributeElements.put(attributeDefinition.getParser().getXmlName(attributeDefinition), attributeDefinition);
            }
            for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attributeName = reader.getAttributeLocalName(i);
                String value = reader.getAttributeValue(i);
                if (attributes.containsKey(attributeName)) {
                    AttributeDefinition def = (AttributeDefinition)attributes.get(attributeName);
                    AttributeParser parser = def.getParser();
                    assert (parser != null);
                    parser.parseAndSetParameter(def, value, op, reader);
                    continue;
                }
                if (Arrays.binarySearch(additionalExpectedAttributes, attributeName) >= 0) continue;
                throw ParseUtils.unexpectedAttribute(reader, i, attributes.keySet());
            }
            if (!attributeElements.isEmpty()) {
                while (reader.hasNext() && reader.nextTag() != 2) {
                    String attrName = reader.getLocalName();
                    if (attributeElements.containsKey(attrName)) {
                        AttributeDefinition ad = (AttributeDefinition)attributeElements.get(reader.getLocalName());
                        ad.getParser().parseElement(ad, reader, op);
                        continue;
                    }
                    throw ParseUtils.unexpectedElement(reader, attributeElements.keySet());
                }
            }
        }
    }

    public static class ObjectMapParser
    extends MapParser {
        private final String keyAttributeName;

        public ObjectMapParser(String wrapperElement, String elementName, boolean wrapElement, String keyAttributeName) {
            super(wrapperElement, elementName, wrapElement);
            this.keyAttributeName = keyAttributeName == null ? "key" : keyAttributeName;
        }

        public ObjectMapParser() {
            this(null, "property", true, null);
        }

        public ObjectMapParser(boolean wrapElement) {
            this(null, null, wrapElement, null);
        }

        public ObjectMapParser(String elementName, boolean wrapElement) {
            this(null, elementName, wrapElement, null);
        }

        @Override
        public void parseSingleElement(MapAttributeDefinition attribute, XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
            assert (attribute instanceof ObjectMapAttributeDefinition);
            assert (attribute.getParser().isParseAsElement());
            ObjectMapAttributeDefinition map = (ObjectMapAttributeDefinition)attribute;
            ObjectTypeAttributeDefinition objectType = map.getValueType();
            ParseUtils.requireAttributes(reader, this.keyAttributeName);
            String key = reader.getAttributeValue(null, this.keyAttributeName);
            ModelNode op = operation.get(attribute.getName(), key);
            ObjectParser.parseEmbeddedElement(objectType, reader, op, this.keyAttributeName);
            ParseUtils.requireNoContent(reader);
        }
    }

    public static class PropertiesParser
    extends MapParser {
        public PropertiesParser(String wrapperElement, String elementName, boolean wrapElement) {
            super(wrapperElement, elementName, wrapElement);
        }

        public PropertiesParser(String wrapperElement, boolean wrapElement) {
            this(wrapperElement, "property", wrapElement);
        }

        public PropertiesParser(boolean wrapElement) {
            this(null, null, wrapElement);
        }

        public PropertiesParser(String wrapperElement) {
            this(wrapperElement, null, true);
        }

        public PropertiesParser() {
            this(null, "property", true);
        }

        @Override
        public void parseSingleElement(MapAttributeDefinition attribute, XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
            String[] array = ParseUtils.requireAttributes(reader, Attribute.NAME.getLocalName(), Attribute.VALUE.getLocalName());
            attribute.parseAndAddParameterElement(array[0], array[1], operation, reader);
            ParseUtils.requireNoContent(reader);
        }
    }

    public static abstract class MapParser
    extends AttributeParser {
        protected final String wrapperElement;
        protected final String elementName;
        protected final boolean wrapElement;

        public MapParser(String wrapperElement, String elementName, boolean wrapElement) {
            this.wrapperElement = wrapperElement;
            this.elementName = elementName == null ? "property" : elementName;
            this.wrapElement = wrapElement;
        }

        public MapParser(String wrapperElement, boolean wrapElement) {
            this(wrapperElement, "property", wrapElement);
        }

        public MapParser(boolean wrapElement) {
            this(null, null, wrapElement);
        }

        public MapParser(String wrapperElement) {
            this(wrapperElement, null, true);
        }

        public MapParser() {
            this(null, "property", true);
        }

        @Override
        public boolean isParseAsElement() {
            return true;
        }

        @Override
        public String getXmlName(AttributeDefinition attribute) {
            return this.wrapElement ? (this.wrapperElement != null ? this.wrapperElement : attribute.getXmlName()) : this.elementName;
        }

        @Override
        public void parseElement(AttributeDefinition attribute, XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
            String wrapper;
            String string = wrapper = this.wrapperElement == null ? attribute.getName() : this.wrapperElement;
            assert (attribute instanceof MapAttributeDefinition);
            MapAttributeDefinition mapAttribute = (MapAttributeDefinition)attribute;
            operation.get(attribute.getName()).setEmptyObject();
            if (this.wrapElement) {
                if (!reader.getLocalName().equals(wrapper)) {
                    throw ParseUtils.unexpectedElement(reader, Collections.singleton(wrapper));
                }
                if (reader.nextTag() == 2) {
                    return;
                }
            }
            do {
                if (!this.elementName.equals(reader.getLocalName())) {
                    throw ParseUtils.unexpectedElement(reader, Collections.singleton(this.elementName));
                }
                this.parseSingleElement(mapAttribute, reader, operation);
            } while (reader.hasNext() && reader.nextTag() != 2 && reader.getLocalName().equals(this.elementName));
            if (this.wrapElement && reader.getEventType() != 2) {
                throw ParseUtils.unexpectedElement(reader, Collections.singleton(this.elementName));
            }
        }

        public abstract void parseSingleElement(MapAttributeDefinition var1, XMLExtendedStreamReader var2, ModelNode var3) throws XMLStreamException;
    }

    public static abstract class AttributeElementParser
    extends AttributeParser {
        private final String xmlName;

        public AttributeElementParser() {
            this.xmlName = null;
        }

        public AttributeElementParser(String xmlName) {
            this.xmlName = xmlName;
        }

        @Override
        public boolean isParseAsElement() {
            return true;
        }

        @Override
        public String getXmlName(AttributeDefinition attribute) {
            return this.xmlName == null ? attribute.getXmlName() : this.xmlName;
        }

        @Override
        public abstract void parseElement(AttributeDefinition var1, XMLExtendedStreamReader var2, ModelNode var3) throws XMLStreamException;
    }
}

