/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.persistence;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.persistence.AbstractConfigurationPersister;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.ExposedByteArrayOutputStream;
import org.jboss.dmr.ModelNode;
import org.xnio.IoUtils;

public abstract class AbstractFilePersistenceResource
implements ConfigurationPersister.PersistenceResource {
    private volatile ExposedByteArrayOutputStream marshalled = new ExposedByteArrayOutputStream(8192);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractFilePersistenceResource(ModelNode model, AbstractConfigurationPersister persister) throws ConfigurationPersistenceException {
        try {
            try {
                BufferedOutputStream output = new BufferedOutputStream(this.marshalled);
                persister.marshallAsXml(model, output);
                output.close();
                this.marshalled.close();
            }
            finally {
                IoUtils.safeClose((Closeable)this.marshalled);
            }
        }
        catch (Exception e) {
            throw ControllerLogger.ROOT_LOGGER.failedToMarshalConfiguration(e);
        }
    }

    @Override
    public void commit() {
        if (this.marshalled == null) {
            throw ControllerLogger.ROOT_LOGGER.rollbackAlreadyInvoked();
        }
        try (InputStream in = this.getMarshalledInputStream();){
            this.doCommit(in);
        }
        catch (IOException ioex) {
            ControllerLogger.MGMT_OP_LOGGER.errorf((Throwable)ioex, ioex.getMessage(), new Object[0]);
        }
    }

    @Override
    public void rollback() {
        this.marshalled = null;
    }

    protected InputStream getMarshalledInputStream() {
        return this.marshalled.getInputStream();
    }

    protected abstract void doCommit(InputStream var1);
}

