/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.security;

import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.controller.security.CredentialStoreUpdateInfo;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;

public class CredentialStoreUpdateService
implements Service<CredentialStoreUpdateService> {
    private String alias;
    private String secret;
    private ModelNode result;
    private CredentialStoreUpdateInfo credentialStoreUpdateInfo;
    private final InjectedValue<CredentialStore> injectedCredentialStore = new InjectedValue();

    CredentialStoreUpdateService(String alias, String secret, ModelNode result) {
        this.alias = alias;
        this.secret = secret;
        this.result = result;
        this.credentialStoreUpdateInfo = null;
    }

    CredentialStoreUpdateService(String alias, String secret, ModelNode result, CredentialStoreUpdateInfo credentialStoreUpdateInfo) {
        this.alias = alias;
        this.secret = secret;
        this.result = result;
        this.credentialStoreUpdateInfo = credentialStoreUpdateInfo;
    }

    @Override
    public void start(StartContext startContext) throws StartException {
        if (this.alias != null && this.secret != null) {
            try {
                CredentialReference.updateCredentialStore(this.injectedCredentialStore.getValue(), this.alias, this.secret, this.result, this.credentialStoreUpdateInfo);
            }
            catch (CredentialStoreException e) {
                throw new StartException(e);
            }
        }
    }

    @Override
    public void stop(StopContext stopContext) {
        this.alias = null;
        this.secret = null;
        this.result = null;
    }

    @Override
    public synchronized CredentialStoreUpdateService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    Injector<CredentialStore> getCredentialStoreInjector() {
        return this.injectedCredentialStore;
    }

    public static ServiceName createServiceName(String parentName, String credentialStoreName) {
        return ServiceName.of("org", "wildfly", "security", "elytron").append("credential-store-update", parentName + "-" + credentialStoreName);
    }
}

