/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.permission;

import java.security.Permission;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.CombinationPolicy;
import org.jboss.as.controller.access.permission.ManagementPermission;
import org.jboss.as.controller.logging.ControllerLogger;

public class CombinationManagementPermission
extends ManagementPermission {
    private final CombinationPolicy combinationPolicy;
    private final Map<String, ManagementPermission> underlyingPermissions = new HashMap<String, ManagementPermission>();

    public CombinationManagementPermission(CombinationPolicy combinationPolicy, Action.ActionEffect actionEffect) {
        super("CombinationManagementPermission", actionEffect);
        this.combinationPolicy = combinationPolicy;
    }

    public void addUnderlyingPermission(String permissionName, ManagementPermission underlyingPermission) {
        assert (underlyingPermission.getActionEffect() == this.getActionEffect()) : "incompatible ActionEffect";
        if (this.combinationPolicy == CombinationPolicy.REJECTING && this.underlyingPermissions.size() > 0) {
            throw ControllerLogger.ROOT_LOGGER.illegalMultipleRoles();
        }
        this.underlyingPermissions.put(permissionName, underlyingPermission);
    }

    @Override
    public String getActions() {
        TreeSet<Action.ActionEffect> effects = new TreeSet<Action.ActionEffect>();
        for (ManagementPermission permission : this.underlyingPermissions.values()) {
            effects.add(permission.getActionEffect());
        }
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (Action.ActionEffect effect : effects) {
            if (!first) {
                sb.append(',');
            } else {
                first = false;
            }
            sb.append(effect.toString());
        }
        return sb.toString();
    }

    @Override
    public boolean implies(Permission permission) {
        if (this.combinationPolicy == CombinationPolicy.PERMISSIVE) {
            for (ManagementPermission underlying : this.underlyingPermissions.values()) {
                if (!underlying.implies(permission)) continue;
                return true;
            }
            if (ControllerLogger.ACCESS_LOGGER.isTraceEnabled()) {
                ControllerLogger.ACCESS_LOGGER.tracef("None of the underlying permissions %s imply %s", (Object)this.underlyingPermissions.keySet(), (Object)permission);
            }
            return false;
        }
        for (Map.Entry<String, ManagementPermission> underlying : this.underlyingPermissions.entrySet()) {
            if (underlying.getValue().implies(permission)) continue;
            ControllerLogger.ACCESS_LOGGER.tracef("Underlying permission %s does not imply %s", (Object)underlying.getKey(), (Object)permission);
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CombinationManagementPermission that = (CombinationManagementPermission)o;
        return this.combinationPolicy == that.combinationPolicy && this.underlyingPermissions.equals(that.underlyingPermissions);
    }

    @Override
    public int hashCode() {
        int result = this.combinationPolicy.hashCode();
        result = 31 * result + this.underlyingPermissions.hashCode();
        return result;
    }
}

