/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.management;

import java.io.IOException;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.patching.installation.Identity;
import org.jboss.as.patching.installation.PatchableTarget;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.patching.management.ElementProviderAttributeReadHandler;
import org.jboss.as.patching.management.LocalAgeoutHistoryHandler;
import org.jboss.as.patching.management.LocalPatchOperationStepHandler;
import org.jboss.as.patching.management.LocalPatchRollbackHandler;
import org.jboss.as.patching.management.LocalPatchRollbackLastHandler;
import org.jboss.as.patching.management.LocalShowHistoryHandler;
import org.jboss.as.patching.management.PatchAttributeReadHandler;
import org.jboss.as.patching.management.PatchInfoHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class PatchResourceDefinition
extends SimpleResourceDefinition {
    public static final String NAME = "patching";
    private static final String RESOURCE_NAME = PatchResourceDefinition.class.getPackage().getName() + ".LocalDescriptions";
    static final PathElement PATH = PathElement.pathElement("core-service", "patching");
    private static final AttributeDefinition VERSION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create("version", ModelType.STRING).setStorageRuntime()).setRuntimeServiceNotRequired()).build();
    private static final AttributeDefinition CUMULATIVE_PATCH_ID = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create("cumulative-patch-id", ModelType.STRING).setStorageRuntime()).setRuntimeServiceNotRequired()).build();
    private static final AttributeDefinition PATCHES = ((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)PrimitiveListAttributeDefinition.Builder.of("patches", ModelType.STRING).setStorageRuntime()).setRuntimeServiceNotRequired()).build();
    static final AttributeDefinition EXCLUDE_AGEDOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create("exclude-aged-out", ModelType.BOOLEAN).setDefaultValue(ModelNode.FALSE)).setRequired(false)).build();
    private static final AttributeDefinition INPUT_STREAM_IDX_DEF = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create("input-stream-index", ModelType.INT).setDefaultValue(ModelNode.ZERO)).setRequired(false)).addArbitraryDescriptor("filesystem-path", ModelNode.TRUE)).addArbitraryDescriptor("attached-streams", ModelNode.TRUE)).build();
    private static final AttributeDefinition OVERRIDE_MODULES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create("override-modules", ModelType.BOOLEAN).setDefaultValue(ModelNode.FALSE)).setRequired(false)).build();
    private static final AttributeDefinition OVERRIDE_ALL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create("override-all", ModelType.BOOLEAN).setDefaultValue(ModelNode.FALSE)).setRequired(false)).build();
    private static final AttributeDefinition OVERRIDE = ((PrimitiveListAttributeDefinition.Builder)PrimitiveListAttributeDefinition.Builder.of("override", ModelType.STRING).setRequired(false)).build();
    private static final AttributeDefinition PRESERVE = ((PrimitiveListAttributeDefinition.Builder)PrimitiveListAttributeDefinition.Builder.of("preserve", ModelType.STRING).setRequired(false)).build();
    private static final OperationDefinition PATCH = new SimpleOperationDefinitionBuilder("patch", PatchResourceDefinition.getResourceDescriptionResolver("patching")).addParameter(INPUT_STREAM_IDX_DEF).addParameter(OVERRIDE_ALL).addParameter(OVERRIDE_MODULES).addParameter(OVERRIDE).addParameter(PRESERVE).build();
    static final AttributeDefinition PATCH_ID = SimpleAttributeDefinitionBuilder.create("patch-id", ModelType.STRING).build();
    static final AttributeDefinition PATCH_ID_OPTIONAL = SimpleAttributeDefinitionBuilder.create("patch-id", ModelType.STRING, true).build();
    static final AttributeDefinition RESET_CONFIGURATION = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create("reset-configuration", ModelType.BOOLEAN).setRequired(true)).build();
    static final AttributeDefinition ROLLBACK_TO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create("rollback-to", ModelType.BOOLEAN).setDefaultValue(ModelNode.FALSE)).setRequired(false)).build();
    static final AttributeDefinition VERBOSE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create("verbose", ModelType.BOOLEAN).setDefaultValue(ModelNode.FALSE)).setRequired(false)).build();
    private static final OperationDefinition ROLLBACK = new SimpleOperationDefinitionBuilder("rollback", PatchResourceDefinition.getResourceDescriptionResolver("patching")).addParameter(PATCH_ID).addParameter(ROLLBACK_TO).addParameter(RESET_CONFIGURATION).addParameter(OVERRIDE_ALL).addParameter(OVERRIDE_MODULES).addParameter(OVERRIDE).addParameter(PRESERVE).build();
    private static final OperationDefinition ROLLBACK_LAST = new SimpleOperationDefinitionBuilder("rollback-last", PatchResourceDefinition.getResourceDescriptionResolver("patching")).addParameter(RESET_CONFIGURATION).addParameter(OVERRIDE_ALL).addParameter(OVERRIDE_MODULES).addParameter(OVERRIDE).addParameter(PRESERVE).build();
    private static final OperationDefinition SHOW_HISTORY = new SimpleOperationDefinitionBuilder("show-history", PatchResourceDefinition.getResourceDescriptionResolver("patching")).addParameter(EXCLUDE_AGEDOUT).build();
    private static final OperationDefinition AGEOUT_HISTORY = new SimpleOperationDefinitionBuilder("ageout-history", PatchResourceDefinition.getResourceDescriptionResolver("patching")).build();
    private static final OperationDefinition PATCH_INFO = new SimpleOperationDefinitionBuilder("patch-info", PatchResourceDefinition.getResourceDescriptionResolver("patching")).addParameter(PATCH_ID_OPTIONAL).addParameter(VERBOSE).setReplyType(ModelType.OBJECT).setReplyParameters(PATCH_ID, SimpleAttributeDefinitionBuilder.create("type", ModelType.STRING).build(), SimpleAttributeDefinitionBuilder.create("identity-name", ModelType.STRING).build(), SimpleAttributeDefinitionBuilder.create("identity-version", ModelType.STRING).build(), SimpleAttributeDefinitionBuilder.create("description", ModelType.STRING).build(), ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create("link", ModelType.STRING).setRequired(false)).build(), ObjectListAttributeDefinition.Builder.of("elements", new ObjectTypeAttributeDefinition.Builder("elements", PATCH_ID, SimpleAttributeDefinitionBuilder.create("type", ModelType.STRING).build(), SimpleAttributeDefinitionBuilder.create("name", ModelType.STRING).build(), SimpleAttributeDefinitionBuilder.create("description", ModelType.STRING).build()).build()).build()).build();
    static final ResourceDefinition INSTANCE = new PatchResourceDefinition();

    private static ResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        return new StandardResourceDescriptionResolver(keyPrefix, RESOURCE_NAME, PatchResourceDefinition.class.getClassLoader(), true, false);
    }

    private PatchResourceDefinition() {
        super(new SimpleResourceDefinition.Parameters(PATH, PatchResourceDefinition.getResourceDescriptionResolver(NAME)).setAccessConstraints(SensitiveTargetAccessConstraintDefinition.PATCHING).setFeature(false).setRuntime());
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration registry) {
        super.registerAttributes(registry);
        this.registerPatchingAttributes(registry);
    }

    @Override
    public void registerOperations(ManagementResourceRegistration registry) {
        super.registerOperations(registry);
        this.registerPatchingOperations(registry, true);
    }

    @Override
    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        this.registerPatchingChildren(resourceRegistration);
        StandardResourceDescriptionResolver resolver = new StandardResourceDescriptionResolver("patching.patch-stream", RESOURCE_NAME, PatchResourceDefinition.class.getClassLoader());
        resourceRegistration.registerSubModel(new SimpleResourceDefinition(new SimpleResourceDefinition.Parameters(PathElement.pathElement("patch-stream"), resolver).setAccessConstraints(SensitiveTargetAccessConstraintDefinition.PATCHING).setRuntime()){

            @Override
            public void registerAttributes(ManagementResourceRegistration registry) {
                super.registerAttributes(registry);
                PatchResourceDefinition.this.registerPatchingAttributes(registry);
            }

            @Override
            public void registerOperations(ManagementResourceRegistration registry) {
                PatchResourceDefinition.this.registerPatchingOperations(registry, false);
            }

            @Override
            public void registerChildren(ManagementResourceRegistration registry) {
                PatchResourceDefinition.this.registerPatchingChildren(registry);
            }
        });
    }

    private void registerPatchingOperations(ManagementResourceRegistration registry, boolean patchOp) {
        registry.registerOperationHandler(ROLLBACK, LocalPatchRollbackHandler.INSTANCE);
        registry.registerOperationHandler(ROLLBACK_LAST, LocalPatchRollbackLastHandler.INSTANCE);
        if (patchOp) {
            registry.registerOperationHandler(PATCH, LocalPatchOperationStepHandler.INSTANCE);
        }
        registry.registerOperationHandler(SHOW_HISTORY, LocalShowHistoryHandler.INSTANCE);
        registry.registerOperationHandler(AGEOUT_HISTORY, LocalAgeoutHistoryHandler.INSTANCE);
        registry.registerOperationHandler(PATCH_INFO, PatchInfoHandler.INSTANCE);
    }

    private void registerPatchingAttributes(ManagementResourceRegistration registry) {
        registry.registerReadOnlyAttribute(VERSION, new PatchAttributeReadHandler(){

            @Override
            void handle(ModelNode result, Identity info) {
                result.set(info.getVersion());
            }
        });
        registry.registerReadOnlyAttribute(CUMULATIVE_PATCH_ID, new PatchAttributeReadHandler(){

            @Override
            void handle(ModelNode result, Identity info) throws IOException {
                result.set(info.loadTargetInfo().getCumulativePatchID());
            }
        });
        registry.registerReadOnlyAttribute(PATCHES, new PatchAttributeReadHandler(){

            @Override
            void handle(ModelNode result, Identity info) throws IOException {
                result.setEmptyList();
                for (String id : info.loadTargetInfo().getPatchIDs()) {
                    result.add(id);
                }
            }
        });
    }

    private void registerPatchingChildren(ManagementResourceRegistration registry) {
        StandardResourceDescriptionResolver resolver = new StandardResourceDescriptionResolver("patching.layer", "org.jboss.as.patching.management.LocalDescriptions", PatchResourceDefinition.class.getClassLoader());
        registry.registerSubModel(new SimpleResourceDefinition(new SimpleResourceDefinition.Parameters(PathElement.pathElement("layer"), resolver).setAccessConstraints(SensitiveTargetAccessConstraintDefinition.PATCHING).setRuntime()){

            @Override
            public void registerAttributes(ManagementResourceRegistration resource) {
                resource.registerReadOnlyAttribute(CUMULATIVE_PATCH_ID, new ElementProviderAttributeReadHandler.LayerAttributeReadHandler(){

                    @Override
                    void handle(ModelNode result, PatchableTarget layer) throws OperationFailedException {
                        try {
                            result.set(layer.loadTargetInfo().getCumulativePatchID());
                        }
                        catch (IOException e) {
                            throw new OperationFailedException(PatchLogger.ROOT_LOGGER.failedToLoadInfo(layer.getName()), e);
                        }
                    }
                });
                resource.registerReadOnlyAttribute(PATCHES, new ElementProviderAttributeReadHandler.LayerAttributeReadHandler(){

                    @Override
                    void handle(ModelNode result, PatchableTarget layer) throws OperationFailedException {
                        result.setEmptyList();
                        try {
                            for (String id : layer.loadTargetInfo().getPatchIDs()) {
                                result.add(id);
                            }
                        }
                        catch (IOException e) {
                            throw new OperationFailedException(PatchLogger.ROOT_LOGGER.failedToLoadInfo(layer.getName()), e);
                        }
                    }
                });
            }
        });
        resolver = new StandardResourceDescriptionResolver("patching.addon", "org.jboss.as.patching.management.LocalDescriptions", PatchResourceDefinition.class.getClassLoader());
        registry.registerSubModel(new SimpleResourceDefinition(new SimpleResourceDefinition.Parameters(PathElement.pathElement("addon"), resolver).setAccessConstraints(SensitiveTargetAccessConstraintDefinition.PATCHING).setRuntime()){

            @Override
            public void registerAttributes(ManagementResourceRegistration resource) {
                resource.registerReadOnlyAttribute(CUMULATIVE_PATCH_ID, new ElementProviderAttributeReadHandler.AddOnAttributeReadHandler(){

                    @Override
                    void handle(ModelNode result, PatchableTarget addon) throws OperationFailedException {
                        try {
                            result.set(addon.loadTargetInfo().getCumulativePatchID());
                        }
                        catch (IOException e) {
                            throw new OperationFailedException(PatchLogger.ROOT_LOGGER.failedToLoadInfo(addon.getName()), e);
                        }
                    }
                });
                resource.registerReadOnlyAttribute(PATCHES, new ElementProviderAttributeReadHandler.AddOnAttributeReadHandler(){

                    @Override
                    void handle(ModelNode result, PatchableTarget addon) throws OperationFailedException {
                        result.setEmptyList();
                        try {
                            for (String id : addon.loadTargetInfo().getPatchIDs()) {
                                result.add(id);
                            }
                        }
                        catch (IOException e) {
                            throw new OperationFailedException(PatchLogger.ROOT_LOGGER.failedToLoadInfo(addon.getName()), e);
                        }
                    }
                });
            }
        });
    }
}

