/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.bootstrap.impl.as.config;

import org.jboss.bootstrap.spi.as.config.JBossASServerConfig;
import org.jboss.bootstrap.spi.mc.config.MCBasedServerConfig;

/**
 * JBossASServerConfig
 *
 * Placeholder for properties which need to be moved out
 * into the real config
 *
 * @author <a href="mailto:andrew.rubinger@jboss.org">ALR</a>
 * @version $Revision: $
 * @deprecated To be replaced by a completed {@link JBossASServerConfig} implementation
 */
@Deprecated
public interface JBossASServerConfigLegacy extends MCBasedServerConfig<JBossASServerConfigLegacy>
{

   //-------------------------------------------------------------------------------||
   // LEGACY -----------------------------------------------------------------------||
   //-------------------------------------------------------------------------------||
   //TODO Everything to be moved out of here

   /*
    * STUFF BELOW HERE has not been addressed/documented/reintegrated
    */

   //TODO http://www.jboss.org/community/docs/DOC-10691
   // Patch URL deals with classpath entries to be prepended to
   // some ClassLoader, which is out of scope for this project.  Deal
   // with in Main?
   /**
    * Constant that holds the name of the environment property
    * for specifying the URL where JBoss will read patch library files
    * from.
    *
    * <p>If this value is a <tt>file</tt> URL, then all .zip and .jar files
    * inside will be prepended to the classpath.  Otherwise the URL will be
    * added to the classpath.  If not set then the no patch files will be
    * loaded.
    */
   String PROP_KEY_JBOSSAS_PATCH_URL = "jboss.patch.url";

   /**
    * Constant that holds the name of the environment property
    * for specifying whether or not the server should exit the
    * JVM on shutdown.
    *
    * <p>If not set then the server will default to exiting on shutdown.
    */
   String EXIT_ON_SHUTDOWN = "jboss.server.exitonshutdown";

   /**
    * Constant that holds the name of the environment property for
    * specifying whether or not the server should shutdown
    * synchronously (true) or asynchronously (false).
    *
    * <p>If not set then the server will default to asynchronous shutdown.
    */
   String BLOCKING_SHUTDOWN = "jboss.server.blockingshutdown";

   /**
    * Constant that holds the name of the environment property
    * for specifying whether or not to install the lifethread
    *
    * <p>If not set then the server will default to installing the lifethread.
    */
   String INSTALL_LIFE_THREAD = "jboss.server.lifethread";

   /**
    * Constant that holds the name of the environment property for
    * specifying whether or not the server should log and ignore
    * exceptions when setting the URLStreamHandlerFactory.
    *
    * <p>If not set then the server will default to asynchronous shutdown.
    */
   String REQUIRE_JBOSS_URL_STREAM_HANDLER_FACTORY = "jboss.server.requirejbossurlstreamhandlerfactory";

}
