/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.impl.as.config;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.bootstrap.impl.base.config.AbstractBasicServerConfig;
import org.jboss.bootstrap.spi.as.config.JBossASServerConfig;
import org.jboss.logging.Logger;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagementObject(name="jboss.system:type=ServerConfig", isRuntime=true, properties=ManagementProperties.EXPLICIT, description="provides a view of server config information", componentType=@ManagementComponent(type="MCBean", subtype="*"))
public class BasicJBossASServerConfig
extends AbstractBasicServerConfig<JBossASServerConfig>
implements JBossASServerConfig {
    private static final Logger log = Logger.getLogger(BasicJBossASServerConfig.class);
    private static String PROP_KEY_JGROUPS_UDP_MCAST_ADDRESS = "jgroups.udp.mcast_addr";
    private volatile String bindAddress;
    private URL jbossHome;
    private String serverName;
    private URL bootLibraryLocation;
    private URL serverBaseLocation;
    private URL serverHomeLocation;
    private URL commonBaseLocation;
    private URL commonLibLocation;
    private URL serverLogLocation;
    private URL serverConfLocation;
    private URL serverLibLocation;
    private URL serverDataLocation;
    private URL serverTempLocation;
    private volatile String partitionName;
    private volatile String udpGroup;
    private volatile Integer udpPort;
    private volatile Boolean loadNative;
    private URL nativeLibraryLocation;
    private volatile Boolean usePlatformMBeanServer;

    public BasicJBossASServerConfig() {
        super(JBossASServerConfig.class);
    }

    public synchronized JBossASServerConfig bindAddress(String bindAddress) throws IllegalArgumentException {
        this.bindAddress = bindAddress;
        this.setPropertyForString("jboss.bind.address", bindAddress);
        return (JBossASServerConfig)this.covarientReturn();
    }

    public synchronized String getBindAddress() {
        return this.bindAddress;
    }

    public String getServerName() {
        return this.serverName;
    }

    public JBossASServerConfig jbossHome(String jbossHome) throws IllegalArgumentException {
        if (jbossHome == null) {
            return this.jbossHome((URL)null);
        }
        URL jbossHomeUrl = this.getUrlFromString(jbossHome);
        return this.jbossHome(jbossHomeUrl);
    }

    public synchronized JBossASServerConfig jbossHome(URL jbossHome) {
        this.jbossHome = jbossHome;
        this.setPropertyForUrlAndDir("jboss.home.url", "jboss.home", jbossHome);
        this.setPropertyForUrlAndDir("jboss.home.url", "jboss.home.dir", jbossHome);
        return (JBossASServerConfig)this.covarientReturn();
    }

    public synchronized JBossASServerConfig serverName(String serverName) {
        this.serverName = serverName;
        this.setPropertyForString("jboss.server.name", serverName);
        return (JBossASServerConfig)this.covarientReturn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getJBossHome() {
        URL url = null;
        BasicJBossASServerConfig basicJBossASServerConfig = this;
        synchronized (basicJBossASServerConfig) {
            url = this.jbossHome;
        }
        return this.copyURL(url);
    }

    public JBossASServerConfig bootLibraryLocation(String bootLibraryLocation) throws IllegalArgumentException {
        if (bootLibraryLocation == null) {
            return this.bootLibraryLocation((URL)null);
        }
        URL url = this.getUrlFromString(bootLibraryLocation);
        return this.bootLibraryLocation(url);
    }

    public synchronized JBossASServerConfig bootLibraryLocation(URL bootLibraryLocation) {
        this.bootLibraryLocation = bootLibraryLocation;
        this.setPropertyForUrl("jboss.lib.url", bootLibraryLocation);
        return (JBossASServerConfig)this.covarientReturn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getBootLibraryLocation() {
        URL url = null;
        BasicJBossASServerConfig basicJBossASServerConfig = this;
        synchronized (basicJBossASServerConfig) {
            url = this.bootLibraryLocation;
        }
        return this.copyURL(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getServerBaseLocation() {
        URL url = null;
        BasicJBossASServerConfig basicJBossASServerConfig = this;
        synchronized (basicJBossASServerConfig) {
            url = this.serverBaseLocation;
        }
        return this.copyURL(url);
    }

    public JBossASServerConfig serverBaseLocation(String serverBaseLocation) throws IllegalArgumentException {
        if (serverBaseLocation == null) {
            return this.serverBaseLocation((URL)null);
        }
        URL url = this.getUrlFromString(serverBaseLocation);
        return this.serverBaseLocation(url);
    }

    public synchronized JBossASServerConfig serverBaseLocation(URL serverBaseLocation) {
        this.serverBaseLocation = serverBaseLocation;
        this.setPropertyForUrlAndDir("jboss.server.base.url", "jboss.server.base.dir", serverBaseLocation);
        return (JBossASServerConfig)this.covarientReturn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getServerHomeLocation() {
        URL url = null;
        BasicJBossASServerConfig basicJBossASServerConfig = this;
        synchronized (basicJBossASServerConfig) {
            url = this.serverHomeLocation;
        }
        return this.copyURL(url);
    }

    public JBossASServerConfig serverHomeLocation(String serverHomeLocation) throws IllegalArgumentException {
        if (serverHomeLocation == null) {
            return this.serverHomeLocation((URL)null);
        }
        URL url = this.getUrlFromString(serverHomeLocation);
        return this.serverHomeLocation(url);
    }

    public synchronized JBossASServerConfig serverHomeLocation(URL serverHomeLocation) {
        this.serverHomeLocation = serverHomeLocation;
        this.setPropertyForUrlAndDir("jboss.server.home.url", "jboss.server.home.dir", serverHomeLocation);
        return (JBossASServerConfig)this.covarientReturn();
    }

    public JBossASServerConfig commonBaseLocation(String commonBaseLocation) throws IllegalArgumentException {
        if (commonBaseLocation == null) {
            return this.commonBaseLocation((URL)null);
        }
        URL url = this.getUrlFromString(commonBaseLocation);
        return this.commonBaseLocation(url);
    }

    public synchronized JBossASServerConfig commonBaseLocation(URL commonBaseLocation) {
        this.commonBaseLocation = commonBaseLocation;
        this.setPropertyForUrl("jboss.common.base.url", commonBaseLocation);
        return (JBossASServerConfig)this.covarientReturn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getCommonBaseLocation() {
        URL url = null;
        BasicJBossASServerConfig basicJBossASServerConfig = this;
        synchronized (basicJBossASServerConfig) {
            url = this.commonBaseLocation;
        }
        return this.copyURL(url);
    }

    public JBossASServerConfig commonLibLocation(String commonLibLocation) throws IllegalArgumentException {
        if (commonLibLocation == null) {
            return this.commonLibLocation((URL)null);
        }
        URL url = this.getUrlFromString(commonLibLocation);
        return this.commonLibLocation(url);
    }

    public synchronized JBossASServerConfig commonLibLocation(URL commonLibLocation) {
        this.commonLibLocation = commonLibLocation;
        this.setPropertyForUrl("jboss.common.lib.url", commonLibLocation);
        return (JBossASServerConfig)this.covarientReturn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getCommonLibLocation() {
        URL url = null;
        BasicJBossASServerConfig basicJBossASServerConfig = this;
        synchronized (basicJBossASServerConfig) {
            url = this.commonLibLocation;
        }
        return this.copyURL(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getServerLogLocation() {
        URL url = null;
        BasicJBossASServerConfig basicJBossASServerConfig = this;
        synchronized (basicJBossASServerConfig) {
            url = this.serverLogLocation;
        }
        return this.copyURL(url);
    }

    public JBossASServerConfig serverLogLocation(String serverLogLocation) throws IllegalArgumentException {
        if (serverLogLocation == null) {
            return this.serverLogLocation((URL)null);
        }
        URL url = this.getUrlFromString(serverLogLocation);
        return this.serverLogLocation(url);
    }

    public synchronized JBossASServerConfig serverLogLocation(URL serverLogLocation) {
        this.serverLogLocation = serverLogLocation;
        String location = null;
        if (serverLogLocation != null) {
            URI uri = null;
            try {
                uri = serverLogLocation.toURI();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Error in format of " + uri, e);
            }
            location = new File(uri).getAbsolutePath();
        }
        this.setPropertyForString("jboss.server.log.dir", location);
        return (JBossASServerConfig)this.covarientReturn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getServerConfLocation() {
        URL url = null;
        BasicJBossASServerConfig basicJBossASServerConfig = this;
        synchronized (basicJBossASServerConfig) {
            url = this.serverConfLocation;
        }
        return this.copyURL(url);
    }

    public JBossASServerConfig serverConfLocation(String serverConfigLocation) throws IllegalArgumentException {
        if (serverConfigLocation == null) {
            return this.serverConfLocation((URL)null);
        }
        URL url = this.getUrlFromString(serverConfigLocation);
        return this.serverConfLocation(url);
    }

    public synchronized JBossASServerConfig serverConfLocation(URL serverConfigLocation) {
        this.serverConfLocation = serverConfigLocation;
        this.setPropertyForUrl("jboss.server.config.url", serverConfigLocation);
        return (JBossASServerConfig)this.covarientReturn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getServerLibLocation() {
        URL url = null;
        BasicJBossASServerConfig basicJBossASServerConfig = this;
        synchronized (basicJBossASServerConfig) {
            url = this.serverLibLocation;
        }
        return this.copyURL(url);
    }

    public JBossASServerConfig serverLibLocation(String serverLibLocation) throws IllegalArgumentException {
        if (serverLibLocation == null) {
            return this.serverLibLocation((URL)null);
        }
        URL url = this.getUrlFromString(serverLibLocation);
        return this.serverLibLocation(url);
    }

    public synchronized JBossASServerConfig serverLibLocation(URL serverLibLocation) {
        this.serverLibLocation = serverLibLocation;
        this.setPropertyForUrl("jboss.server.lib.url", serverLibLocation);
        return (JBossASServerConfig)this.covarientReturn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getServerDataLocation() {
        URL url = null;
        BasicJBossASServerConfig basicJBossASServerConfig = this;
        synchronized (basicJBossASServerConfig) {
            url = this.serverDataLocation;
        }
        return this.copyURL(url);
    }

    public JBossASServerConfig serverDataLocation(String serverDataLocation) throws IllegalArgumentException {
        if (serverDataLocation == null) {
            return this.serverDataLocation((URL)null);
        }
        URL url = this.getUrlFromString(serverDataLocation);
        return this.serverDataLocation(url);
    }

    public synchronized JBossASServerConfig serverDataLocation(URL serverDataLocation) {
        this.serverDataLocation = serverDataLocation;
        String location = null;
        if (serverDataLocation != null) {
            URI uri = null;
            try {
                uri = serverDataLocation.toURI();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Error in format of " + uri, e);
            }
            location = new File(uri).getAbsolutePath();
        }
        this.setPropertyForString("jboss.server.data.dir", location);
        return (JBossASServerConfig)this.covarientReturn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getServerTempLocation() {
        URL url = null;
        BasicJBossASServerConfig basicJBossASServerConfig = this;
        synchronized (basicJBossASServerConfig) {
            url = this.serverTempLocation;
        }
        return this.copyURL(url);
    }

    public JBossASServerConfig serverTempLocation(String serverTempLocation) throws IllegalArgumentException {
        if (serverTempLocation == null) {
            return this.serverTempLocation((URL)null);
        }
        URL url = this.getUrlFromString(serverTempLocation);
        return this.serverTempLocation(url);
    }

    public synchronized JBossASServerConfig serverTempLocation(URL serverTempLocation) {
        this.serverTempLocation = serverTempLocation;
        String location = null;
        if (serverTempLocation != null) {
            URI uri = null;
            try {
                uri = serverTempLocation.toURI();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Error in format of " + uri, e);
            }
            location = new File(uri).getAbsolutePath();
        }
        this.setPropertyForString("jboss.server.temp.dir", location);
        return (JBossASServerConfig)this.covarientReturn();
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public synchronized JBossASServerConfig partitionName(String partitionName) {
        this.partitionName = partitionName;
        this.setPropertyForString("jboss.partition.name", partitionName);
        return (JBossASServerConfig)this.covarientReturn();
    }

    public String getUdpGroup() {
        return this.udpGroup;
    }

    public synchronized JBossASServerConfig udpGroup(String udpGroup) {
        this.udpGroup = udpGroup;
        this.setPropertyForString("jboss.partition.udpGroup", udpGroup);
        this.setPropertyForString(PROP_KEY_JGROUPS_UDP_MCAST_ADDRESS, udpGroup);
        return (JBossASServerConfig)this.covarientReturn();
    }

    public Integer getUdpPort() {
        return this.udpPort;
    }

    public synchronized JBossASServerConfig udpPort(Integer udpPort) {
        this.udpPort = udpPort;
        this.setPropertyForString("jboss.jgroups.udp.mcast_port", udpPort);
        return (JBossASServerConfig)this.covarientReturn();
    }

    public Boolean isLoadNative() {
        return this.loadNative;
    }

    public synchronized JBossASServerConfig loadNative(Boolean loadNative) {
        this.loadNative = loadNative;
        this.setPropertyForString("jboss.native.load", loadNative);
        return (JBossASServerConfig)this.covarientReturn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getNativeLibraryLocation() {
        URL url = null;
        BasicJBossASServerConfig basicJBossASServerConfig = this;
        synchronized (basicJBossASServerConfig) {
            url = this.nativeLibraryLocation;
        }
        return this.copyURL(url);
    }

    public JBossASServerConfig nativeLibraryLocation(String nativeLibraryLocation) throws IllegalArgumentException {
        if (nativeLibraryLocation == null) {
            return this.nativeLibraryLocation((URL)null);
        }
        URL url = this.getUrlFromString(nativeLibraryLocation);
        return this.nativeLibraryLocation(url);
    }

    public synchronized JBossASServerConfig nativeLibraryLocation(URL nativeLibraryLocation) {
        this.nativeLibraryLocation = nativeLibraryLocation;
        String location = null;
        if (nativeLibraryLocation != null) {
            URI uri = null;
            try {
                uri = nativeLibraryLocation.toURI();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Error in format of " + uri, e);
            }
            location = new File(uri).getAbsolutePath();
        }
        this.setPropertyForString("jboss.native.dir", location);
        return (JBossASServerConfig)this.covarientReturn();
    }

    public Boolean isUsePlatformMBeanServer() {
        return this.usePlatformMBeanServer;
    }

    public synchronized JBossASServerConfig usePlatformMBeanServer(Boolean usePlatformMBeanServer) {
        this.usePlatformMBeanServer = usePlatformMBeanServer;
        this.setPropertyForString("jboss.platform.mbeanserver", usePlatformMBeanServer);
        return (JBossASServerConfig)this.covarientReturn();
    }

    private URL getUrlFromString(String arg) throws IllegalArgumentException {
        URL resolvedUrl = null;
        try {
            resolvedUrl = new URL(arg);
            return resolvedUrl;
        }
        catch (MalformedURLException murle) {
            File file = new File(arg);
            try {
                resolvedUrl = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Cannot construct URL for argument given: " + arg, e);
            }
            return resolvedUrl;
        }
    }

    private void setPropertyForUrlAndDir(String urlPropName, String dirPropName, URL url) throws IllegalArgumentException {
        if (urlPropName == null || urlPropName.length() == 0) {
            throw new IllegalArgumentException("urlPropName is required");
        }
        if (dirPropName == null || dirPropName.length() == 0) {
            throw new IllegalArgumentException("dirPropName is required");
        }
        this.setPropertyForUrl(urlPropName, url);
        if (url == null) {
            this.setPropertyForString(dirPropName, null);
        } else {
            URI uri;
            try {
                uri = url.toURI();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Error in format of " + urlPropName + ": + url", e);
            }
            File file = new File(uri);
            String location = file.getAbsolutePath();
            this.setPropertyForString(dirPropName, location);
        }
    }
}

