/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.bootstrap.spi.server;

import org.jboss.bootstrap.spi.config.ServerConfig;
import org.jboss.bootstrap.spi.lifecycle.LifecycleState;

/**
 * ServerInitializer
 *
 * @author <a href="mailto:andrew.rubinger@jboss.org">ALR</a>
 * @version $Revision: $
 */
public interface ServerInitializer<K extends Server<K, T>, T extends ServerConfig<T>>
{
   //-------------------------------------------------------------------------------------||
   // Contracts --------------------------------------------------------------------------||
   //-------------------------------------------------------------------------------------||

   /**
    * Initializes the specified server.  May perform tasks such
    * as validation and defaulting of an underlying configuration.
    * 
    * @param server The server to initialize
    * @throws IllegalArgumentException If the server was not specified / null, or 
    *       its configuration is somehow invalid
    * @throws IllegalStateException If the server's state is not 
    *       {@link LifecycleState#PRE_INIT}
    */
   void initialize(Server<K, T> server) throws IllegalArgumentException, IllegalStateException;

   /**
    * Cleans up any actions taken during the initialization phase
    * in preparation for server shutdown
    * 
    * @param server
    * @throws IllegalArgumentException
    * @throws IllegalStateException If the server's state is not {@link LifecycleState#STOPPING}
    */
   void cleanup(Server<K, T> server) throws IllegalArgumentException, IllegalStateException;
}
