/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.spi.config;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.jboss.bootstrap.spi.config.ConfigurationInitializer;
import org.jboss.bootstrap.spi.config.InvalidConfigurationException;
import org.jboss.bootstrap.spi.config.SecurityActions;
import org.jboss.bootstrap.spi.config.ServerConfig;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBasicConfigurationInitializer<T extends ServerConfig<T>>
implements ConfigurationInitializer<T> {
    private static final Logger log = Logger.getLogger(AbstractBasicConfigurationInitializer.class);

    @Override
    public void initialize(T config) throws InvalidConfigurationException, IllegalArgumentException, IllegalStateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Initializing: " + config));
        }
        this.applySystemPropertyOverrides(config);
        URL bootstrapUrl = config.getBootstrapUrl();
        URL home = config.getBootstrapHome();
        URL conf = config.getBootstrapConfLocation();
        String name = config.getBootstrapName();
        if (bootstrapUrl == null && home != null && name != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"No bootstrap URL defined, constructing it from home and name...");
            }
            URL newBootstrapUrl = null;
            try {
                newBootstrapUrl = new URL(home, name);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(new InvalidConfigurationException("Cannot construct bootstrapURL from home and name", e));
            }
            log.debug((Object)("New bootstrap URL: " + newBootstrapUrl.toExternalForm()));
            config.bootstrapUrl(newBootstrapUrl);
        }
        if (conf == null) {
            URL newConf = null;
            if (home != null) {
                try {
                    String homeExternal = home.toExternalForm();
                    newConf = new URL(homeExternal);
                    log.debug((Object)("Defaulted bootstrapConf from bootstrap home: " + homeExternal));
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("Could not default the conf from home", e);
                }
            }
            if (bootstrapUrl != null) {
                try {
                    String bootstrapUrlString = bootstrapUrl.toExternalForm();
                    String bootstrapUrlBase = bootstrapUrlString.substring(0, bootstrapUrlString.lastIndexOf("/") + 1);
                    newConf = new URL(bootstrapUrlBase);
                    log.debug((Object)("Defaulted bootstrapConf from bootstrapURL's base: " + bootstrapUrlBase));
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("Could not default the conf from bootstrapURL base", e);
                }
            }
            if (newConf != null) {
                config.bootstrapConfLocation(newConf);
            }
        }
        if (name == null || name.length() == 0) {
            config.bootstrapName("bootstrap.xml");
            this.initialize(config);
        }
        if (home == null) {
            URL newHome = SecurityActions.getCodeSourceLocation(this.getClass());
            config.bootstrapHome(newHome);
            this.initialize(config);
        }
    }

    protected void applySystemPropertyOverrides(T config) throws IllegalArgumentException {
        String overrideName;
        String overrideUrl;
        String overrideConf;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Applying system property overrides...");
        }
        if (config == null) {
            throw new IllegalArgumentException("Supplied configuration is null");
        }
        Map<String, String> properties = config.getProperties();
        String overrideHome = this.getOverrideValue("jboss.bootstrap.home.url", properties);
        if (overrideHome != null) {
            config.bootstrapHome(overrideHome);
        }
        if ((overrideConf = this.getOverrideValue("jboss.bootstrap.conf.url", properties)) != null) {
            config.bootstrapConfLocation(overrideConf);
        }
        if ((overrideUrl = this.getOverrideValue("jboss.bootstrap.url", properties)) != null) {
            config.bootstrapUrl(overrideUrl);
        }
        if ((overrideName = this.getOverrideValue("jboss.bootstrap.name", properties)) != null) {
            config.bootstrapName(overrideName);
        }
    }

    private String getOverrideValue(String propertyName, Map<String, String> properties) throws IllegalArgumentException {
        String override = properties.get(propertyName);
        if (override != null && override.length() == 0) {
            override = null;
        }
        if (override != null && override.length() > 0) {
            log.debug((Object)("Got system property " + propertyName + ", so using as override: " + override));
        }
        return override;
    }
}

