/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.spi.config;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.bootstrap.spi.config.ServerConfig;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBasicServerConfig<T extends ServerConfig<T>>
implements ServerConfig<T> {
    private static final Logger log = Logger.getLogger(AbstractBasicServerConfig.class);
    private static final String TRAILING_SLASH = "/";
    private Class<T> actualClass;
    private URL bootstrapUrl;
    private URL bootstrapConfLocation;
    private URL bootstrapHome;
    private String bootstrapName;
    private ConcurrentMap<String, String> properties;
    private AtomicBoolean frozen;

    public AbstractBasicServerConfig(Class<T> actualClass) {
        this(actualClass, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractBasicServerConfig(Class<T> actualClass, Map<String, String> overrideProperties) {
        Properties sysProps = System.getProperties();
        ConcurrentHashMap<String, String> properties = new ConcurrentHashMap<String, String>();
        Set<Object> sysPropKeys = sysProps.keySet();
        for (Object sysPropKey : sysPropKeys) {
            String sysPropKeyString = (String)sysPropKey;
            String value = sysProps.getProperty(sysPropKeyString);
            properties.put(sysPropKeyString, value);
        }
        if (overrideProperties != null) {
            properties.putAll(overrideProperties);
        }
        this.properties = properties;
        AbstractBasicServerConfig abstractBasicServerConfig = this;
        synchronized (abstractBasicServerConfig) {
            this.actualClass = actualClass;
        }
        this.frozen = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getBootstrapConfLocation() {
        URL url = null;
        AbstractBasicServerConfig abstractBasicServerConfig = this;
        synchronized (abstractBasicServerConfig) {
            url = this.bootstrapConfLocation;
        }
        return this.copyURL(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getBootstrapHome() {
        URL url = null;
        AbstractBasicServerConfig abstractBasicServerConfig = this;
        synchronized (abstractBasicServerConfig) {
            url = this.bootstrapHome;
        }
        return this.copyURL(url);
    }

    @Override
    public synchronized String getBootstrapName() {
        return this.bootstrapName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getBootstrapUrl() {
        URL url = null;
        AbstractBasicServerConfig abstractBasicServerConfig = this;
        synchronized (abstractBasicServerConfig) {
            url = this.bootstrapUrl;
        }
        return this.copyURL(url);
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public synchronized T bootstrapConfLocation(URL confLocation) throws IllegalArgumentException {
        this.checkMutable();
        URL newUrl = this.adjustToDirectory(confLocation);
        this.setPropertyForUrl("jboss.bootstrap.conf.url", newUrl);
        this.bootstrapConfLocation = newUrl;
        return this.covarientReturn();
    }

    @Override
    public synchronized T bootstrapHome(URL bootstrapHome) throws IllegalArgumentException {
        this.checkMutable();
        URL newUrl = this.adjustToDirectory(bootstrapHome);
        this.setPropertyForUrl("jboss.bootstrap.home.url", newUrl);
        this.bootstrapHome = newUrl;
        return this.covarientReturn();
    }

    @Override
    public synchronized T bootstrapName(String name) throws IllegalArgumentException {
        this.checkMutable();
        this.setPropertyForString("jboss.bootstrap.name", name);
        this.bootstrapName = name;
        return this.covarientReturn();
    }

    @Override
    public synchronized T bootstrapUrl(URL bootstrapLocation) throws IllegalArgumentException {
        this.checkMutable();
        this.setPropertyForUrl("jboss.bootstrap.url", bootstrapLocation);
        this.bootstrapUrl = bootstrapLocation;
        return this.covarientReturn();
    }

    @Override
    public T property(String key, String value) throws IllegalArgumentException {
        this.checkMutable();
        this.setPropertyForString(key, value);
        return this.covarientReturn();
    }

    @Override
    public void freeze() throws IllegalStateException {
        this.frozen.set(true);
    }

    @Override
    public boolean isFrozen() {
        return this.frozen.get();
    }

    @Override
    public T bootstrapConfLocation(String confLocation) throws IllegalArgumentException, IllegalStateException {
        this.bootstrapConfLocation(this.urlFromString(confLocation));
        return this.covarientReturn();
    }

    @Override
    public T bootstrapHome(String bootstrapHome) throws IllegalArgumentException, IllegalStateException {
        this.bootstrapHome(this.urlFromString(bootstrapHome));
        return this.covarientReturn();
    }

    @Override
    public T bootstrapUrl(String bootstrapUrl) throws IllegalArgumentException, IllegalStateException {
        this.bootstrapUrl(this.urlFromString(bootstrapUrl));
        return this.covarientReturn();
    }

    protected void setPropertyForUrl(String propertyName, URL url) {
        String urlString = url != null ? url.toExternalForm() : null;
        this.setPropertyForString(propertyName, urlString);
    }

    protected void setPropertyForString(String propertyName, String value) {
        ConcurrentMap<String, String> properties = this.properties;
        String valueToSet = value;
        if (valueToSet == null) {
            valueToSet = "";
        }
        properties.put(propertyName, valueToSet);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Set property \"" + propertyName + "\" to: " + (value != null ? "\"" + value + "\"" : "[EMPTY]")));
        }
    }

    protected void checkMutable() throws IllegalStateException {
        if (this.isFrozen()) {
            throw new IllegalStateException("Cannot mutate state of the configuration after it has been frozen");
        }
    }

    protected URL adjustToDirectory(URL url) {
        if (url == null) {
            return null;
        }
        String externalForm = url.toExternalForm();
        if (externalForm.endsWith(TRAILING_SLASH)) {
            return url;
        }
        String newLocation = externalForm + TRAILING_SLASH;
        URL newUrl = null;
        try {
            newUrl = new URL(newLocation);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Could not create new URL to point to directory", e);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Appended trailing slash to " + url + " to point to directory: " + newUrl));
        }
        return newUrl;
    }

    protected Class<T> getActualClass() {
        return this.actualClass;
    }

    protected final T covarientReturn() throws ClassCastException {
        try {
            return (T)((ServerConfig)this.getActualClass().cast(this));
        }
        catch (ClassCastException cce) {
            throw new RuntimeException("Could not return the expected type; ensure that this configuration was constructed with the correct actual class", cce);
        }
    }

    protected final URL copyURL(URL url) {
        if (url == null) {
            return url;
        }
        try {
            return new URL(url.toExternalForm());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error in copying URL", e);
        }
    }

    protected final URL urlFromString(String url) throws IllegalArgumentException {
        try {
            return url != null ? new URL(url) : null;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Could not construct " + URL.class.getSimpleName() + " from the supplied argument: " + url, e);
        }
    }
}

