/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.spi.server;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.logging.Logger;

class SecurityActions {
    private static final Logger log = Logger.getLogger(SecurityActions.class);

    private SecurityActions() {
    }

    static void setSystemProperty(final String key, final String value) throws IllegalArgumentException {
        SecurityActions.ensureSysPropKeySpecified(key);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.setProperty(key, value);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Set system property \"" + key + "\" > " + value));
                }
                return null;
            }
        });
    }

    static void clearSystemProperty(final String key) throws IllegalArgumentException {
        SecurityActions.ensureSysPropKeySpecified(key);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                String previousValue = System.clearProperty(key);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Removed system property \"" + key + "\" which had previous value: " + previousValue));
                }
                return null;
            }
        });
    }

    private static void ensureSysPropKeySpecified(String key) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("Key for System Property was not specified");
        }
    }
}

