/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.bootstrap.spi.config;

/**
 * ConfigurationInitializer
 * 
 * Contract for initializers of a supplied ServerConfig.
 * May be responsible for setting default values
 * where unspecified, etc.
 *
 * @author <a href="mailto:andrew.rubinger@jboss.org">ALR</a>
 * @version $Revision: $
 */
public interface ConfigurationInitializer<T extends ServerConfig<?>>
{
   //-------------------------------------------------------------------------------------||
   // Constants --------------------------------------------------------------------------||
   //-------------------------------------------------------------------------------------||

   /**
    * The default value of the name of the bootstrap file
    */
   String DEFAULT_VALUE_BOOTSTRAP_NAME = "bootstrap.xml";

   //-------------------------------------------------------------------------------------||
   // Contracts --------------------------------------------------------------------------||
   //-------------------------------------------------------------------------------------||

   /**
    * Initializes the specified configuration
    * 
    * @param config
    * @throws InvalidConfigurationException If the configuration was invalid
    *       and initialization was unable to proceed
    * @throws IllegalArgumentException If the config was not specified
    * @throws IllegalStateException If the config has been frozen (immutable)
    */
   void initialize(T config) throws InvalidConfigurationException, IllegalArgumentException, IllegalStateException;
}
