/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bootstrap.spi;

import org.jboss.bootstrap.api.config.ServerConfig;
import org.jboss.bootstrap.api.server.Server;

/**
 * Bootstrap
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 1.1 $
 */
public interface Bootstrap<K extends Server<K, T>, T extends ServerConfig<T>>
{
   /**
    * Invoked at startup
    * 
    * @param server the server instance
    * @throws Exception for any error
    */
   void start(K server) throws Exception;

   /**
    * Invoked to say we are preparing shutdown
    * 
    * @param server the server
    */
   void prepareShutdown(K server);

   /**
    * Invoked at shutdown
    * 
    * @param server the server instance
    */
   void shutdown(K server);
}
