/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.demo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.FqnComparator;
import org.jboss.cache.Node;
import org.jboss.cache.demo.JBossCacheDemo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTreeRefresher {
    private JTree tree;
    private Map<Fqn<String>, FqnTreeNode> treeNodes = new ConcurrentHashMap<Fqn<String>, FqnTreeNode>();
    private Cache<String, String> cache;
    private Log log = LogFactory.getLog(DataTreeRefresher.class);
    private JBossCacheDemo.NodeDataTableModel tableModel;

    public DataTreeRefresher(JTree tree, Cache<String, String> cache, JBossCacheDemo.NodeDataTableModel tableModel) {
        this.tree = tree;
        this.cache = cache;
        this.tableModel = tableModel;
        this.populateDataTree();
    }

    private void populateDataTree() {
        FqnTreeNode node = new FqnTreeNode(Fqn.ROOT);
        this.treeNodes.put((Fqn<String>)Fqn.ROOT, node);
        OrderedTreeModel model = new OrderedTreeModel(node);
        this.tree.setModel(model);
        this.populateChildren((Node<String, String>)this.cache.getRoot());
        this.repaint();
    }

    private void populateChildren(Node<String, String> cacheNode) {
        for (Node cacheChild : cacheNode.getChildren()) {
            this.getOrCreateTreeNode((Fqn<String>)cacheChild.getFqn());
            this.populateChildren((Node<String, String>)cacheChild);
        }
    }

    private FqnTreeNode getOrCreateTreeNode(Fqn<String> f) {
        FqnTreeNode treeNode = this.treeNodes.get(f);
        if (treeNode == null) {
            treeNode = new FqnTreeNode(f);
            FqnTreeNode parent = this.getOrCreateTreeNode((Fqn<String>)f.getParent());
            parent.add(treeNode);
            treeNode.setParent(parent);
            this.treeNodes.put(f, treeNode);
        }
        return treeNode;
    }

    public void addNode(Fqn<String> f) {
        this.log.debug((Object)("Adding node " + f), new Throwable());
        this.getOrCreateTreeNode(f);
    }

    public void removeNode(Fqn<String> f) {
        if (this.treeNodes.containsKey(f)) {
            this.removeTreeNode(this.treeNodes.get(f));
        }
    }

    private void removeTreeNode(FqnTreeNode treeNode) {
        Enumeration<TreeNode> en = treeNode.children();
        while (en.hasMoreElements()) {
            FqnTreeNode child = (FqnTreeNode)en.nextElement();
            this.removeTreeNode(child);
        }
        if (!treeNode.getFqn().isRoot()) {
            this.treeNodes.remove(treeNode.getFqn());
            treeNode.removeFromParent();
        }
    }

    public void repaint() {
        TreePath path = this.tree.getSelectionPath();
        this.tableModel.setCurrentFqn(null);
        Map<String, String> m = Collections.emptyMap();
        this.tableModel.setData(m);
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.tree.setSelectionPath(path);
        if (path != null) {
            while ((path = path.getParentPath()) != null) {
                this.tree.expandPath(path);
            }
        }
    }

    class OrderedTreeModel
    extends DefaultTreeModel {
        public OrderedTreeModel(TreeNode root) {
            super(root);
        }

        public OrderedTreeModel(TreeNode root, boolean asksAllowsChildren) {
            super(root, asksAllowsChildren);
        }

        public int getIndexOfChild(Object parent, Object child) {
            this.orderChildren(parent);
            return super.getIndexOfChild(parent, child);
        }

        public Object getChild(Object parent, int index) {
            this.orderChildren(parent);
            return super.getChild(parent, index);
        }

        private void orderChildren(Object parent) {
            if (parent == null) {
                return;
            }
            if (parent instanceof FqnTreeNode) {
                FqnTreeNode node = (FqnTreeNode)parent;
                ArrayList<TreeNode> children = Collections.list(node.children());
                Collections.sort(children);
                node.removeAllChildren();
                Iterator<TreeNode> childrenIterator = children.iterator();
                while (childrenIterator.hasNext()) {
                    node.add((FqnTreeNode)childrenIterator.next());
                }
            }
        }
    }

    class FqnTreeNode
    extends DefaultMutableTreeNode
    implements Comparable {
        private Fqn fqn;

        FqnTreeNode(Fqn fqn) {
            super(fqn.isRoot() ? "/" : fqn.getLastElement());
            this.fqn = fqn;
        }

        public Fqn getFqn() {
            return this.fqn;
        }

        public void setFqn(Fqn fqn) {
            this.fqn = fqn;
        }

        public int compareTo(Object o) {
            FqnTreeNode other = (FqnTreeNode)o;
            return FqnComparator.INSTANCE.compare(this.fqn, other.getFqn());
        }
    }
}

