/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.AbstractNode;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InternalNode;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.VersionedNode;
import org.jboss.cache.marshall.MarshalledValue;
import org.jboss.cache.util.FastCopyHashMap;
import org.jboss.cache.util.Immutables;
import org.jboss.cache.util.concurrent.SelfInitializingConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnversionedNode<K, V>
extends AbstractNode<K, V>
implements InternalNode<K, V> {
    protected static Log log = LogFactory.getLog(UnversionedNode.class);
    protected static final boolean trace = log.isTraceEnabled();
    protected Map<K, V> data;
    protected NodeSPI<K, V> delegate;
    protected CacheSPI<K, V> cache;

    public UnversionedNode() {
        this.fqn = Fqn.ROOT;
        this.initFlags();
    }

    public UnversionedNode(Fqn fqn) {
        this.fqn = fqn;
        this.initFlags();
    }

    public UnversionedNode(Fqn fqn, CacheSPI<K, V> cache, boolean lockForChildInsertRemove) {
        this.initFlags();
        this.cache = cache;
        this.setLockForChildInsertRemove(lockForChildInsertRemove);
        this.fqn = fqn;
        this.children = fqn.isRoot() ? new ConcurrentHashMap(64, 0.5f, 16) : new SelfInitializingConcurrentHashMap();
    }

    public UnversionedNode(Fqn fqn, CacheSPI<K, V> cache, boolean lockForChildInsertRemove, Map<K, V> data) {
        this(fqn, cache, lockForChildInsertRemove);
        if (data != null) {
            this.data = new FastCopyHashMap<K, V>(data);
        }
    }

    protected void initFlags() {
        this.setFlag(AbstractNode.NodeFlags.DATA_LOADED);
        this.setFlag(AbstractNode.NodeFlags.VALID);
    }

    public NodeSPI<K, V> getDelegate() {
        return this.delegate;
    }

    public void setDelegate(NodeSPI<K, V> delegate) {
        this.delegate = delegate;
    }

    @Override
    public NodeSPI<K, V> getParent() {
        if (this.fqn.isRoot()) {
            return null;
        }
        return this.cache.peek(this.fqn.getParent(), true);
    }

    @Override
    public CacheSPI<K, V> getCache() {
        return this.cache;
    }

    @Override
    public boolean isChildrenLoaded() {
        return this.isFlagSet(AbstractNode.NodeFlags.CHILDREN_LOADED);
    }

    @Override
    public void setChildrenLoaded(boolean childrenLoaded) {
        this.setFlag(AbstractNode.NodeFlags.CHILDREN_LOADED, childrenLoaded);
    }

    @Override
    public V get(K key) {
        return this.data == null ? null : (V)this.data.get(key);
    }

    @Override
    public Map<K, V> getData() {
        if (this.data == null) {
            return Collections.emptyMap();
        }
        return this.data;
    }

    @Override
    public V put(K key, V value) {
        if (this.data == null) {
            this.data = Collections.singletonMap(key, value);
            return null;
        }
        if (this.data.size() == 1 && this.data.containsKey(key)) {
            V oldVal = this.data.get(key);
            this.data = Collections.singletonMap(key, value);
            return oldVal;
        }
        this.upgradeDataMap();
        return this.data.put(key, value);
    }

    @Override
    public InternalNode<K, V> getChild(Fqn f) {
        if (this.fqn.size() == 1) {
            return this.getChild(this.fqn.getLastElement());
        }
        InternalNode<K, V> currentNode = this;
        for (int i = 0; i < this.fqn.size(); ++i) {
            Object nextChildName = this.fqn.get(i);
            if ((currentNode = currentNode.getChild(nextChildName)) != null) continue;
            return null;
        }
        return currentNode;
    }

    @Override
    public InternalNode<K, V> getChild(Object childName) {
        if (childName == null) {
            return null;
        }
        return (InternalNode)this.children().get(childName);
    }

    @Override
    public Set<InternalNode<K, V>> getChildren() {
        if (this.children.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<InternalNode<K, V>> exclDeleted = new HashSet();
        for (InternalNode n : this.children().values()) {
            if (n.isRemoved()) continue;
            exclDeleted.add(n);
        }
        exclDeleted = Collections.unmodifiableSet(exclDeleted);
        return exclDeleted;
    }

    @Override
    public Set<InternalNode<K, V>> getChildren(boolean includeMarkedForRemoval) {
        if (includeMarkedForRemoval) {
            if (!this.children.isEmpty()) {
                return Immutables.immutableSetConvert(this.children().values());
            }
            return Collections.emptySet();
        }
        return this.getChildren();
    }

    @Override
    public ConcurrentMap<Object, InternalNode<K, V>> getChildrenMap() {
        return this.children();
    }

    @Override
    public void setChildrenMap(ConcurrentMap<Object, InternalNode<K, V>> children) {
        this.children = children;
    }

    @Override
    public void addChild(Object nodeName, InternalNode<K, V> nodeToAdd) {
        if (nodeName != null) {
            this.children().put(nodeName, nodeToAdd);
        }
    }

    @Override
    public void addChild(InternalNode<K, V> child) {
        this.addChild(child, false);
    }

    @Override
    public void addChild(InternalNode<K, V> child, boolean safe) {
        Fqn childFqn = child.getFqn();
        if (!safe && !childFqn.isDirectChildOf(this.fqn)) {
            throw new CacheException("Attempting to add a child [" + childFqn + "] to [" + this.fqn + "].  Can only add direct children.");
        }
        this.children().put(childFqn.getLastElement(), child);
    }

    @Override
    public V remove(K key) {
        V value;
        if (this.data == null) {
            return null;
        }
        if (this.data instanceof FastCopyHashMap) {
            value = this.data.remove(key);
            this.downgradeDataMapIfNeeded();
        } else {
            value = this.data.get(key);
            if (value != null || this.data.containsKey(key)) {
                this.data = null;
            }
        }
        return value;
    }

    @Override
    public void printDetails(StringBuilder sb, int indent) {
        this.printDetailsInMap(sb, indent);
    }

    public String toString() {
        int more;
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        if (!this.isValid()) {
            sb.append(" (invalid) ");
        }
        if (this.isRemoved()) {
            sb.append(" (deleted) [ ").append(this.fqn);
        } else {
            sb.append("[ ").append(this.fqn);
        }
        if (this instanceof VersionedNode) {
            sb.append(" version=").append(this.getVersion());
        }
        if (this.data != null) {
            if (trace) {
                sb.append(" data=").append(this.data.keySet());
            } else {
                sb.append(" data=[");
                Set<K> keys = this.data.keySet();
                i = 0;
                for (Object o : keys) {
                    sb.append(o);
                    if (++i == 5) {
                        more = keys.size() - 5;
                        if (more <= 1) continue;
                        sb.append(", and ");
                        sb.append(more);
                        sb.append(" more");
                        break;
                    }
                    sb.append(", ");
                }
                sb.append("]");
            }
        }
        if (!this.children.isEmpty()) {
            if (trace) {
                sb.append(" children=").append(this.getChildrenNames());
            } else {
                sb.append(" children=[");
                Set<Object> names = this.getChildrenNames();
                i = 0;
                for (Object o : names) {
                    sb.append(o);
                    if (++i == 5) {
                        more = names.size() - 5;
                        if (more <= 1) continue;
                        sb.append(", and ");
                        sb.append(more);
                        sb.append(" more");
                        break;
                    }
                    sb.append(", ");
                }
                sb.append("]");
            }
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void clear() {
        this.data = null;
    }

    @Override
    public Set<Object> getChildrenNames() {
        return this.children.isEmpty() ? Collections.emptySet() : Immutables.immutableSetCopy(this.children.keySet());
    }

    @Override
    public Set<K> getKeys() {
        if (this.data == null) {
            return Collections.emptySet();
        }
        return Immutables.immutableSetCopy(this.data.keySet());
    }

    @Override
    public boolean containsKey(K key) {
        return this.data != null && this.data.containsKey(key);
    }

    @Override
    public boolean removeChild(Object childName) {
        return this.children.remove(childName) != null;
    }

    @Override
    public boolean removeChild(Fqn f) {
        if (f.size() == 1) {
            return this.removeChild(f.getLastElement());
        }
        NodeSPI child = this.getChildDirect(f);
        return child != null && child.getParentDirect().removeChildDirect(f.getLastElement());
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> data) {
        if (data != null) {
            if (this.data == null) {
                this.data = this.copyDataMap(data);
            } else if (this.data.size() == 1 && data.size() == 1 && this.data.keySet().iterator().next().equals(data.keySet().iterator().next())) {
                Map.Entry<K, V> e = data.entrySet().iterator().next();
                this.data = Collections.singletonMap(e.getKey(), e.getValue());
            } else {
                this.upgradeDataMap();
                this.data.putAll(data);
            }
        }
    }

    protected final void upgradeDataMap() {
        if (this.data != null && !(this.data instanceof FastCopyHashMap)) {
            this.data = new FastCopyHashMap<K, V>(this.data);
        }
    }

    protected final void downgradeDataMapIfNeeded() {
        if (this.data.size() == 1 && this.data instanceof FastCopyHashMap) {
            Map.Entry<K, V> e = this.data.entrySet().iterator().next();
            this.data = Collections.singletonMap(e.getKey(), e.getValue());
        }
    }

    @Override
    public void removeChildren() {
        this.children.clear();
    }

    @Override
    public void markAsRemoved(boolean marker, boolean recursive) {
        this.setFlag(AbstractNode.NodeFlags.REMOVED, marker);
        if (recursive) {
            for (InternalNode child : this.children().values()) {
                child.markAsRemoved(marker, true);
            }
        }
    }

    protected final void printIndent(StringBuilder sb, int indent) {
        if (sb != null) {
            for (int i = 0; i < indent; ++i) {
                sb.append(" ");
            }
        }
    }

    @Override
    public Fqn getFqn() {
        return this.fqn;
    }

    @Override
    public void setFqn(Fqn fqn) {
        if (trace) {
            log.trace((Object)(this.getFqn() + " set FQN " + fqn));
        }
        this.fqn = fqn;
        for (Map.Entry me : this.children().entrySet()) {
            InternalNode n = (InternalNode)me.getValue();
            Fqn<Object> cfqn = Fqn.fromRelativeElements(fqn, me.getKey());
            n.setFqn(cfqn);
        }
    }

    @Override
    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    protected void printDetailsInMap(StringBuilder sb, int indent) {
        this.printIndent(sb, indent);
        indent += 2;
        sb.append("/");
        if (!this.fqn.isRoot()) {
            sb.append(this.fqn.getLastElement());
        }
        sb.append("  ");
        sb.append(this.data);
        for (InternalNode n : this.children().values()) {
            sb.append("\n");
            n.printDetails(sb, indent);
        }
    }

    @Override
    public boolean isDataLoaded() {
        return this.isFlagSet(AbstractNode.NodeFlags.DATA_LOADED);
    }

    @Override
    public void setDataLoaded(boolean dataLoaded) {
        this.setFlag(AbstractNode.NodeFlags.DATA_LOADED, dataLoaded);
    }

    @Override
    public boolean isValid() {
        return this.isFlagSet(AbstractNode.NodeFlags.VALID);
    }

    @Override
    public void setValid(boolean valid, boolean recursive) {
        this.setFlag(AbstractNode.NodeFlags.VALID, valid);
        if (trace) {
            log.trace((Object)("Marking node " + this.getFqn() + " as " + (valid ? "" : "in") + "valid"));
        }
        if (recursive) {
            for (InternalNode child : this.children().values()) {
                child.setValid(valid, recursive);
            }
        }
    }

    @Override
    public boolean isLockForChildInsertRemove() {
        return this.isFlagSet(AbstractNode.NodeFlags.LOCK_FOR_CHILD_INSERT_REMOVE);
    }

    @Override
    public void setLockForChildInsertRemove(boolean lockForChildInsertRemove) {
        this.setFlag(AbstractNode.NodeFlags.LOCK_FOR_CHILD_INSERT_REMOVE, lockForChildInsertRemove);
    }

    @Override
    public InternalNode<K, V> copy() {
        UnversionedNode<K, V> n = new UnversionedNode<K, V>(this.fqn, this.cache, this.isFlagSet(AbstractNode.NodeFlags.LOCK_FOR_CHILD_INSERT_REMOVE));
        n.data = this.copyDataMap(this.data);
        this.copyInternals(n);
        return n;
    }

    protected void copyInternals(UnversionedNode n) {
        n.children = this.children;
        n.delegate = this.delegate;
        n.flags = this.flags;
    }

    @Override
    public void setInternalState(Map state) {
        if (this.data == null) {
            this.data = this.copyDataMap(state);
        } else {
            this.putAll(state);
        }
    }

    protected final Map copyDataMap(Map<? extends K, ? extends V> toCopyFrom) {
        if (toCopyFrom != null && toCopyFrom.size() > 0) {
            Map<Object, Object> map;
            if (toCopyFrom instanceof FastCopyHashMap) {
                map = (FastCopyHashMap<? extends K, ? extends V>)((FastCopyHashMap)toCopyFrom).clone();
            } else if (toCopyFrom.size() == 1) {
                Map.Entry<K, V> e = toCopyFrom.entrySet().iterator().next();
                map = Collections.singletonMap(e.getKey(), e.getValue());
            } else {
                map = new FastCopyHashMap<K, V>(toCopyFrom);
            }
            return map;
        }
        return null;
    }

    @Override
    public Map getInternalState(boolean onlyInternalState) {
        if (onlyInternalState) {
            return new HashMap(0);
        }
        if (this.data == null) {
            return new HashMap(0);
        }
        return new HashMap<K, V>(this.data);
    }

    @Override
    public void releaseObjectReferences(boolean recursive) {
        if (recursive) {
            for (InternalNode child : this.children().values()) {
                child.releaseObjectReferences(recursive);
            }
        }
        if (this.data != null) {
            for (Object key : this.data.keySet()) {
                V value = this.data.get(key);
                if (key instanceof MarshalledValue) {
                    ((MarshalledValue)key).compact(true, true);
                }
                if (!(value instanceof MarshalledValue)) continue;
                ((MarshalledValue)value).compact(true, true);
            }
        }
    }

    private ConcurrentMap<Object, InternalNode<K, V>> children() {
        return this.children;
    }
}

