/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.write;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.Visitor;
import org.jboss.cache.commands.write.AbstractVersionedDataCommand;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.transaction.GlobalTransaction;

public class ClearDataCommand
extends AbstractVersionedDataCommand {
    public static final int METHOD_ID = 7;
    public static final int VERSIONED_METHOD_ID = 42;
    protected static final Log log = LogFactory.getLog(ClearDataCommand.class);
    protected static final boolean trace = log.isTraceEnabled();

    public ClearDataCommand(GlobalTransaction gtx, Fqn fqn) {
        this.globalTransaction = gtx;
        this.fqn = fqn;
    }

    public ClearDataCommand() {
    }

    public Object perform(InvocationContext ctx) {
        NodeSPI targetNode;
        if (trace) {
            log.trace((Object)("perform(" + this.globalTransaction + ", \"" + this.fqn + "\")"));
        }
        if ((targetNode = this.peekVersioned(ctx)) == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("node " + this.fqn + " not found"));
            }
            return null;
        }
        Map data = targetNode.getDataDirect();
        this.notifier.notifyNodeModified(this.fqn, true, NodeModifiedEvent.ModificationType.REMOVE_DATA, data, ctx);
        targetNode.clearDataDirect();
        this.notifier.notifyNodeModified(this.fqn, false, NodeModifiedEvent.ModificationType.REMOVE_DATA, data, ctx);
        return null;
    }

    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitClearDataCommand(ctx, this);
    }

    public int getCommandId() {
        return this.isVersioned() ? 42 : 7;
    }

    public Object[] getParameters() {
        if (this.isVersioned()) {
            return new Object[]{this.globalTransaction, this.fqn, true, this.dataVersion};
        }
        return new Object[]{this.globalTransaction, this.fqn, true};
    }

    public void setParameters(int commandId, Object[] args) {
        this.globalTransaction = (GlobalTransaction)args[0];
        this.fqn = (Fqn)args[1];
        if (this.isVersionedId(commandId)) {
            this.dataVersion = (DataVersion)args[3];
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClearDataCommand that = (ClearDataCommand)o;
        return !(this.globalTransaction == null ? that.globalTransaction != null : !this.globalTransaction.equals(that.globalTransaction));
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.globalTransaction != null ? this.globalTransaction.hashCode() : 0);
        return result;
    }

    protected boolean isVersionedId(int id) {
        return id == 42;
    }

    public String toString() {
        return "RemoveDataCommand{fqn=" + this.fqn + ", dataVersion=" + this.dataVersion + ", globalTransaction=" + this.globalTransaction + '}';
    }
}

