/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.commands.VisitableCommand;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import org.jboss.cache.invocation.InvocationContextContainer;
import org.jboss.cache.jmx.annotations.MBean;
import org.jboss.cache.jmx.annotations.ManagedOperation;
import org.jboss.cache.util.CachePrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MBean(description="InterceptorChain")
public class InterceptorChain {
    private CommandInterceptor firstInChain;
    private InvocationContextContainer invocationContextContainer;
    private static final Log log = LogFactory.getLog(InterceptorChain.class);

    public InterceptorChain(CommandInterceptor first) {
        this.firstInChain = first;
    }

    @Inject
    public void initialize(InvocationContextContainer invocationContextContainer) {
        this.invocationContextContainer = invocationContextContainer;
    }

    @Start
    void printChainInfo() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Interceptor chain is: " + this.toString()));
        }
    }

    public synchronized void addInterceptor(CommandInterceptor interceptor, int position) {
        if (position == 0) {
            interceptor.setNext(this.firstInChain);
            this.firstInChain = interceptor;
            return;
        }
        if (this.firstInChain == null) {
            return;
        }
        int index = 0;
        for (CommandInterceptor it = this.firstInChain; it != null; it = it.getNext()) {
            if (++index != position) continue;
            interceptor.setNext(it.getNext());
            it.setNext(interceptor);
            return;
        }
        throw new IllegalArgumentException("Invalid index: " + index + " !");
    }

    public synchronized void removeInterceptor(int position) {
        if (this.firstInChain == null) {
            return;
        }
        if (position == 0) {
            this.firstInChain = this.firstInChain.getNext();
            return;
        }
        int index = 0;
        for (CommandInterceptor it = this.firstInChain; it != null; it = it.getNext()) {
            if (++index != position) continue;
            if (it.getNext() == null) {
                return;
            }
            it.setNext(it.getNext().getNext());
            return;
        }
        throw new IllegalArgumentException("Invalid position: " + position + " !");
    }

    public int size() {
        int size = 0;
        for (CommandInterceptor it = this.firstInChain; it != null; it = it.getNext()) {
            ++size;
        }
        return size;
    }

    @ManagedOperation(description="Retrieves a list of the interceptors in the chain")
    public String getInterceptorDetails() {
        StringBuilder sb = new StringBuilder("Interceptor chain: \n");
        int count = 0;
        for (CommandInterceptor i : this.asList()) {
            sb.append("   ").append(++count).append(". ").append(i).append("\n");
        }
        return sb.toString();
    }

    @ManagedOperation(description="Retrieves a list of the interceptors in the chain, formatted as HTML")
    public String getInterceptorDetailsAsHtml() {
        return CachePrinter.formatHtml(this.getInterceptorDetails());
    }

    public List<CommandInterceptor> asList() {
        if (this.firstInChain == null) {
            return Collections.emptyList();
        }
        LinkedList<CommandInterceptor> retval = new LinkedList<CommandInterceptor>();
        CommandInterceptor tmp = this.firstInChain;
        do {
            retval.add(tmp);
        } while ((tmp = tmp.getNext()) != null);
        return Collections.unmodifiableList(retval);
    }

    public synchronized void removeInterceptor(Class<? extends CommandInterceptor> clazz) {
        if (this.firstInChain.getClass() == clazz) {
            this.firstInChain = this.firstInChain.getNext();
        }
        CommandInterceptor prevIt = this.firstInChain;
        for (CommandInterceptor it = this.firstInChain.getNext(); it != null; it = it.getNext()) {
            if (it.getClass() == clazz) {
                prevIt.setNext(it.getNext());
            }
            prevIt = it;
        }
    }

    public synchronized boolean addAfterInterceptor(CommandInterceptor toAdd, Class<? extends CommandInterceptor> afterInterceptor) {
        for (CommandInterceptor it = this.firstInChain; it != null; it = it.getNext()) {
            if (!it.getClass().equals(afterInterceptor)) continue;
            toAdd.setNext(it.getNext());
            it.setNext(toAdd);
            return true;
        }
        return false;
    }

    public synchronized boolean addBeforeInterceptor(CommandInterceptor toAdd, Class<? extends CommandInterceptor> beforeInterceptor) {
        if (this.firstInChain.getClass().equals(beforeInterceptor)) {
            toAdd.setNext(this.firstInChain);
            this.firstInChain = toAdd;
            return true;
        }
        CommandInterceptor it = this.firstInChain;
        while (it.getNext() != null) {
            if (it.getNext().getClass().equals(beforeInterceptor)) {
                toAdd.setNext(it.getNext());
                it.setNext(toAdd);
                return true;
            }
            it = it.getNext();
        }
        return false;
    }

    public void appendIntereceptor(CommandInterceptor ci) {
        CommandInterceptor it = this.firstInChain;
        while (it.hasNext()) {
            it = it.getNext();
        }
        it.setNext(ci);
        ci.setNext(null);
    }

    public Object invoke(InvocationContext ctx, VisitableCommand command) {
        ctx.setCommand(command);
        try {
            return command.acceptVisitor(ctx, this.firstInChain);
        }
        catch (CacheException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public Object invokeRemote(VisitableCommand cacheCommand) throws Throwable {
        InvocationContext ctxt = (InvocationContext)this.invocationContextContainer.get();
        ctxt.setOriginLocal(false);
        return cacheCommand.acceptVisitor(ctxt, this.firstInChain);
    }

    public Object invoke(VisitableCommand cacheCommand) throws Throwable {
        InvocationContext ctxt = (InvocationContext)this.invocationContextContainer.get();
        return cacheCommand.acceptVisitor(ctxt, this.firstInChain);
    }

    public CommandInterceptor getFirstInChain() {
        return this.firstInChain;
    }

    public void setFirstInChain(CommandInterceptor interceptor) {
        this.firstInChain = interceptor;
    }

    public InvocationContext getInvocationContext() {
        return (InvocationContext)this.invocationContextContainer.get();
    }

    public List<CommandInterceptor> getInterceptorsWhichExtend(Class<? extends CommandInterceptor> interceptorClass) {
        ArrayList<CommandInterceptor> result = new ArrayList<CommandInterceptor>();
        for (CommandInterceptor interceptor : this.asList()) {
            boolean isSubclass = interceptorClass.isAssignableFrom(interceptor.getClass());
            if (!isSubclass) continue;
            result.add(interceptor);
        }
        return result;
    }

    public List<CommandInterceptor> getInterceptorsWithClassName(String fqName) {
        ArrayList<CommandInterceptor> result = new ArrayList<CommandInterceptor>(2);
        for (CommandInterceptor iterator = this.firstInChain; iterator != null; iterator = iterator.getNext()) {
            if (!iterator.getClass().getName().equals(fqName)) continue;
            result.add(iterator);
        }
        return result;
    }

    public String toString() {
        return "InterceptorChain{\n" + CachePrinter.printInterceptorChain(this.firstInChain) + "\n}";
    }

    public boolean containsInstance(CommandInterceptor interceptor) {
        for (CommandInterceptor it = this.firstInChain; it != null; it = it.getNext()) {
            if (it != interceptor) continue;
            return true;
        }
        return false;
    }
}

