/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.statetransfer;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InternalNode;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.CacheLoaderManager;
import org.jboss.cache.marshall.NodeData;
import org.jboss.cache.marshall.NodeDataExceptionMarker;
import org.jboss.cache.marshall.NodeDataMarker;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.jboss.cache.statetransfer.StateTransferIntegrator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultStateTransferIntegrator
implements StateTransferIntegrator {
    private static final Log log = LogFactory.getLog(DefaultStateTransferIntegrator.class);
    private static final boolean trace = log.isTraceEnabled();
    private CacheSPI<?, ?> cache;
    private Set<Fqn> internalFqns;
    private Configuration cfg;
    private boolean needToPersistState;

    @Inject
    public void inject(CacheSPI<?, ?> cache, Configuration cfg) {
        this.cache = cache;
        this.cfg = cfg;
    }

    @Start(priority=14)
    public void start() {
        this.internalFqns = this.cache.getInternalFqns();
        this.needToPersistState = this.cfg.getCacheLoaderConfig() != null && !this.cfg.getCacheLoaderConfig().isFetchPersistentState() && !this.cfg.getCacheLoaderConfig().isShared();
    }

    @Override
    public void integrateState(ObjectInputStream ois, Object target, Fqn targetRoot, boolean integratePersistentState) throws Exception {
        short version = (Short)this.cache.getMarshaller().objectFromObjectStream(ois);
        log.info((Object)("Using version " + version));
        this.integrateTransientState(ois, (InternalNode)target);
        if (trace) {
            log.trace((Object)"Reading marker for nonexistent associated state");
        }
        this.cache.getMarshaller().objectFromObjectStream(ois);
        if (integratePersistentState) {
            this.integratePersistentState(ois, targetRoot);
        }
        this.verifyMarker(this.cache.getMarshaller().objectFromObjectStream(ois));
    }

    private void verifyMarker(Object object) {
        if (object instanceof NodeDataExceptionMarker) {
            NodeDataExceptionMarker e = (NodeDataExceptionMarker)object;
            throw new CacheException("Error in state transfer stream", e.getCause());
        }
        if (!(object instanceof NodeDataMarker)) {
            throw new CacheException("Invalid object unmarshalled");
        }
    }

    protected void integrateTransientState(ObjectInputStream in, InternalNode target) throws Exception {
        boolean transientSet = false;
        try {
            try {
                if (trace) {
                    log.trace((Object)("integrating transient state for " + target));
                }
                this.integrateTransientState(target.getFqn(), in);
                transientSet = true;
                if (trace) {
                    log.trace((Object)"transient state successfully integrated");
                }
                this.notifyAllNodesCreated(this.cache.getInvocationContext(), target);
            }
            catch (CacheException ce) {
                throw ce;
            }
            catch (Exception e) {
                throw new CacheException(e);
            }
            Object var6_4 = null;
            if (!transientSet) {
                target.clear();
                target.removeChildren();
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (!transientSet) {
                target.clear();
                target.removeChildren();
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void integratePersistentState(ObjectInputStream in, Fqn targetFqn) throws Exception {
        block10: {
            CacheLoader loader;
            CacheLoaderManager loaderManager = this.cache.getCacheLoaderManager();
            CacheLoader cacheLoader = loader = loaderManager == null ? null : loaderManager.getCacheLoader();
            if (loader == null) {
                if (!trace) return;
                log.trace((Object)"cache loader is null, will not attempt to integrate persistent state");
                return;
            }
            if (trace) {
                log.trace((Object)("integrating persistent state using " + loader.getClass().getName()));
            }
            boolean persistentSet = false;
            try {
                try {
                    if (targetFqn.isRoot()) {
                        loader.storeEntireState(in);
                    } else {
                        loader.storeState(targetFqn, in);
                    }
                    persistentSet = true;
                }
                catch (ClassCastException cce) {
                    log.error((Object)"Failed integrating persistent state. One of cacheloaders is not adhering to state stream format. See JBCACHE-738.");
                    throw cce;
                }
                Object var8_6 = null;
                if (persistentSet) break block10;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                if (!persistentSet) {
                    log.warn((Object)"persistent state integration failed, removing all nodes from loader");
                    loader.remove(targetFqn);
                    throw throwable;
                }
                if (!trace) throw throwable;
                log.trace((Object)"persistent state integrated successfully");
                throw throwable;
            }
            log.warn((Object)"persistent state integration failed, removing all nodes from loader");
            loader.remove(targetFqn);
            return;
        }
        if (!trace) return;
        log.trace((Object)"persistent state integrated successfully");
    }

    private void notifyAllNodesCreated(InvocationContext ctx, InternalNode curr) {
        if (curr == null) {
            return;
        }
        ctx.setOriginLocal(false);
        this.cache.getNotifier().notifyNodeCreated(curr.getFqn(), true, ctx);
        this.cache.getNotifier().notifyNodeCreated(curr.getFqn(), false, ctx);
        if (!curr.getKeys().isEmpty()) {
            this.cache.getNotifier().notifyNodeModified(curr.getFqn(), true, NodeModifiedEvent.ModificationType.PUT_MAP, Collections.emptyMap(), ctx);
            this.cache.getNotifier().notifyNodeModified(curr.getFqn(), false, NodeModifiedEvent.ModificationType.PUT_MAP, curr.getData(), ctx);
        }
        ctx.setOriginLocal(true);
        Set children = curr.getChildren();
        for (InternalNode n : children) {
            this.notifyAllNodesCreated(ctx, n);
        }
    }

    private void prepareContextOptions() {
        this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        this.cache.getInvocationContext().getOptionOverrides().setSkipCacheStatusCheck(true);
        this.cache.getInvocationContext().getOptionOverrides().setSuppressPersistence(!this.needToPersistState);
    }

    private void integrateTransientState(Fqn target, ObjectInputStream in) throws Exception {
        NodeData nd;
        Iterator<NodeData> nodeDataIterator;
        this.prepareContextOptions();
        NodeSPI<?, ?> targetNode = this.cache.getNode(target);
        for (Object childname : targetNode.getChildrenNames()) {
            this.prepareContextOptions();
            targetNode.removeChild(childname);
        }
        targetNode.setDataLoaded(false);
        targetNode.setChildrenLoaded(false);
        List<NodeData> list = this.readNodesAsList(in);
        if (list != null && (nodeDataIterator = list.iterator()).hasNext() && (nd = nodeDataIterator.next()) != null && !nd.isMarker()) {
            this.prepareContextOptions();
            this.cache.clearData(target);
            this.prepareContextOptions();
            this.cache.put(target, nd.getAttributes());
            Fqn tferFqn = nd.getFqn();
            boolean move = target.isChildOrEquals(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN) && !tferFqn.isChildOrEquals(target);
            int offset = move ? target.size() - tferFqn.size() : 0;
            this.integrateStateTransferChildren(target, offset, nodeDataIterator);
            this.integrateRetainedNodes(target);
        }
    }

    private List<NodeData> readNodesAsList(ObjectInputStream in) throws Exception {
        Object obj = this.cache.getMarshaller().objectFromObjectStream(in);
        if (obj instanceof NodeDataExceptionMarker) {
            Throwable cause = ((NodeDataExceptionMarker)obj).getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new CacheException(cause);
        }
        if (obj instanceof NodeDataMarker) {
            return null;
        }
        return (List)obj;
    }

    private NodeData integrateStateTransferChildren(Fqn parentFqn, int offset, Iterator<NodeData> nodeDataIterator) throws IOException, ClassNotFoundException {
        NodeData nd;
        int parentLevel = parentFqn.size();
        int targetLevel = parentLevel + 1;
        NodeData nodeData = nd = nodeDataIterator.hasNext() ? nodeDataIterator.next() : null;
        while (nd != null && !nd.isMarker()) {
            int size;
            Fqn fqn = nd.getFqn();
            if (offset > 0) {
                fqn = Fqn.fromRelativeFqn(parentFqn.getAncestor(offset), fqn);
            }
            if ((size = fqn.size()) <= parentLevel) {
                return nd;
            }
            if (size > targetLevel) {
                throw new IllegalStateException("NodeData " + fqn + " is not a direct child of " + parentFqn);
            }
            Map attrs = nd.getAttributes();
            this.prepareContextOptions();
            this.cache.clearData(fqn);
            this.prepareContextOptions();
            this.cache.put(fqn, attrs);
            this.cache.getNode(fqn).setDataLoaded(false);
            this.cache.getNode(fqn).setChildrenLoaded(false);
            nd = this.integrateStateTransferChildren(fqn, offset, nodeDataIterator);
        }
        if (nd != null && nd.isExceptionMarker()) {
            NodeDataExceptionMarker ndem = (NodeDataExceptionMarker)nd;
            throw new CacheException("State provider node " + ndem.getCacheNodeIdentity() + " threw exception during loadState", ndem.getCause());
        }
        return null;
    }

    private Set<Fqn> retainInternalNodes(Fqn target) {
        HashSet<Fqn> result = new HashSet<Fqn>();
        for (Fqn internalFqn : this.internalFqns) {
            if (!internalFqn.isChildOf(target)) continue;
            this.prepareContextOptions();
            Node node = this.getInternalNode(this.cache.getNode(target), internalFqn);
            if (node == null) continue;
            result.add(node.getFqn());
        }
        return result;
    }

    private Node getInternalNode(Node parentNode, Fqn internalFqn) {
        Fqn parentFqn = parentNode.getFqn();
        Object name = internalFqn.get(parentFqn.size());
        this.prepareContextOptions();
        Node result = parentNode.getChild(name);
        if (result != null && internalFqn.size() < result.getFqn().size()) {
            result = this.getInternalNode(result, internalFqn);
        }
        return result;
    }

    private void integrateRetainedNodes(Fqn target) {
        Set<Fqn> retainedNodes = this.retainInternalNodes(target);
        for (Fqn retained : retainedNodes) {
            if (!retained.isChildOf(target)) continue;
            this.integrateRetainedNode(target, retained);
        }
    }

    private void integrateRetainedNode(Fqn ancFqn, Fqn descFqn) {
        this.prepareContextOptions();
        InternalNode ancestor = this.cache.getNode(ancFqn).getDelegationTarget();
        Object name = descFqn.get(ancFqn.size());
        InternalNode child = ancestor.getChild(name);
        if (ancFqn.size() == descFqn.size() + 1) {
            if (child == null) {
                this.prepareContextOptions();
                InternalNode descendant = this.cache.getNode(descFqn).getDelegationTarget();
                this.prepareContextOptions();
                ancestor.addChild(name, descendant);
            } else {
                log.warn((Object)("Received unexpected internal node " + descFqn + " in transferred state"));
            }
        } else {
            if (child == null) {
                throw new NullPointerException("Child is null");
            }
            this.integrateRetainedNode(child.getFqn(), descFqn);
        }
    }
}

