/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.demo;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.demo.DataTreeRefresher;
import org.jboss.cache.notifications.annotation.BuddyGroupChanged;
import org.jboss.cache.notifications.annotation.NodeCreated;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.annotation.NodeMoved;
import org.jboss.cache.notifications.annotation.NodeRemoved;
import org.jboss.cache.notifications.annotation.ViewChanged;
import org.jboss.cache.notifications.event.BuddyGroupChangedEvent;
import org.jboss.cache.notifications.event.NodeCreatedEvent;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.jboss.cache.notifications.event.NodeMovedEvent;
import org.jboss.cache.notifications.event.NodeRemovedEvent;
import org.jboss.cache.notifications.event.ViewChangedEvent;
import org.jboss.cache.util.CachePrinter;
import org.jgroups.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossCacheDemo {
    private static Log log = LogFactory.getLog(JBossCacheDemo.class);
    private static JFrame frame;
    private JTabbedPane mainPane;
    private JPanel panel1;
    private JLabel cacheStatus;
    private JPanel dataGeneratorTab;
    private JPanel statisticsTab;
    private JPanel clusterViewTab;
    private JPanel dataViewTab;
    private JPanel controlPanelTab;
    private JTree dataTree;
    private JTable clusterTable;
    private JButton actionButton;
    private JLabel configFileName;
    private JProgressBar cacheStatusProgressBar;
    private JTextField fqnTextField;
    private JTextField keyTextField;
    private JTextField valueTextField;
    private JRadioButton createNodeRadioButton;
    private JRadioButton removeNodeRadioButton;
    private JRadioButton addKeyRadioButton;
    private JRadioButton removeKeyRadioButton;
    private JButton goButton;
    private JTable nodeDataTable;
    private JScrollPane nodeDataScrollPane;
    private JButton randomGeneratorButton;
    private JTextField maxNodesTextField;
    private JTextField maxDepthTextField;
    private JTextField numberOfKeysPerTextField;
    private JButton cacheClearButton;
    private JButton updateStatsButton;
    private JLabel statsNumberOfNodes;
    private JLabel statsNumberOfKeys;
    private JLabel statsSizeOfCachedData;
    private JLabel statsLastUpdated;
    private JTextArea configFileContents;
    private JRadioButton getNodeRadioButton;
    private JScrollPane treeScrollPane;
    private JPanel debugTab;
    private JButton cacheDetailsButton;
    private JButton cacheLockInfoButton;
    private JTextArea debugTextArea;
    private String cacheConfigFile;
    private Cache<String, String> cache;
    private String startCacheButtonLabel;
    private String stopCacheButtonLabel;
    private String statusStarting;
    private String statusStarted;
    private String statusStopping;
    private String statusStopped;
    private ExecutorService asyncExecutor;
    private BlockingQueue<Runnable> asyncTaskQueue;
    private ClusterTableModel clusterDataModel;
    private NodeDataTableModel nodeDataTableModel;
    private DataTreeRefresher treeRefresher;
    private Random r;
    private boolean isUsingBuddyReplication;

    public static void main(String[] args) {
        String cfgFileName = "demo-cache-config.xml";
        if (args.length == 1 && args[0] != null && args[0].toLowerCase().endsWith(".xml")) {
            cfgFileName = args[0];
        }
        frame = new JFrame("JBoss Cache GUI Demo (STOPPED)");
        frame.setContentPane(new JBossCacheDemo((String)cfgFileName).panel1);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
        frame.setResizable(true);
    }

    public JBossCacheDemo(String cfgFileName) {
        this.$$$setupUI$$$();
        this.startCacheButtonLabel = "Start Cache";
        this.stopCacheButtonLabel = "Stop Cache";
        this.statusStarting = "Starting Cache ... ";
        this.statusStarted = "Cache Running.";
        this.statusStopping = "Stopping Cache ...";
        this.statusStopped = "Cache Stopped.";
        this.r = new Random();
        this.asyncExecutor = Executors.newFixedThreadPool(1);
        this.asyncTaskQueue = ((ThreadPoolExecutor)this.asyncExecutor).getQueue();
        this.cacheConfigFile = cfgFileName;
        this.cacheStatusProgressBar.setVisible(false);
        this.cacheStatusProgressBar.setEnabled(false);
        this.configFileName.setText(this.cacheConfigFile);
        this.actionButton.setText(this.startCacheButtonLabel);
        this.cacheStatus.setText(this.statusStopped);
        this.clusterDataModel = new ClusterTableModel();
        this.clusterTable.setModel(this.clusterDataModel);
        this.nodeDataTableModel = new NodeDataTableModel();
        this.nodeDataTable.setModel(this.nodeDataTableModel);
        this.actionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (JBossCacheDemo.this.actionButton.getText().equals(JBossCacheDemo.this.startCacheButtonLabel)) {
                    JBossCacheDemo.this.startCache();
                } else if (JBossCacheDemo.this.actionButton.getText().equals(JBossCacheDemo.this.stopCacheButtonLabel)) {
                    JBossCacheDemo.this.stopCache();
                }
            }
        });
        this.goButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JBossCacheDemo.this.processAction(JBossCacheDemo.this.goButton, true);
                JBossCacheDemo.this.asyncExecutor.execute(new Runnable(){

                    public void run() {
                        if (JBossCacheDemo.this.createNodeRadioButton.isSelected()) {
                            JBossCacheDemo.this.cache.put(JBossCacheDemo.this.fqnTextField.getText(), (Object)JBossCacheDemo.this.keyTextField.getText(), (Object)JBossCacheDemo.this.valueTextField.getText());
                        } else if (JBossCacheDemo.this.removeNodeRadioButton.isSelected()) {
                            JBossCacheDemo.this.cache.removeNode(JBossCacheDemo.this.fqnTextField.getText());
                        } else if (JBossCacheDemo.this.addKeyRadioButton.isSelected()) {
                            JBossCacheDemo.this.cache.put(JBossCacheDemo.this.fqnTextField.getText(), (Object)JBossCacheDemo.this.keyTextField.getText(), (Object)JBossCacheDemo.this.valueTextField.getText());
                        } else if (JBossCacheDemo.this.removeKeyRadioButton.isSelected()) {
                            JBossCacheDemo.this.cache.remove(JBossCacheDemo.this.fqnTextField.getText(), (Object)JBossCacheDemo.this.keyTextField.getText());
                        } else if (JBossCacheDemo.this.getNodeRadioButton.isSelected()) {
                            if (JBossCacheDemo.this.isUsingBuddyReplication) {
                                JBossCacheDemo.this.cache.getInvocationContext().getOptionOverrides().setForceDataGravitation(true);
                            }
                            JBossCacheDemo.this.cache.getNode(JBossCacheDemo.this.fqnTextField.getText());
                        }
                        JBossCacheDemo.this.treeRefresher.repaint();
                        JBossCacheDemo.this.dataViewTab.repaint();
                        JBossCacheDemo.this.processAction(JBossCacheDemo.this.goButton, false);
                        JBossCacheDemo.this.mainPane.setSelectedIndex(1);
                    }
                });
            }
        });
        this.removeNodeRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JBossCacheDemo.this.fqnTextField.setEnabled(true);
                JBossCacheDemo.this.keyTextField.setEnabled(false);
                JBossCacheDemo.this.valueTextField.setEnabled(false);
            }
        });
        this.removeKeyRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JBossCacheDemo.this.fqnTextField.setEnabled(true);
                JBossCacheDemo.this.keyTextField.setEnabled(true);
                JBossCacheDemo.this.valueTextField.setEnabled(false);
            }
        });
        this.createNodeRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JBossCacheDemo.this.fqnTextField.setEnabled(true);
                JBossCacheDemo.this.keyTextField.setEnabled(true);
                JBossCacheDemo.this.valueTextField.setEnabled(true);
            }
        });
        this.addKeyRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JBossCacheDemo.this.fqnTextField.setEnabled(true);
                JBossCacheDemo.this.keyTextField.setEnabled(true);
                JBossCacheDemo.this.valueTextField.setEnabled(true);
            }
        });
        this.getNodeRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JBossCacheDemo.this.fqnTextField.setEnabled(true);
                JBossCacheDemo.this.keyTextField.setEnabled(false);
                JBossCacheDemo.this.valueTextField.setEnabled(false);
            }
        });
        this.dataTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = e.getPath();
                DataTreeRefresher.FqnTreeNode node = (DataTreeRefresher.FqnTreeNode)path.getLastPathComponent();
                Fqn f = node.getFqn();
                if (!f.equals((Object)JBossCacheDemo.this.nodeDataTableModel.getCurrentFqn())) {
                    JBossCacheDemo.this.nodeDataTableModel.setCurrentFqn(f);
                    Node n = JBossCacheDemo.this.cache.getNode(f);
                    if (n != null) {
                        JBossCacheDemo.this.nodeDataTableModel.setData(n.getData());
                    }
                }
            }
        });
        this.randomGeneratorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JBossCacheDemo.this.processAction(JBossCacheDemo.this.randomGeneratorButton, true);
                JBossCacheDemo.this.asyncExecutor.execute(new Runnable(){

                    public void run() {
                        int depth = 1;
                        try {
                            depth = Integer.parseInt(JBossCacheDemo.this.maxDepthTextField.getText());
                        }
                        catch (NumberFormatException nfe) {
                            log.warn((Object)"Entered a non-integer for depth.  Using 1.", (Throwable)nfe);
                        }
                        int maxNodes = 1;
                        try {
                            maxNodes = Integer.parseInt(JBossCacheDemo.this.maxNodesTextField.getText());
                        }
                        catch (NumberFormatException nfe) {
                            log.warn((Object)"Entered a non-integer for max nodes.  Using 1.", (Throwable)nfe);
                        }
                        int attribsPerNode = 1;
                        try {
                            attribsPerNode = Integer.parseInt(JBossCacheDemo.this.numberOfKeysPerTextField.getText());
                        }
                        catch (NumberFormatException nfe) {
                            log.warn((Object)"Entered a non-integer for keys per node.  Using 1.", (Throwable)nfe);
                        }
                        HashSet<Fqn> fqns = new HashSet<Fqn>();
                        for (int i = 0; i < maxNodes; ++i) {
                            Fqn fqn = this.createRandomFqn(depth);
                            while (fqns.contains(fqn)) {
                                fqn = this.createRandomFqn(depth);
                            }
                            fqns.add(fqn);
                        }
                        for (Fqn f : fqns) {
                            HashMap<String, String> m = new HashMap<String, String>();
                            for (int i = 0; i < attribsPerNode; ++i) {
                                m.put(this.randomString(), this.randomString());
                            }
                            JBossCacheDemo.this.cache.put(f, m);
                        }
                        JBossCacheDemo.this.processAction(JBossCacheDemo.this.randomGeneratorButton, false);
                        JBossCacheDemo.this.mainPane.setSelectedIndex(1);
                    }
                });
            }

            private Fqn createRandomFqn(int depth) {
                String s = "/";
                for (int i = 0; i < JBossCacheDemo.this.r.nextInt(depth); ++i) {
                    s = s + this.randomString() + "/";
                }
                return Fqn.fromString((String)s);
            }

            private String randomString() {
                return Integer.toHexString(JBossCacheDemo.this.r.nextInt(Integer.MAX_VALUE)).toUpperCase();
            }
        });
        this.cacheClearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JBossCacheDemo.this.processAction(JBossCacheDemo.this.cacheClearButton, true);
                JBossCacheDemo.this.asyncExecutor.execute(new Runnable(){

                    public void run() {
                        JBossCacheDemo.this.cache.removeNode(Fqn.ROOT);
                        JBossCacheDemo.this.cache.getRoot().clearData();
                        JBossCacheDemo.this.processAction(JBossCacheDemo.this.cacheClearButton, false);
                        JBossCacheDemo.this.mainPane.setSelectedIndex(1);
                    }
                });
            }
        });
        this.updateStatsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JBossCacheDemo.this.processAction(JBossCacheDemo.this.updateStatsButton, true);
                JBossCacheDemo.this.asyncExecutor.execute(new Runnable(){

                    public void run() {
                        JBossCacheDemo.this.updateStats();
                        JBossCacheDemo.this.processAction(JBossCacheDemo.this.updateStatsButton, false);
                    }
                });
            }
        });
        this.cacheDetailsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (JBossCacheDemo.this.cache != null) {
                    JBossCacheDemo.this.debugTextArea.setText(CachePrinter.printCacheDetails((Cache)JBossCacheDemo.this.cache));
                }
            }
        });
        this.cacheLockInfoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (JBossCacheDemo.this.cache != null) {
                    JBossCacheDemo.this.debugTextArea.setText(CachePrinter.printCacheLockingInfo((Cache)JBossCacheDemo.this.cache));
                }
            }
        });
    }

    private void updateStats() {
        int numNodes = ((CacheSPI)this.cache).getNumberOfNodes();
        this.statsNumberOfNodes.setText(numNodes + " nodes");
        HashMap<String, Long> values = new HashMap<String, Long>();
        values.put("NumKeys", 0L);
        values.put("Size", 0L);
        this.processRecursively((Node<String, String>)this.cache.getRoot(), values);
        this.statsNumberOfKeys.setText(values.get("NumKeys") + " keys");
        NumberFormat format = NumberFormat.getIntegerInstance();
        this.statsSizeOfCachedData.setText(format.format(values.get("Size")) + " bytes");
        this.statsLastUpdated.setText(new Date().toString());
    }

    private void processRecursively(Node<String, String> node, Map<String, Long> values) {
        for (Node child : node.getChildren()) {
            this.processRecursively((Node<String, String>)child, values);
        }
        Map data = node.getData();
        values.put("NumKeys", values.get("NumKeys") + (long)data.size());
        values.put("Size", values.get("Size") + (long)this.calculateSize(data));
    }

    private int calculateSize(Map<String, String> data) {
        int size = 0;
        for (String key : data.keySet()) {
            size += key.length();
            size += data.get(key).length();
        }
        return size;
    }

    private void moveCacheToState(CacheStatus state) {
        switch (state) {
            case STARTING: {
                this.cacheStatus.setText(this.statusStarting);
                this.processAction(this.actionButton, true);
                break;
            }
            case STARTED: {
                this.setCacheTabsStatus(true);
                this.actionButton.setText(this.stopCacheButtonLabel);
                this.processAction(this.actionButton, false);
                this.cacheStatus.setText(this.statusStarted);
                this.updateTitleBar();
                break;
            }
            case STOPPING: {
                this.cacheStatus.setText(this.statusStopping);
                this.processAction(this.actionButton, true);
                break;
            }
            case STOPPED: {
                this.setCacheTabsStatus(false);
                this.actionButton.setText(this.startCacheButtonLabel);
                this.processAction(this.actionButton, false);
                this.cacheStatus.setText(this.statusStopped);
                this.updateTitleBar();
            }
        }
        this.controlPanelTab.repaint();
    }

    private void processAction(JButton button, boolean start) {
        button.setEnabled(!start);
        this.cacheStatusProgressBar.setVisible(start);
        this.cacheStatusProgressBar.setEnabled(start);
    }

    private String readContents(InputStream is) throws IOException {
        String s;
        BufferedReader r = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        while ((s = r.readLine()) != null) {
            sb.append(s);
            sb.append("\n");
        }
        return sb.toString();
    }

    private void startCache() {
        this.moveCacheToState(CacheStatus.STARTING);
        this.asyncExecutor.execute(new Runnable(){

            public void run() {
                if (JBossCacheDemo.this.cache == null) {
                    URL resource = this.getClass().getClassLoader().getResource(JBossCacheDemo.this.cacheConfigFile);
                    if (resource != null) {
                        JBossCacheDemo.this.configFileName.setText(resource.toString());
                    } else {
                        JBossCacheDemo.this.configFileName.setText(JBossCacheDemo.this.cacheConfigFile);
                    }
                    JBossCacheDemo.this.configFileName.repaint();
                    try {
                        JBossCacheDemo.this.configFileContents.setText(JBossCacheDemo.this.readContents(resource == null ? new FileInputStream(JBossCacheDemo.this.cacheConfigFile) : resource.openStream()));
                        JBossCacheDemo.this.configFileContents.setEditable(false);
                    }
                    catch (Exception e) {
                        log.warn((Object)"Unable to open config file for display", (Throwable)e);
                    }
                    JBossCacheDemo.this.configFileContents.repaint();
                    JBossCacheDemo.this.cache = new DefaultCacheFactory().createCache(JBossCacheDemo.this.cacheConfigFile);
                    JBossCacheDemo.this.isUsingBuddyReplication = JBossCacheDemo.this.cache.getConfiguration().getBuddyReplicationConfig() != null && JBossCacheDemo.this.cache.getConfiguration().getBuddyReplicationConfig().isEnabled();
                } else {
                    JBossCacheDemo.this.cache.start();
                }
                JBossCacheDemo.this.updateClusterTable(JBossCacheDemo.this.cache.getMembers());
                JBossCacheDemo.this.treeRefresher = new DataTreeRefresher(JBossCacheDemo.this.dataTree, (Cache<String, String>)JBossCacheDemo.this.cache, JBossCacheDemo.this.nodeDataTableModel);
                JBossCacheDemo.this.cache.addCacheListener((Object)new CacheListener());
                JBossCacheDemo.this.moveCacheToState(CacheStatus.STARTED);
            }
        });
    }

    private void stopCache() {
        this.moveCacheToState(CacheStatus.STOPPING);
        this.asyncExecutor.execute(new Runnable(){

            public void run() {
                if (JBossCacheDemo.this.cache != null) {
                    JBossCacheDemo.this.cache.stop();
                }
                JBossCacheDemo.this.moveCacheToState(CacheStatus.STOPPED);
            }
        });
    }

    private void setCacheTabsStatus(boolean enabled) {
        int numTabs = this.mainPane.getTabCount();
        for (int i = 1; i < numTabs; ++i) {
            this.mainPane.setEnabledAt(i, enabled);
        }
        this.panel1.repaint();
    }

    private void updateClusterTable(List<Address> members) {
        log.debug((Object)("Updating cluster table with new member list " + members));
        this.clusterDataModel.setMembers(members);
        this.updateTitleBar();
    }

    private void updateTitleBar() {
        String title = "JBoss Cache GUI Demo";
        title = this.cache != null && this.cache.getCacheStatus() == CacheStatus.STARTED ? title + " (STARTED) " + this.cache.getLocalAddress() + " Cluster size: " + this.cache.getMembers().size() : title + " (STOPPED)";
        frame.setTitle(title);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JProgressBar jProgressBar;
        JLabel jLabel;
        JTextArea jTextArea;
        JButton jButton;
        JButton jButton2;
        JPanel jPanel;
        JRadioButton jRadioButton;
        JButton jButton3;
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JButton jButton4;
        JTextField jTextField4;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JButton jButton5;
        JRadioButton jRadioButton4;
        JRadioButton jRadioButton5;
        JTextField jTextField5;
        JTextField jTextField6;
        JPanel jPanel2;
        JLabel jLabel2;
        JButton jButton6;
        JLabel jLabel3;
        JLabel jLabel4;
        JLabel jLabel5;
        JPanel jPanel3;
        JTable jTable;
        JPanel jPanel4;
        JTable jTable2;
        JScrollPane jScrollPane;
        JTree jTree;
        JScrollPane jScrollPane2;
        JPanel jPanel5;
        JTextArea jTextArea2;
        JLabel jLabel6;
        JButton jButton7;
        JPanel jPanel6;
        JTabbedPane jTabbedPane;
        JPanel jPanel7;
        this.panel1 = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new FormLayout("fill:800px:grow,left:4dlu:noGrow,fill:100px:grow", "center:max(d;4px):noGrow,top:3dlu:noGrow,center:600px:grow,top:3dlu:noGrow,center:max(d;4px):noGrow"));
        Font font = jPanel7.getFont();
        jPanel7.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(-16750951)), "JBoss Cache GUI Demo Application", 0, 0, new Font(font.getName(), 3, 14), new Color(-16750951)));
        this.mainPane = jTabbedPane = new JTabbedPane();
        jPanel7.add((Component)jTabbedPane, new CellConstraints(1, 3, 3, 1, CellConstraints.DEFAULT, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        this.controlPanelTab = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new FormLayout("fill:d:noGrow,left:4dlu:noGrow,fill:max(d;4px):noGrow,left:4dlu:noGrow,fill:d:grow", "center:m:noGrow,top:3dlu:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:d:grow"));
        jPanel6.setToolTipText("");
        jTabbedPane.addTab("Control panel", null, jPanel6, "This tab contains cache controls and general information about the cache configuration.");
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("Command");
        jPanel6.add((Component)jLabel7, new CellConstraints(1, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.TOP, new Insets(0, 0, 0, 0)));
        this.actionButton = jButton7 = new JButton();
        jButton7.setText("Button");
        jPanel6.add((Component)jButton7, new CellConstraints(3, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.TOP, new Insets(0, 0, 0, 0)));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new CellConstraints(1, 5, 1, 1, CellConstraints.DEFAULT, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        Spacer spacer2 = new Spacer();
        jPanel6.add((Component)spacer2, new CellConstraints(5, 1, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("Cache configuration file");
        jPanel6.add((Component)jLabel8, new CellConstraints(1, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.TOP, new Insets(0, 0, 0, 0)));
        this.configFileName = jLabel6 = new JLabel();
        jLabel6.setText(" ");
        Font font2 = jLabel6.getFont();
        jLabel6.setFont(new Font(font2.getName(), 3, font2.getSize()));
        jPanel6.add((Component)jLabel6, new CellConstraints(3, 3, 3, 1, CellConstraints.DEFAULT, CellConstraints.TOP, new Insets(0, 0, 0, 0)));
        JScrollPane jScrollPane3 = new JScrollPane();
        jPanel6.add((Component)jScrollPane3, new CellConstraints(3, 5, 3, 1, CellConstraints.FILL, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        this.configFileContents = jTextArea2 = new JTextArea();
        Font font3 = jTextArea2.getFont();
        jTextArea2.setFont(new Font("Courier New", font3.getStyle(), 10));
        ((Component)jTextArea2).setBackground(new Color(-3355444));
        jScrollPane3.setViewportView(jTextArea2);
        this.dataViewTab = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new FormLayout("left:340px:grow,left:4dlu:noGrow,fill:p:grow", "center:d:grow"));
        ((Component)jPanel5).setEnabled(true);
        jPanel5.setToolTipText("");
        jTabbedPane.addTab("Data view", null, jPanel5, "This tab contains a view of all the data in the cache.");
        jTabbedPane.setEnabledAt(1, false);
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setDividerLocation(600);
        jPanel5.add((Component)jSplitPane, new CellConstraints(1, 1, 3, 1, CellConstraints.FILL, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        this.treeScrollPane = jScrollPane2 = new JScrollPane();
        jSplitPane.setLeftComponent(jScrollPane2);
        this.dataTree = jTree = new JTree();
        jTree.setShowsRootHandles(true);
        jTree.setToolTipText("Tree view of the cache");
        jTree.setEditable(false);
        ((Component)jTree).setBackground(new Color(-1));
        jScrollPane2.setViewportView(jTree);
        this.nodeDataScrollPane = jScrollPane = new JScrollPane();
        jSplitPane.setRightComponent(jScrollPane);
        this.nodeDataTable = jTable2 = new JTable();
        jTable2.setToolTipText("Data in currently selected node");
        jTable2.setGridColor(new Color(-16777216));
        ((Component)jTable2).setBackground(new Color(-992313));
        jTable2.setIntercellSpacing(new Dimension(3, 3));
        jScrollPane.setViewportView(jTable2);
        this.clusterViewTab = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new FormLayout("fill:d:grow", "center:d:grow"));
        jPanel4.setToolTipText("");
        jTabbedPane.addTab("Cluster view", null, jPanel4, "This tab contains a view of the cluster topology");
        jTabbedPane.setEnabledAt(2, false);
        JScrollPane jScrollPane4 = new JScrollPane();
        ((Component)jScrollPane4).setBackground(new Color(-16737895));
        jScrollPane4.setHorizontalScrollBarPolicy(30);
        jPanel4.add((Component)jScrollPane4, new CellConstraints(1, 1, 1, 1, CellConstraints.FILL, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        this.clusterTable = jTable = new JTable();
        jTable.setGridColor(new Color(-16777216));
        ((Component)jTable).setBackground(new Color(-992313));
        jTable.setShowHorizontalLines(true);
        jTable.setIntercellSpacing(new Dimension(3, 3));
        jTable.setShowVerticalLines(false);
        jScrollPane4.setViewportView(jTable);
        this.statisticsTab = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new FormLayout("fill:d:noGrow,left:4dlu:noGrow,fill:max(d;4px):noGrow", "center:d:noGrow,top:3dlu:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:max(d;4px):noGrow"));
        jPanel3.setToolTipText("");
        jTabbedPane.addTab("Statistics", null, jPanel3, "This tab contains various statistics on the running cache.");
        jTabbedPane.setEnabledAt(3, false);
        JLabel jLabel9 = new JLabel();
        jLabel9.setText("Number of nodes");
        jPanel3.add((Component)jLabel9, new CellConstraints(1, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.statsNumberOfNodes = jLabel5 = new JLabel();
        jLabel5.setText("");
        jPanel3.add((Component)jLabel5, new CellConstraints(3, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JLabel jLabel10 = new JLabel();
        jLabel10.setText("Number of keys");
        jPanel3.add((Component)jLabel10, new CellConstraints(1, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JLabel jLabel11 = new JLabel();
        jLabel11.setText("Size of data cached");
        jPanel3.add((Component)jLabel11, new CellConstraints(1, 5, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.statsNumberOfKeys = jLabel4 = new JLabel();
        jLabel4.setText("");
        jPanel3.add((Component)jLabel4, new CellConstraints(3, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.statsSizeOfCachedData = jLabel3 = new JLabel();
        jLabel3.setText("");
        jPanel3.add((Component)jLabel3, new CellConstraints(3, 5, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.updateStatsButton = jButton6 = new JButton();
        jButton6.setText("Update stats");
        jButton6.setMnemonic('U');
        jButton6.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jButton6, new CellConstraints(3, 9, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JLabel jLabel12 = new JLabel();
        jLabel12.setText("Time last updated");
        jPanel3.add((Component)jLabel12, new CellConstraints(1, 7, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.statsLastUpdated = jLabel2 = new JLabel();
        jLabel2.setText("");
        jPanel3.add((Component)jLabel2, new CellConstraints(3, 7, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.dataGeneratorTab = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new FormLayout("fill:d:noGrow,left:4dlu:noGrow,fill:200px:noGrow,left:4dlu:noGrow,fill:200px:grow", "center:max(d;4px):noGrow,top:3dlu:noGrow,center:d:noGrow,top:3dlu:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:d:grow,top:3dlu:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:d:grow,top:3dlu:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:max(d;4px):noGrow"));
        jPanel2.setToolTipText("");
        jTabbedPane.addTab("Manipulate data", null, jPanel2, "This tab provides you with the ability to add or remove data from the cache.");
        jTabbedPane.setEnabledAt(4, false);
        JLabel jLabel13 = new JLabel();
        jLabel13.setText("Fqn");
        jPanel2.add((Component)jLabel13, new CellConstraints(1, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JLabel jLabel14 = new JLabel();
        jLabel14.setText("Key");
        jPanel2.add((Component)jLabel14, new CellConstraints(1, 5, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JLabel jLabel15 = new JLabel();
        jLabel15.setText("Value");
        jPanel2.add((Component)jLabel15, new CellConstraints(1, 7, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.fqnTextField = jTextField6 = new JTextField();
        jPanel2.add((Component)jTextField6, new CellConstraints(3, 3, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.keyTextField = jTextField5 = new JTextField();
        jPanel2.add((Component)jTextField5, new CellConstraints(3, 5, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.createNodeRadioButton = jRadioButton5 = new JRadioButton();
        jRadioButton5.setSelected(true);
        jRadioButton5.setText("Create Node");
        jRadioButton5.setMnemonic('C');
        jRadioButton5.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jRadioButton5, new CellConstraints(3, 9, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.removeNodeRadioButton = jRadioButton4 = new JRadioButton();
        jRadioButton4.setText("Remove Node");
        jRadioButton4.setMnemonic('R');
        jRadioButton4.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jRadioButton4, new CellConstraints(3, 11, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.goButton = jButton5 = new JButton();
        jButton5.setText("Go");
        jButton5.setMnemonic('G');
        jButton5.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jButton5, new CellConstraints(3, 15, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.addKeyRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("Add Key");
        jRadioButton3.setMnemonic('K');
        jRadioButton3.setDisplayedMnemonicIndex(4);
        jPanel2.add((Component)jRadioButton3, new CellConstraints(5, 9, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.removeKeyRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Remove Key");
        jRadioButton2.setMnemonic('E');
        jRadioButton2.setDisplayedMnemonicIndex(1);
        jPanel2.add((Component)jRadioButton2, new CellConstraints(5, 11, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.valueTextField = jTextField4 = new JTextField();
        jPanel2.add((Component)jTextField4, new CellConstraints(3, 7, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JLabel jLabel16 = new JLabel();
        jLabel16.setText("Single node manipulator");
        Font font4 = jLabel16.getFont();
        jLabel16.setFont(new Font(font4.getName(), 3, font4.getSize()));
        jPanel2.add((Component)jLabel16, new CellConstraints(3, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JLabel jLabel17 = new JLabel();
        jLabel17.setText("Random data generator");
        Font font5 = jLabel17.getFont();
        jLabel17.setFont(new Font(font5.getName(), 3, font5.getSize()));
        jPanel2.add((Component)jLabel17, new CellConstraints(3, 19, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JSeparator jSeparator = new JSeparator();
        jPanel2.add((Component)jSeparator, new CellConstraints(1, 17, 5, 1, CellConstraints.FILL, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        JLabel jLabel18 = new JLabel();
        jLabel18.setText("Max depth");
        jPanel2.add((Component)jLabel18, new CellConstraints(1, 23, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JLabel jLabel19 = new JLabel();
        jLabel19.setText("Max nodes");
        jPanel2.add((Component)jLabel19, new CellConstraints(1, 21, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JLabel jLabel20 = new JLabel();
        jLabel20.setText("Number of keys per node");
        jPanel2.add((Component)jLabel20, new CellConstraints(1, 25, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.randomGeneratorButton = jButton4 = new JButton();
        jButton4.setText("Generate");
        jButton4.setMnemonic('N');
        jButton4.setDisplayedMnemonicIndex(2);
        jPanel2.add((Component)jButton4, new CellConstraints(3, 27, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.maxNodesTextField = jTextField3 = new JTextField();
        jPanel2.add((Component)jTextField3, new CellConstraints(3, 21, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.maxDepthTextField = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new CellConstraints(3, 23, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.numberOfKeysPerTextField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new CellConstraints(3, 25, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JSeparator jSeparator2 = new JSeparator();
        jPanel2.add((Component)jSeparator2, new CellConstraints(1, 29, 5, 1, CellConstraints.FILL, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        this.cacheClearButton = jButton3 = new JButton();
        jButton3.setText("Clear cache");
        jButton3.setMnemonic('L');
        jButton3.setDisplayedMnemonicIndex(1);
        jPanel2.add((Component)jButton3, new CellConstraints(3, 33, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JLabel jLabel21 = new JLabel();
        jLabel21.setText("Clear cache");
        Font font6 = jLabel21.getFont();
        jLabel21.setFont(new Font(font6.getName(), 3, font6.getSize()));
        jPanel2.add((Component)jLabel21, new CellConstraints(3, 31, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.getNodeRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Get Node");
        jRadioButton.setMnemonic('N');
        jRadioButton.setDisplayedMnemonicIndex(4);
        jPanel2.add((Component)jRadioButton, new CellConstraints(3, 13, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.debugTab = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jTabbedPane.addTab("Debug", null, jPanel, null);
        jTabbedPane.setEnabledAt(5, false);
        this.cacheDetailsButton = jButton2 = new JButton();
        jButton2.setText("Print cache details");
        jPanel.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.cacheLockInfoButton = jButton = new JButton();
        jButton.setText("Print cache locking info");
        jPanel.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.debugTextArea = jTextArea = new JTextArea();
        Font font7 = jTextArea.getFont();
        jTextArea.setFont(new Font("Courier New", font7.getStyle(), 10));
        ((Component)jTextArea).setBackground(new Color(-3355444));
        jPanel.add((Component)jTextArea, new GridConstraints(1, 0, 1, 3, 0, 3, 6, 6, null, new Dimension(150, 50), null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.cacheStatus = jLabel = new JLabel();
        jLabel.setVerticalAlignment(3);
        jLabel.setToolTipText("Cache status");
        jLabel.setText("Initialising");
        Font font8 = jLabel.getFont();
        jLabel.setFont(new Font(font8.getName(), 3, font8.getSize()));
        jPanel7.add((Component)jLabel, new CellConstraints(1, 5, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.cacheStatusProgressBar = jProgressBar = new JProgressBar();
        jProgressBar.setIndeterminate(true);
        jProgressBar.setOrientation(0);
        jPanel7.add((Component)jProgressBar, new CellConstraints(3, 5, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        jLabel13.setLabelFor(jTextField6);
        jLabel14.setLabelFor(jTextField5);
        jLabel15.setLabelFor(jTextField4);
        jLabel18.setLabelFor(jTextField2);
        jLabel19.setLabelFor(jTextField3);
        jLabel20.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton5);
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NodeDataTableModel
    extends AbstractTableModel {
        String[] keys = new String[0];
        String[] values = new String[0];
        private Fqn currentFqn;

        public void setData(Map<String, String> data) {
            this.keys = new String[data.size()];
            this.values = new String[data.size()];
            int i = 0;
            Iterator<String> i$ = data.keySet().iterator();
            while (i$.hasNext()) {
                String key;
                this.keys[i] = key = i$.next();
                this.values[i] = data.get(key);
                ++i;
            }
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.keys.length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.keys[rowIndex];
                }
                case 1: {
                    return this.values[rowIndex];
                }
            }
            return "NULL!";
        }

        @Override
        public String getColumnName(int c) {
            if (c == 0) {
                return "Key";
            }
            if (c == 1) {
                return "Value";
            }
            return "NULL!";
        }

        public Fqn getCurrentFqn() {
            return this.currentFqn;
        }

        public void setCurrentFqn(Fqn currentFqn) {
            this.currentFqn = currentFqn;
        }

        public void updateCurrentNode() {
            this.setData(JBossCacheDemo.this.cache.getData(this.currentFqn));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ClusterTableModel
    extends AbstractTableModel {
        List<Address> members = new ArrayList<Address>();
        List<String> memberStates = new ArrayList<String>();

        public void setMembers(List<Address> members) {
            if (this.members != members) {
                this.members.clear();
                this.members.addAll(members);
            }
            List buddies = Collections.emptyList();
            if (JBossCacheDemo.this.isUsingBuddyReplication) {
                buddies = ((CacheSPI)JBossCacheDemo.this.cache).getBuddyManager().getBuddyAddresses();
                log.debug((Object)("Buddy addresses: " + buddies));
            }
            this.memberStates = new ArrayList<String>(members.size());
            for (Address a : members) {
                String extraInfo = "Member";
                if (this.memberStates.isEmpty()) {
                    extraInfo = extraInfo + " (coord)";
                }
                if (a.equals(JBossCacheDemo.this.cache.getLocalAddress())) {
                    extraInfo = extraInfo + " (me)";
                } else if (buddies.contains(a)) {
                    extraInfo = extraInfo + " (buddy)";
                }
                this.memberStates.add(extraInfo);
            }
            this.fireTableDataChanged();
        }

        public void setBuddies() {
            this.setMembers(this.members);
        }

        @Override
        public int getRowCount() {
            return this.members.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.members.get(rowIndex);
                }
                case 1: {
                    return this.memberStates.get(rowIndex);
                }
            }
            return "NULL!";
        }

        @Override
        public String getColumnName(int c) {
            if (c == 0) {
                return "Member Address";
            }
            if (c == 1) {
                return "Member Info";
            }
            return "NULL!";
        }
    }

    @org.jboss.cache.notifications.annotation.CacheListener
    public class CacheListener {
        @ViewChanged
        public void viewChangeEvent(ViewChangedEvent e) {
            JBossCacheDemo.this.updateClusterTable(e.getNewView().getMembers());
        }

        @BuddyGroupChanged
        public void buddyGroupChanged(BuddyGroupChangedEvent e) {
            JBossCacheDemo.this.clusterDataModel.setBuddies();
            JBossCacheDemo.this.treeRefresher.repaint();
        }

        @NodeModified
        public void nodeModified(NodeModifiedEvent e) {
            if (!e.isPre() && JBossCacheDemo.this.nodeDataTableModel.getCurrentFqn() != null && JBossCacheDemo.this.nodeDataTableModel.getCurrentFqn().equals((Object)e.getFqn())) {
                JBossCacheDemo.this.nodeDataTableModel.updateCurrentNode();
            }
        }

        @NodeCreated
        public void nodeCreated(NodeCreatedEvent e) {
            if (!e.isPre()) {
                final Fqn fqn = e.getFqn();
                JBossCacheDemo.this.asyncExecutor.execute(new Runnable(){

                    public void run() {
                        JBossCacheDemo.this.treeRefresher.addNode((Fqn<String>)fqn);
                        if (JBossCacheDemo.this.asyncTaskQueue.isEmpty()) {
                            JBossCacheDemo.this.treeRefresher.repaint();
                        }
                    }
                });
            }
        }

        @NodeMoved
        public void nodeMoved(NodeMovedEvent e) {
            if (!e.isPre()) {
                final Fqn fqn = e.getTargetFqn();
                JBossCacheDemo.this.asyncExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        this.recursivelyAddNode((NodeSPI<String, String>)((CacheSPI)JBossCacheDemo.this.cache).peek(fqn, false));
                        if (JBossCacheDemo.this.asyncTaskQueue.isEmpty()) {
                            JBossCacheDemo.this.treeRefresher.repaint();
                        }
                    }

                    private void recursivelyAddNode(NodeSPI<String, String> n) {
                        JBossCacheDemo.this.treeRefresher.addNode((Fqn<String>)n.getFqn());
                        for (NodeSPI child : n.getChildrenDirect()) {
                            this.recursivelyAddNode((NodeSPI<String, String>)child);
                        }
                    }
                });
            }
        }

        @NodeRemoved
        public void nodeRemoved(NodeRemovedEvent e) {
            if (!e.isPre()) {
                final Fqn fqn = e.getFqn();
                JBossCacheDemo.this.asyncExecutor.execute(new Runnable(){

                    public void run() {
                        JBossCacheDemo.this.treeRefresher.removeNode((Fqn<String>)fqn);
                        if (JBossCacheDemo.this.asyncTaskQueue.isEmpty()) {
                            JBossCacheDemo.this.treeRefresher.repaint();
                        }
                    }
                });
            }
        }
    }
}

