/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.BtreeStats;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseStats;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.VerifyConfig;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.GetMode;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogReadable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LogWritable;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.DBIN;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.DupCountLN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import com.sleepycat.je.txn.ThreadLocker;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DatabaseImpl
implements LogWritable,
LogReadable,
Cloneable {
    private DatabaseId id;
    private Tree tree;
    private EnvironmentImpl envImpl;
    private boolean duplicatesAllowed;
    private boolean transactional;
    private Set referringHandles;
    private boolean isDeleted;
    private TrackedFileSummary[] deletedTrackingInfo;
    private BtreeStats stats;
    private long eofNodeId;
    private Comparator btreeComparator = null;
    private Comparator duplicateComparator = null;
    private int binDeltaPercent;
    private int binMaxDeltas;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DatabaseImpl(String dbName, DatabaseId id, EnvironmentImpl envImpl, DatabaseConfig dbConfig) throws DatabaseException {
        this.id = id;
        this.envImpl = envImpl;
        this.btreeComparator = dbConfig.getBtreeComparator();
        this.duplicateComparator = dbConfig.getDuplicateComparator();
        this.duplicatesAllowed = dbConfig.getSortedDuplicates();
        this.transactional = dbConfig.getTransactional();
        this.isDeleted = false;
        this.tree = new Tree(this);
        this.referringHandles = Collections.synchronizedSet(new HashSet());
        DbConfigManager configMgr = envImpl.getConfigManager();
        this.binDeltaPercent = configMgr.getInt(EnvironmentParams.BIN_DELTA_PERCENT);
        this.binMaxDeltas = configMgr.getInt(EnvironmentParams.BIN_MAX_DELTAS);
        this.eofNodeId = Node.getNextNodeId();
    }

    public DatabaseImpl() throws DatabaseException {
        this.id = new DatabaseId();
        this.envImpl = null;
        this.isDeleted = false;
        this.tree = new Tree();
        this.referringHandles = Collections.synchronizedSet(new HashSet());
        this.eofNodeId = Node.getNextNodeId();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Tree getTree() {
        return this.tree;
    }

    void setTree(Tree tree) {
        this.tree = tree;
    }

    public DatabaseId getId() {
        return this.id;
    }

    void setId(DatabaseId id) {
        this.id = id;
    }

    public long getEofNodeId() {
        return this.eofNodeId;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public boolean getSortedDuplicates() {
        return this.duplicatesAllowed;
    }

    public void setDuplicateComparator(Comparator duplicateComparator) {
        this.duplicateComparator = duplicateComparator;
    }

    public void setBtreeComparator(Comparator btreeComparator) {
        this.btreeComparator = btreeComparator;
    }

    public Comparator getBtreeComparator() {
        return this.btreeComparator;
    }

    public Comparator getDuplicateComparator() {
        return this.duplicateComparator;
    }

    public void setEnvironmentImpl(EnvironmentImpl envImpl) throws DatabaseException {
        this.envImpl = envImpl;
        this.binDeltaPercent = envImpl.getConfigManager().getInt(EnvironmentParams.BIN_DELTA_PERCENT);
        this.binMaxDeltas = envImpl.getConfigManager().getInt(EnvironmentParams.BIN_MAX_DELTAS);
        this.tree.setDatabase(this);
    }

    public EnvironmentImpl getDbEnvironment() {
        return this.envImpl;
    }

    public boolean hasOpenHandles() {
        return this.referringHandles.size() > 0;
    }

    public void addReferringHandle(Database db) {
        this.referringHandles.add(db);
    }

    public void removeReferringHandle(Database db) {
        this.referringHandles.remove(db);
    }

    synchronized int getReferringHandleCount() {
        return this.referringHandles.size();
    }

    public Database findPrimaryDatabase() throws DatabaseException {
        Iterator i = this.referringHandles.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (!(obj instanceof SecondaryDatabase)) continue;
            return ((SecondaryDatabase)obj).getPrimaryDatabase();
        }
        return null;
    }

    public String getName() throws DatabaseException {
        return this.envImpl.getDbMapTree().getDbName(this.id);
    }

    public boolean getIsDeleted() {
        return this.isDeleted;
    }

    public void deleteAndReleaseINs() throws DatabaseException {
        this.isDeleted = true;
        this.envImpl.getInMemoryINs().clearDb(this);
        this.envImpl.getLogManager().countObsoleteNodes(this.deletedTrackingInfo);
        UtilizationProfile profile = this.envImpl.getUtilizationProfile();
        UtilizationTracker tracker = this.envImpl.getUtilizationTracker();
        for (int i = 0; i < this.deletedTrackingInfo.length; ++i) {
            TrackedFileSummary trackedFile = tracker.getTrackedFile(this.deletedTrackingInfo[i].getFileNumber());
            if (trackedFile == null) continue;
            profile.putFileSummary(trackedFile);
        }
        this.deletedTrackingInfo = null;
        this.envImpl.getDbMapTree().deleteMapLN(this.id);
    }

    public void checkIsDeleted(String operation) throws DatabaseException {
        if (this.isDeleted) {
            throw new DatabaseException("Attempt to " + operation + " a deleted database");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int recordObsoleteNodes() throws DatabaseException {
        UtilizationTracker tracker = new UtilizationTracker(this.envImpl);
        ObsoleteINCounter inCounter = new ObsoleteINCounter(tracker);
        ThreadLocker locker = new ThreadLocker(this.envImpl);
        Cursor cursor = null;
        int count = 0;
        CursorImpl impl = null;
        try {
            EnvironmentImpl.incThreadLocalReferenceCount();
            cursor = DbInternal.newCursor(this, locker, null);
            impl = DbInternal.getCursorImpl(cursor);
            this.tree.setTreeStatsAccumulator(inCounter);
            impl.setTreeStatsAccumulator(inCounter);
            DatabaseEntry foundData = new DatabaseEntry();
            DatabaseEntry key = new DatabaseEntry();
            OperationStatus status = DbInternal.position(cursor, key, foundData, LockMode.DIRTY_READ, true);
            while (status == OperationStatus.SUCCESS) {
                ++count;
                impl = DbInternal.getCursorImpl(cursor);
                long lsn = impl.getBIN().getLsn(impl.getIndex());
                tracker.countObsoleteNode(lsn, null, true);
                status = DbInternal.retrieveNext(cursor, key, foundData, LockMode.DIRTY_READ, GetMode.NEXT);
            }
            Object var13_11 = null;
            if (impl != null) {
                impl.setTreeStatsAccumulator(null);
            }
            this.tree.setTreeStatsAccumulator(null);
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            if (impl != null) {
                impl.setTreeStatsAccumulator(null);
            }
            this.tree.setTreeStatsAccumulator(null);
            EnvironmentImpl.decThreadLocalReferenceCount();
            if (cursor != null) {
                cursor.close();
            }
            throw throwable;
        }
        EnvironmentImpl.decThreadLocalReferenceCount();
        if (cursor != null) {
            cursor.close();
        }
        this.deletedTrackingInfo = tracker.getTrackedFiles();
        return count;
    }

    public DatabaseStats stat(StatsConfig config) throws DatabaseException {
        if (!config.getFast()) {
            if (this.tree == null) {
                return new BtreeStats();
            }
            StatsAccumulator statsAcc = new StatsAccumulator(config.getShowProgressStream(), config.getShowProgressInterval());
            this.walkDatabaseTree(statsAcc);
            this.stats = statsAcc.copyToBtreeStats();
        }
        if (this.stats == null) {
            this.stats = new BtreeStats();
        }
        return this.stats;
    }

    public DatabaseStats verify(VerifyConfig config) throws DatabaseException {
        if (this.tree == null) {
            return new BtreeStats();
        }
        PrintStream out = config.getShowProgressStream();
        if (out == null) {
            out = System.err;
        }
        StatsAccumulator statsAcc = new StatsAccumulator(out, config.getShowProgressInterval()){

            void verifyNode(Node node) {
                try {
                    node.verify(null);
                }
                catch (DatabaseException INE) {
                    this.progressStream.println(INE);
                }
            }
        };
        this.walkDatabaseTree(statsAcc);
        return statsAcc.copyToBtreeStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void walkDatabaseTree(TreeWalkerStatsAccumulator statsAcc) throws DatabaseException {
        ThreadLocker locker = new ThreadLocker(this.envImpl);
        Cursor cursor = null;
        CursorImpl impl = null;
        try {
            EnvironmentImpl.incThreadLocalReferenceCount();
            cursor = DbInternal.newCursor(this, locker, null);
            impl = DbInternal.getCursorImpl(cursor);
            this.tree.setTreeStatsAccumulator(statsAcc);
            impl.setTreeStatsAccumulator(statsAcc);
            DatabaseEntry foundData = new DatabaseEntry();
            DatabaseEntry key = new DatabaseEntry();
            OperationStatus status = DbInternal.position(cursor, key, foundData, LockMode.DIRTY_READ, true);
            boolean count = false;
            while (status == OperationStatus.SUCCESS) {
                status = DbInternal.retrieveNext(cursor, key, foundData, LockMode.DIRTY_READ, GetMode.NEXT);
            }
            Object var10_9 = null;
            if (impl != null) {
                impl.setTreeStatsAccumulator(null);
            }
            this.tree.setTreeStatsAccumulator(null);
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (impl != null) {
                impl.setTreeStatsAccumulator(null);
            }
            this.tree.setTreeStatsAccumulator(null);
            EnvironmentImpl.decThreadLocalReferenceCount();
            if (cursor != null) {
                cursor.close();
            }
            throw throwable;
        }
        EnvironmentImpl.decThreadLocalReferenceCount();
        if (cursor != null) {
            cursor.close();
        }
    }

    public void preload(long maxBytes) throws DatabaseException {
        IN next = this.tree.getFirstNode();
        if (next == null) {
            return;
        }
        next.releaseLatch();
        if (maxBytes == 0L) {
            maxBytes = this.envImpl.getMemoryBudget().getTreeBudget();
        }
        while (next != null && (next = this.tree.getNextBin((BIN)next, null)) != null) {
            next.releaseLatch();
            if (this.envImpl.getMemoryBudget().getCacheMemoryUsage() <= maxBytes) continue;
        }
        if (!$assertionsDisabled && Latch.countLatchesHeld() != 0) {
            throw new AssertionError();
        }
    }

    public String dumpString(int nSpaces) {
        StringBuffer sb = new StringBuffer();
        sb.append(TreeUtils.indent(nSpaces));
        sb.append("<database id=\"");
        sb.append(this.id.toString());
        sb.append("\"");
        if (this.btreeComparator != null) {
            sb.append(" btc=\"");
            sb.append(DatabaseImpl.serializeComparator(this.btreeComparator));
            sb.append("\"");
        }
        if (this.duplicateComparator != null) {
            sb.append(" dupc=\"");
            sb.append(DatabaseImpl.serializeComparator(this.duplicateComparator));
            sb.append("\"");
        }
        sb.append("/>");
        return sb.toString();
    }

    public int getLogSize() {
        return this.id.getLogSize() + this.tree.getLogSize() + LogUtils.getBooleanLogSize() + LogUtils.getStringLogSize(DatabaseImpl.serializeComparator(this.btreeComparator)) + LogUtils.getStringLogSize(DatabaseImpl.serializeComparator(this.duplicateComparator));
    }

    public void writeToLog(ByteBuffer logBuffer) {
        this.id.writeToLog(logBuffer);
        this.tree.writeToLog(logBuffer);
        LogUtils.writeBoolean(logBuffer, this.duplicatesAllowed);
        LogUtils.writeString(logBuffer, DatabaseImpl.serializeComparator(this.btreeComparator));
        LogUtils.writeString(logBuffer, DatabaseImpl.serializeComparator(this.duplicateComparator));
    }

    public void readFromLog(ByteBuffer itemBuffer) throws LogException {
        this.id.readFromLog(itemBuffer);
        this.tree.readFromLog(itemBuffer);
        this.duplicatesAllowed = LogUtils.readBoolean(itemBuffer);
        String btreeComparatorName = LogUtils.readString(itemBuffer);
        String duplicateComparatorName = LogUtils.readString(itemBuffer);
        try {
            if (btreeComparatorName.length() != 0) {
                Class<?> btreeComparatorClass = Class.forName(btreeComparatorName);
                this.btreeComparator = DatabaseImpl.instantiateComparator(btreeComparatorClass, "Btree");
            }
            if (duplicateComparatorName.length() != 0) {
                Class<?> duplicateComparatorClass = Class.forName(duplicateComparatorName);
                this.duplicateComparator = DatabaseImpl.instantiateComparator(duplicateComparatorClass, "Duplicate");
            }
        }
        catch (ClassNotFoundException CNFE) {
            throw new LogException("couldn't instantiate class comparator", CNFE);
        }
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<database>");
        this.id.dumpLog(sb, verbose);
        this.tree.dumpLog(sb, verbose);
        sb.append("<dupsort v=\"").append(this.duplicatesAllowed);
        sb.append("\"/>");
        sb.append("<btcf name=\"");
        sb.append(DatabaseImpl.serializeComparator(this.btreeComparator));
        sb.append("\"/>");
        sb.append("<dupcf name=\"");
        sb.append(DatabaseImpl.serializeComparator(this.duplicateComparator));
        sb.append("\"/>");
        sb.append("</database>");
    }

    public boolean logEntryIsTransactional() {
        return false;
    }

    public long getTransactionId() {
        return 0L;
    }

    public static String serializeComparator(Comparator comparator) {
        if (comparator != null) {
            return comparator.getClass().getName();
        }
        return "";
    }

    public static Comparator instantiateComparator(Class comparator, String comparatorType) throws LogException {
        if (comparator == null) {
            return null;
        }
        Object ret = null;
        try {
            return (Comparator)comparator.newInstance();
        }
        catch (InstantiationException IE) {
            throw new LogException("Exception while trying to load " + comparatorType + " Comparator class: " + IE);
        }
        catch (IllegalAccessException IAE) {
            throw new LogException("Exception while trying to load " + comparatorType + " Comparator class: " + IAE);
        }
    }

    public int getBinDeltaPercent() {
        return this.binDeltaPercent;
    }

    public int getBinMaxDeltas() {
        return this.binMaxDeltas;
    }

    static {
        $assertionsDisabled = !DatabaseImpl.class.desiredAssertionStatus();
    }

    static class StatsAccumulator
    implements TreeWalkerStatsAccumulator {
        private Set inNodeIdsSeen = new HashSet();
        private Set binNodeIdsSeen = new HashSet();
        private Set dinNodeIdsSeen = new HashSet();
        private Set dbinNodeIdsSeen = new HashSet();
        private Set dupCountLNsSeen = new HashSet();
        private long[] insSeenByLevel = null;
        private long[] binsSeenByLevel = null;
        private long[] dinsSeenByLevel = null;
        private long[] dbinsSeenByLevel = null;
        private long lnCount = 0L;
        private long deletedLNCount = 0L;
        private int mainTreeMaxDepth = 0;
        private int duplicateTreeMaxDepth = 0;
        PrintStream progressStream;
        int progressInterval;
        private static final int MAX_LEVELS = 100;

        StatsAccumulator(PrintStream progressStream, int progressInterval) {
            this.progressStream = progressStream;
            this.progressInterval = progressInterval;
            this.insSeenByLevel = new long[100];
            this.binsSeenByLevel = new long[100];
            this.dinsSeenByLevel = new long[100];
            this.dbinsSeenByLevel = new long[100];
        }

        void verifyNode(Node node) {
        }

        public void processIN(IN node, Long nid, int level) {
            if (this.inNodeIdsSeen.add(nid)) {
                this.tallyLevel(level, this.insSeenByLevel);
                this.verifyNode(node);
            }
        }

        public void processBIN(BIN node, Long nid, int level) {
            if (this.binNodeIdsSeen.add(nid)) {
                this.tallyLevel(level, this.binsSeenByLevel);
                this.verifyNode(node);
            }
        }

        public void processDIN(DIN node, Long nid, int level) {
            if (this.dinNodeIdsSeen.add(nid)) {
                this.tallyLevel(level, this.dinsSeenByLevel);
                this.verifyNode(node);
            }
        }

        public void processDBIN(DBIN node, Long nid, int level) {
            if (this.dbinNodeIdsSeen.add(nid)) {
                this.tallyLevel(level, this.dbinsSeenByLevel);
                this.verifyNode(node);
            }
        }

        public void processDupCountLN(DupCountLN node, Long nid) {
            this.dupCountLNsSeen.add(nid);
            this.verifyNode(node);
        }

        private void tallyLevel(int levelArg, long[] nodesSeenByLevel) {
            int level = levelArg;
            if (level >= 131072) {
                return;
            }
            if (level >= 65536) {
                if ((level &= 0xFFFEFFFF) > this.mainTreeMaxDepth) {
                    this.mainTreeMaxDepth = level;
                }
            } else if (level > this.duplicateTreeMaxDepth) {
                this.duplicateTreeMaxDepth = level;
            }
            int n = level;
            nodesSeenByLevel[n] = nodesSeenByLevel[n] + 1L;
        }

        public void incrementLNCount() {
            ++this.lnCount;
            if (this.progressInterval != 0 && this.lnCount % (long)this.progressInterval == 0L) {
                this.progressStream.println(this.copyToBtreeStats());
            }
        }

        public void incrementDeletedLNCount() {
            ++this.deletedLNCount;
        }

        Set getINNodeIdsSeen() {
            return this.inNodeIdsSeen;
        }

        Set getBINNodeIdsSeen() {
            return this.binNodeIdsSeen;
        }

        Set getDINNodeIdsSeen() {
            return this.dinNodeIdsSeen;
        }

        Set getDBINNodeIdsSeen() {
            return this.dbinNodeIdsSeen;
        }

        long[] getINsByLevel() {
            return this.insSeenByLevel;
        }

        long[] getBINsByLevel() {
            return this.binsSeenByLevel;
        }

        long[] getDINsByLevel() {
            return this.dinsSeenByLevel;
        }

        long[] getDBINsByLevel() {
            return this.dbinsSeenByLevel;
        }

        long getLNCount() {
            return this.lnCount;
        }

        Set getDupCountLNCount() {
            return this.dupCountLNsSeen;
        }

        long getDeletedLNCount() {
            return this.deletedLNCount;
        }

        int getMainTreeMaxDepth() {
            return this.mainTreeMaxDepth;
        }

        int getDuplicateTreeMaxDepth() {
            return this.duplicateTreeMaxDepth;
        }

        private BtreeStats copyToBtreeStats() {
            BtreeStats ret = new BtreeStats();
            ret.setInternalNodeCount(this.getINNodeIdsSeen().size());
            ret.setBottomInternalNodeCount(this.getBINNodeIdsSeen().size());
            ret.setDuplicateInternalNodeCount(this.getDINNodeIdsSeen().size());
            ret.setDuplicateBottomInternalNodeCount(this.getDBINNodeIdsSeen().size());
            ret.setLeafNodeCount(this.getLNCount());
            ret.setDeletedLeafNodeCount(this.getDeletedLNCount());
            ret.setDupCountLeafNodeCount(this.getDupCountLNCount().size());
            ret.setMainTreeMaxDepth(this.getMainTreeMaxDepth());
            ret.setDuplicateTreeMaxDepth(this.getDuplicateTreeMaxDepth());
            ret.setINsByLevel(this.getINsByLevel());
            ret.setBINsByLevel(this.getBINsByLevel());
            ret.setDINsByLevel(this.getDINsByLevel());
            ret.setDBINsByLevel(this.getDBINsByLevel());
            return ret;
        }
    }

    private static class ObsoleteINCounter
    implements TreeWalkerStatsAccumulator {
        private UtilizationTracker tracker;

        ObsoleteINCounter(UtilizationTracker tracker) {
            this.tracker = tracker;
        }

        private void countIN(IN node) {
            long lsn = node.getLastFullVersion();
            if (lsn != -1L) {
                this.tracker.countObsoleteNode(lsn, node.getLogType(), true);
            }
        }

        public void processIN(IN node, Long nid, int level) {
            this.countIN(node);
        }

        public void processBIN(BIN node, Long nid, int level) {
            this.countIN(node);
        }

        public void processDIN(DIN node, Long nid, int level) {
            this.countIN(node);
        }

        public void processDBIN(DBIN node, Long nid, int level) {
            this.countIN(node);
        }

        public void processDupCountLN(DupCountLN node, Long nid) {
        }

        public void incrementLNCount() {
        }

        public void incrementDeletedLNCount() {
        }
    }
}

