/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyList<T>
implements List<T> {
    private List<T> delegate = Collections.emptyList();

    private List<T> createImplementation() {
        if (!(this.delegate instanceof ArrayList)) {
            return new ArrayList<T>(this.delegate);
        }
        return this.delegate;
    }

    @Override
    public void add(int index, T element) {
        this.delegate = this.createImplementation();
        this.delegate.add(index, element);
    }

    @Override
    public boolean add(T o) {
        if (this.delegate.isEmpty()) {
            this.delegate = Collections.singletonList(o);
            return true;
        }
        this.delegate = this.createImplementation();
        return this.delegate.add(o);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.delegate = this.createImplementation();
        return this.delegate.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        this.delegate = this.createImplementation();
        return this.delegate.addAll(index, c);
    }

    @Override
    public void clear() {
        this.delegate = Collections.emptyList();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public T get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.delegate.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.delegate.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.delegate.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.delegate.listIterator(index);
    }

    @Override
    public T remove(int index) {
        this.delegate = this.createImplementation();
        return this.delegate.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        this.delegate = this.createImplementation();
        return this.delegate.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.delegate = this.createImplementation();
        return this.delegate.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.delegate = this.createImplementation();
        return this.delegate.retainAll(c);
    }

    @Override
    public T set(int index, T element) {
        this.delegate = this.createImplementation();
        return this.delegate.set(index, element);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.delegate.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <U> U[] toArray(U[] a) {
        return this.delegate.toArray(a);
    }
}

