/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.List;
import javax.transaction.Transaction;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.Option;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionEntry;
import org.jgroups.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseRpcInterceptor
extends Interceptor {
    private BuddyManager buddyManager;
    private boolean usingBuddyReplication;
    protected boolean defaultSynchronous;

    @Override
    public void setCache(CacheSPI cache) {
        super.setCache(cache);
        this.buddyManager = cache.getBuddyManager();
        this.usingBuddyReplication = this.buddyManager != null;
        Configuration.CacheMode mode = cache.getConfiguration().getCacheMode();
        this.defaultSynchronous = mode == Configuration.CacheMode.REPL_SYNC || mode == Configuration.CacheMode.INVALIDATION_SYNC;
    }

    protected void checkResponses(List rsps) throws Throwable {
        if (rsps != null) {
            for (Object rsp : rsps) {
                if (rsp == null || !(rsp instanceof Throwable)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Received Throwable from remote node", (Throwable)rsp);
                }
                throw (Throwable)rsp;
            }
        }
    }

    protected void replicateCall(MethodCall call, boolean sync, Option o) throws Throwable {
        this.replicateCall(null, call, sync, o);
    }

    protected void replicateCall(List<Address> recipients, MethodCall call, boolean sync, Option o) throws Throwable {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Broadcasting call " + (Object)((Object)call) + " to recipient list " + recipients));
        }
        Transaction tx = null;
        if (this.cache.getTransactionManager() != null && (tx = this.cache.getTransactionManager().getTransaction()) != null) {
            GlobalTransaction gtx = this.cache.getTransactionTable().get(tx);
            TransactionEntry te = this.cache.getTransactionTable().get(gtx);
            if (te != null) {
                if (te.isForceAsyncReplication()) {
                    sync = false;
                } else if (te.isForceSyncReplication()) {
                    sync = true;
                }
            }
        }
        if (!sync && this.cache.getRPCManager().getReplicationQueue() != null && !this.usingBuddyReplication) {
            this.putCallOnAsyncReplicationQueue(call);
        } else {
            long syncReplTimeout;
            List<Address> callRecipients;
            if (this.usingBuddyReplication) {
                call = this.buddyManager.transformFqns(call);
            }
            if ((callRecipients = recipients) == null) {
                List<Address> list = callRecipients = this.usingBuddyReplication ? this.buddyManager.getBuddyAddresses() : this.cache.getMembers();
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Setting call recipients to " + callRecipients + " since the original list of recipients passed in is null."));
                }
            }
            if ((syncReplTimeout = o.getSyncReplTimeout()) < 0L) {
                syncReplTimeout = this.configuration.getSyncReplTimeout();
            }
            List rsps = this.cache.getRPCManager().callRemoteMethods(callRecipients, MethodDeclarations.replicateMethod, new Object[]{call}, sync, true, syncReplTimeout);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("responses=" + rsps));
            }
            if (sync) {
                this.checkResponses(rsps);
            }
        }
    }

    protected void putCallOnAsyncReplicationQueue(MethodCall call) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Putting call " + (Object)((Object)call) + " on the replication queue."));
        }
        this.cache.getRPCManager().getReplicationQueue().add(MethodCallFactory.create(MethodDeclarations.replicateMethod, new Object[]{call}));
    }

    protected boolean containsModifications(InvocationContext ctx) {
        switch (ctx.getMethodCall().getMethodId()) {
            case 10: 
            case 18: {
                List mods = (List)ctx.getMethodCall().getArgs()[1];
                return mods.size() > 0;
            }
            case 11: 
            case 12: {
                return ctx.isTxHasMods();
            }
        }
        return false;
    }

    protected boolean isSynchronous(Option option) {
        if (option != null) {
            if (option.isForceSynchronous()) {
                return true;
            }
            if (option.isForceAsynchronous()) {
                return false;
            }
        }
        return this.defaultSynchronous;
    }
}

