/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Modification;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.interceptors.CacheStoreInterceptorMBean;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionEntry;
import org.jboss.cache.transaction.TransactionTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheStoreInterceptor
extends Interceptor
implements CacheStoreInterceptorMBean {
    protected CacheLoaderConfig loaderConfig = null;
    protected TransactionManager tx_mgr = null;
    protected TransactionTable tx_table = null;
    private HashMap m_txStores = new HashMap();
    private Map preparingTxs = new ConcurrentHashMap();
    private long m_cacheStores = 0L;
    protected CacheLoader loader;

    @Override
    public void setCache(CacheSPI cache) {
        super.setCache(cache);
        this.loaderConfig = cache.getCacheLoaderManager().getCacheLoaderConfig();
        this.tx_mgr = cache.getTransactionManager();
        this.tx_table = cache.getTransactionTable();
        this.loader = cache.getCacheLoaderManager().getCacheLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object invoke(InvocationContext ctx) throws Throwable {
        NodeSPI n;
        Object key;
        Fqn fqn;
        boolean use_tmp_retval;
        Object tmp_retval;
        Object[] args;
        MethodCall m;
        block26: {
            m = ctx.getMethodCall();
            if (!ctx.isOriginLocal() && this.loaderConfig.isShared()) {
                this.log.trace((Object)"Passing up method call and bypassing this interceptor since the cache loader is shared and this call originated remotely.");
                return super.invoke(ctx);
            }
            args = m.getArgs();
            tmp_retval = null;
            use_tmp_retval = false;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("invoke " + (Object)((Object)m)));
            }
            if (this.tx_mgr == null || this.tx_mgr.getTransaction() == null) break block26;
            this.log.trace((Object)"transactional so don't put stuff in the cloader yet.");
            GlobalTransaction gtx = ctx.getGlobalTransaction();
            switch (m.getMethodId()) {
                case 11: {
                    if (!ctx.isTxHasMods()) {
                        this.log.trace((Object)"Commit called with no modifications; ignoring.");
                        return super.invoke(ctx);
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Calling loader.commit() for gtx " + gtx));
                    }
                    try {
                        this.loader.commit(gtx);
                    }
                    finally {
                        this.preparingTxs.remove(gtx);
                    }
                    if (!this.configuration.getExposeManagementStatistics()) return super.invoke(ctx);
                    if (!this.getStatisticsEnabled()) return super.invoke(ctx);
                    Integer puts = (Integer)this.m_txStores.get(gtx);
                    if (puts != null) {
                        this.m_cacheStores += (long)puts.intValue();
                    }
                    this.m_txStores.remove(gtx);
                    return super.invoke(ctx);
                }
                case 12: {
                    if (!ctx.isTxHasMods()) {
                        this.log.trace((Object)"Rollback called with no modifications; ignoring.");
                        return super.invoke(ctx);
                    }
                    if (this.preparingTxs.containsKey(gtx)) {
                        this.preparingTxs.remove(gtx);
                        this.loader.rollback(gtx);
                    }
                    if (!this.configuration.getExposeManagementStatistics()) return super.invoke(ctx);
                    if (!this.getStatisticsEnabled()) return super.invoke(ctx);
                    this.m_txStores.remove(gtx);
                    return super.invoke(ctx);
                }
                case 10: 
                case 18: {
                    this.prepareCacheLoader(gtx, this.isOnePhaseCommitPrepareMehod(m));
                    return super.invoke(ctx);
                }
            }
            return super.invoke(ctx);
        }
        switch (m.getMethodId()) {
            case 5: {
                fqn = (Fqn)args[1];
                this.loader.remove(fqn);
                break;
            }
            case 6: {
                fqn = (Fqn)args[1];
                key = args[2];
                tmp_retval = this.loader.remove(fqn, key);
                use_tmp_retval = true;
                break;
            }
            case 7: {
                fqn = (Fqn)args[1];
                this.loader.removeData(fqn);
                n = this.cache.peek(fqn, false);
                if (n == null) break;
                n.setDataLoaded(true);
                break;
            }
        }
        Object retval = super.invoke(ctx);
        switch (m.getMethodId()) {
            case 36: {
                this.doMove((Fqn)args[0], (Fqn)args[1]);
                break;
            }
            case 2: {
                fqn = (Fqn)args[1];
                this.loader.removeData(fqn);
                n = this.cache.peek(fqn, false);
                n.setDataLoaded(true);
            }
            case 1: {
                this.loader.put((Fqn)args[1], (Map)args[2]);
                if (!this.configuration.getExposeManagementStatistics() || !this.getStatisticsEnabled()) break;
                ++this.m_cacheStores;
                break;
            }
            case 3: 
            case 45: {
                fqn = (Fqn)args[1];
                key = args[2];
                Object value = args[3];
                tmp_retval = this.loader.put(fqn, key, value);
                use_tmp_retval = true;
                if (!this.configuration.getExposeManagementStatistics() || !this.getStatisticsEnabled()) break;
                ++this.m_cacheStores;
                break;
            }
        }
        if (!use_tmp_retval) return retval;
        return tmp_retval;
    }

    private void doMove(Fqn node, Fqn parent) throws Exception {
        Fqn<Object> newNodeFqn = new Fqn<Object>(parent, node.getLastElement());
        this.recursiveMove(node, newNodeFqn);
        this.loader.remove(node);
    }

    private void recursiveMove(Fqn fqn, Fqn newFqn) throws Exception {
        ArrayList<Fqn> fqns = new ArrayList<Fqn>();
        fqns.add(fqn);
        fqns.add(newFqn);
        this.loader.put(newFqn, this.loader.get(fqn));
        Set<?> childrenNames = this.loader.getChildrenNames(fqn);
        if (childrenNames != null) {
            for (Object child : childrenNames) {
                this.recursiveMove(new Fqn<Object>(fqn, child), new Fqn<Object>(newFqn, child));
            }
        }
    }

    @Override
    public long getCacheLoaderStores() {
        return this.m_cacheStores;
    }

    @Override
    public void resetStatistics() {
        this.m_cacheStores = 0L;
    }

    @Override
    public Map<String, Object> dumpStatistics() {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        retval.put("CacheLoaderStores", this.m_cacheStores);
        return retval;
    }

    private void prepareCacheLoader(GlobalTransaction gtx, boolean onePhase) throws Exception {
        int txPuts = 0;
        TransactionEntry entry = this.tx_table.get(gtx);
        if (entry == null) {
            throw new Exception("entry for transaction " + gtx + " not found in transaction table");
        }
        List<MethodCall> modifications = entry.getCacheLoaderModifications();
        if (modifications.size() == 0) {
            this.log.trace((Object)"Transaction has not logged any modifications!");
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Cache loader modification list: " + modifications));
        }
        ArrayList<Modification> cache_loader_modifications = new ArrayList<Modification>();
        for (MethodCall methodCall : modifications) {
            Modification mod = this.convertMethodCallToModification(methodCall);
            cache_loader_modifications.add(mod);
            if (!this.configuration.getExposeManagementStatistics() || !this.getStatisticsEnabled() || mod.getType() != Modification.ModificationType.PUT_DATA && mod.getType() != Modification.ModificationType.PUT_DATA_ERASE && mod.getType() != Modification.ModificationType.PUT_KEY_VALUE) continue;
            ++txPuts;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Converted method calls to cache loader modifications.  List size: " + cache_loader_modifications.size()));
        }
        if (cache_loader_modifications.size() > 0) {
            this.loader.prepare(gtx, cache_loader_modifications, onePhase);
            this.preparingTxs.put(gtx, gtx);
            if (this.configuration.getExposeManagementStatistics() && this.getStatisticsEnabled() && txPuts > 0) {
                this.m_txStores.put(gtx, txPuts);
            }
        }
    }

    private Modification convertMethodCallToModification(MethodCall methodCall) throws Exception {
        Method method;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Converting method call " + (Object)((Object)methodCall) + " to modification."));
        }
        if ((method = methodCall.getMethod()) == null) {
            throw new Exception("method call has no method: " + (Object)((Object)methodCall));
        }
        Object[] args = methodCall.getArgs();
        Modification mod = null;
        switch (methodCall.getMethodId()) {
            case 1: {
                mod = new Modification(Modification.ModificationType.PUT_DATA, (Fqn)args[1], (Map)args[2]);
                break;
            }
            case 2: {
                mod = new Modification(Modification.ModificationType.PUT_DATA_ERASE, (Fqn)args[1], (Map)args[2]);
                break;
            }
            case 3: {
                mod = new Modification(Modification.ModificationType.PUT_KEY_VALUE, (Fqn)args[1], args[2], args[3]);
                break;
            }
            case 5: {
                mod = new Modification(Modification.ModificationType.REMOVE_NODE, (Fqn)args[1]);
                break;
            }
            case 6: {
                mod = new Modification(Modification.ModificationType.REMOVE_KEY_VALUE, (Fqn)args[1], args[2]);
                break;
            }
            case 7: {
                mod = new Modification(Modification.ModificationType.REMOVE_DATA, (Fqn)args[1]);
                break;
            }
            case 36: {
                mod = new Modification(Modification.ModificationType.MOVE, (Fqn)args[0], (Fqn)args[1]);
                break;
            }
            default: {
                throw new CacheException("method call " + method.getName() + " cannot be converted to a modification");
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Converted " + (Object)((Object)methodCall) + " to Modification of type " + (Object)((Object)mod.getType())));
        }
        return mod;
    }
}

