/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.util.Properties;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.AdjListJDBCCacheLoader;

public class AdjListJDBCCacheLoaderConfig
extends CacheLoaderConfig.IndividualCacheLoaderConfig {
    private static final long serialVersionUID = -8371846151643130281L;
    private boolean createTable;
    private String createTableDDL;
    private String datasourceName;
    private String deleteAllSql;
    private String deleteNodeSql;
    private boolean dropTable;
    private String dropTableDDL;
    private String driverClass;
    private String insertNodeSql;
    private String jdbcURL;
    private String jdbcUser;
    private String jdbcPassword;
    private String selectChildFqnsSql;
    private String selectChildNamesSql;
    private String selectNodeSql;
    private String updateNodeSql;
    private String updateTableSql;
    private String connectionFactoryClass;
    protected String table;
    protected String nodeColumn;
    protected String fqnColumn;

    public AdjListJDBCCacheLoaderConfig() {
    }

    AdjListJDBCCacheLoaderConfig(CacheLoaderConfig.IndividualCacheLoaderConfig base) {
        this.populateFromBaseConfig(base);
    }

    public boolean getCreateTable() {
        return this.createTable;
    }

    public void setCreateTable(boolean createTable) {
        this.testImmutability("createTable");
        this.createTable = createTable;
    }

    public String getCreateTableDDL() {
        return this.createTableDDL;
    }

    public void setCreateTableDDL(String createTableDDL) {
        this.testImmutability("createTableDDL");
        this.createTableDDL = createTableDDL;
    }

    public String getDatasourceName() {
        return this.datasourceName;
    }

    public void setDatasourceName(String datasourceName) {
        this.testImmutability("datasourceName");
        this.datasourceName = datasourceName;
    }

    public String getDeleteAllSql() {
        return this.deleteAllSql;
    }

    public void setDeleteAllSql(String deleteAllSql) {
        this.testImmutability("deleteAllSql");
        this.deleteAllSql = deleteAllSql;
    }

    public String getDeleteNodeSql() {
        return this.deleteNodeSql;
    }

    public void setDeleteNodeSql(String deleteNodeSql) {
        this.testImmutability("deleteNodeSql");
        this.deleteNodeSql = deleteNodeSql;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.testImmutability("driverClass");
        this.driverClass = driverClass;
    }

    public boolean getDropTable() {
        return this.dropTable;
    }

    public void setDropTable(boolean dropTable) {
        this.testImmutability("dropTable");
        this.dropTable = dropTable;
    }

    public String getInsertNodeSql() {
        return this.insertNodeSql;
    }

    public void setInsertNodeSql(String insertNodeSql) {
        this.testImmutability("insertNodeSql");
        this.insertNodeSql = insertNodeSql;
    }

    public String getSelectChildFqnsSql() {
        return this.selectChildFqnsSql;
    }

    public void setSelectChildFqnsSql(String selectChildFqnsSql) {
        this.testImmutability("selectChildFqnsSql");
        this.selectChildFqnsSql = selectChildFqnsSql;
    }

    public String getSelectNodeSql() {
        return this.selectNodeSql;
    }

    public void setSelectNodeSql(String selectNodeSql) {
        this.testImmutability("selectNodeSql");
        this.selectNodeSql = selectNodeSql;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.testImmutability("table");
        this.table = table;
    }

    public String getUpdateTableSql() {
        return this.updateTableSql;
    }

    public void setUpdateTableSql(String updateTableSql) {
        this.testImmutability("updateTableSql");
        this.updateTableSql = updateTableSql;
    }

    public String getDropTableDDL() {
        return this.dropTableDDL;
    }

    public void setDropTableDDL(String dropTableDDL) {
        this.testImmutability("dropTableDDL");
        this.dropTableDDL = dropTableDDL;
    }

    public String getSelectChildNamesSql() {
        return this.selectChildNamesSql;
    }

    public void setSelectChildNamesSql(String selectChildNamesSql) {
        this.testImmutability("selectChildNamesSql");
        this.selectChildNamesSql = selectChildNamesSql;
    }

    public String getUpdateNodeSql() {
        return this.updateNodeSql;
    }

    public void setUpdateNodeSql(String updateNodeSql) {
        this.testImmutability("updateNodeSql");
        this.updateNodeSql = updateNodeSql;
    }

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public void setJdbcPassword(String jdbcPassword) {
        this.testImmutability("jdbcPassword");
        this.jdbcPassword = jdbcPassword;
    }

    public String getJdbcURL() {
        return this.jdbcURL;
    }

    public void setJdbcURL(String jdbcURL) {
        this.testImmutability("jdbcURL");
        this.jdbcURL = jdbcURL;
    }

    public String getJdbcUser() {
        return this.jdbcUser;
    }

    public void setJdbcUser(String jdbcUser) {
        this.testImmutability("jdbcUser");
        this.jdbcUser = jdbcUser;
    }

    public String getConnectionFactoryClass() {
        return this.connectionFactoryClass;
    }

    public void setConnectionFactoryClass(String connectionFactoryClass) {
        this.testImmutability("connectionFactoryClass");
        this.connectionFactoryClass = connectionFactoryClass;
    }

    public void setProperties(Properties props) {
        String prop;
        super.setProperties(props);
        this.datasourceName = props.getProperty("cache.jdbc.datasource");
        if (this.datasourceName == null) {
            this.driverClass = AdjListJDBCCacheLoader.getRequiredProperty(props, "cache.jdbc.driver");
            this.jdbcURL = AdjListJDBCCacheLoader.getRequiredProperty(props, "cache.jdbc.url");
            this.jdbcUser = AdjListJDBCCacheLoader.getRequiredProperty(props, "cache.jdbc.user");
            this.jdbcPassword = AdjListJDBCCacheLoader.getRequiredProperty(props, "cache.jdbc.password");
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Properties: cache.jdbc.url=" + this.jdbcURL + ", cache.jdbc.driver=" + this.driverClass + ", cache.jdbc.user=" + this.jdbcUser + ", cache.jdbc.password=" + this.jdbcPassword + ", cache.jdbc.table=" + this.table));
            }
        }
        this.createTable = (prop = props.getProperty("cache.jdbc.table.create")) == null || Boolean.valueOf(prop) != false;
        prop = props.getProperty("cache.jdbc.table.drop");
        this.dropTable = prop == null ? false : Boolean.valueOf(prop);
        this.table = props.getProperty("cache.jdbc.table.name", "jbosscache");
        String primaryKey = props.getProperty("cache.jdbc.table.primarykey", "jbosscache_pk");
        this.fqnColumn = props.getProperty("cache.jdbc.fqn.column", "fqn");
        String fqnType = props.getProperty("cache.jdbc.fqn.type", "varchar(255)");
        this.nodeColumn = props.getProperty("cache.jdbc.node.column", "node");
        String nodeType = props.getProperty("cache.jdbc.node.type", "blob");
        String parentColumn = props.getProperty("cache.jdbc.parent.column", "parent");
        this.selectChildNamesSql = "select " + this.fqnColumn + " from " + this.table + " where " + parentColumn + "=?";
        this.deleteNodeSql = "delete from " + this.table + " where " + this.fqnColumn + "=?";
        this.deleteAllSql = "delete from " + this.table;
        this.selectChildFqnsSql = "select " + this.fqnColumn + " from " + this.table + " where " + parentColumn + "=?";
        this.insertNodeSql = "insert into " + this.table + " (" + this.fqnColumn + ", " + this.nodeColumn + ", " + parentColumn + ") values (?, ?, ?)";
        this.updateNodeSql = "update " + this.table + " set " + this.nodeColumn + "=? where " + this.fqnColumn + "=?";
        this.selectNodeSql = "select " + this.nodeColumn + " from " + this.table + " where " + this.fqnColumn + "=?";
        this.createTableDDL = "create table " + this.table + "(" + this.fqnColumn + " " + fqnType + " not null, " + this.nodeColumn + " " + nodeType + ", " + parentColumn + " " + fqnType + ", constraint " + primaryKey + " primary key (" + this.fqnColumn + "))";
        this.dropTableDDL = "drop table " + this.table;
        this.connectionFactoryClass = props.getProperty("cache.jdbc.connection.factory", "org.jboss.cache.loader.NonManagedConnectionFactory");
    }

    public boolean equals(Object obj) {
        if (obj instanceof AdjListJDBCCacheLoaderConfig && this.equalsExcludingProperties(obj)) {
            AdjListJDBCCacheLoaderConfig other = (AdjListJDBCCacheLoaderConfig)obj;
            return this.createTable == other.createTable && AdjListJDBCCacheLoaderConfig.safeEquals(this.createTableDDL, other.createTableDDL) && AdjListJDBCCacheLoaderConfig.safeEquals(this.datasourceName, other.datasourceName) && AdjListJDBCCacheLoaderConfig.safeEquals(this.deleteAllSql, other.deleteAllSql) && AdjListJDBCCacheLoaderConfig.safeEquals(this.deleteNodeSql, other.deleteNodeSql) && AdjListJDBCCacheLoaderConfig.safeEquals(this.driverClass, other.driverClass) && this.dropTable == other.dropTable && AdjListJDBCCacheLoaderConfig.safeEquals(this.dropTableDDL, other.dropTableDDL) && AdjListJDBCCacheLoaderConfig.safeEquals(this.insertNodeSql, other.insertNodeSql) && AdjListJDBCCacheLoaderConfig.safeEquals(this.jdbcPassword, other.jdbcPassword) && AdjListJDBCCacheLoaderConfig.safeEquals(this.jdbcURL, other.jdbcURL) && AdjListJDBCCacheLoaderConfig.safeEquals(this.jdbcUser, other.jdbcUser) && AdjListJDBCCacheLoaderConfig.safeEquals(this.selectChildFqnsSql, other.selectChildFqnsSql) && AdjListJDBCCacheLoaderConfig.safeEquals(this.selectChildNamesSql, other.selectChildNamesSql) && AdjListJDBCCacheLoaderConfig.safeEquals(this.selectNodeSql, other.selectNodeSql) && AdjListJDBCCacheLoaderConfig.safeEquals(this.table, other.table) && AdjListJDBCCacheLoaderConfig.safeEquals(this.updateNodeSql, other.updateNodeSql) && AdjListJDBCCacheLoaderConfig.safeEquals(this.updateTableSql, other.updateTableSql) && AdjListJDBCCacheLoaderConfig.safeEquals(this.connectionFactoryClass, other.connectionFactoryClass);
        }
        return false;
    }

    public int hashCode() {
        int result = this.hashCodeExcludingProperties();
        result = 31 * result + (this.createTable ? 0 : 1);
        result = 31 * result + (this.createTableDDL == null ? 0 : this.createTableDDL.hashCode());
        result = 31 * result + (this.datasourceName == null ? 0 : this.datasourceName.hashCode());
        result = 31 * result + (this.deleteAllSql == null ? 0 : this.deleteAllSql.hashCode());
        result = 31 * result + (this.deleteNodeSql == null ? 0 : this.deleteNodeSql.hashCode());
        result = 31 * result + (this.driverClass == null ? 0 : this.driverClass.hashCode());
        result = 31 * result + (this.dropTable ? 0 : 1);
        result = 31 * result + (this.dropTableDDL == null ? 0 : this.dropTableDDL.hashCode());
        result = 31 * result + (this.insertNodeSql == null ? 0 : this.insertNodeSql.hashCode());
        result = 31 * result + (this.jdbcPassword == null ? 0 : this.jdbcPassword.hashCode());
        result = 31 * result + (this.jdbcUser == null ? 0 : this.jdbcUser.hashCode());
        result = 31 * result + (this.jdbcURL == null ? 0 : this.jdbcURL.hashCode());
        result = 31 * result + (this.selectChildFqnsSql == null ? 0 : this.selectChildFqnsSql.hashCode());
        result = 31 * result + (this.selectChildNamesSql == null ? 0 : this.selectChildNamesSql.hashCode());
        result = 31 * result + (this.selectNodeSql == null ? 0 : this.selectNodeSql.hashCode());
        result = 31 * result + (this.table == null ? 0 : this.table.hashCode());
        result = 31 * result + (this.updateNodeSql == null ? 0 : this.updateNodeSql.hashCode());
        result = 31 * result + (this.updateTableSql == null ? 0 : this.updateTableSql.hashCode());
        result = 31 * result + (this.connectionFactoryClass == null ? 0 : this.connectionFactoryClass.hashCode());
        return result;
    }
}

