/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.lock.NodeLock;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionTable {
    protected Map<Transaction, GlobalTransaction> tx_map = new ConcurrentHashMap<Transaction, GlobalTransaction>();
    protected Map<GlobalTransaction, TransactionEntry> txs = new ConcurrentHashMap<GlobalTransaction, TransactionEntry>();
    private static final Log log = LogFactory.getLog(TransactionTable.class);

    public int getNumLocalTransactions() {
        return this.tx_map.size();
    }

    public int getNumGlobalTransactions() {
        return this.txs.size();
    }

    public GlobalTransaction get(Transaction tx) {
        if (tx == null) {
            return null;
        }
        return this.tx_map.get(tx);
    }

    public Transaction getLocalTransaction(GlobalTransaction gtx) {
        if (gtx == null) {
            return null;
        }
        for (Map.Entry<Transaction, GlobalTransaction> entry : this.tx_map.entrySet()) {
            Transaction local_tx = entry.getKey();
            GlobalTransaction global_tx = entry.getValue();
            if (!gtx.equals(global_tx)) continue;
            return local_tx;
        }
        return null;
    }

    public void put(Transaction tx, GlobalTransaction gtx) {
        if (tx == null) {
            log.error((Object)"key (Transaction) is null");
            return;
        }
        this.tx_map.put(tx, gtx);
    }

    public TransactionEntry get(GlobalTransaction gtx) {
        return gtx != null ? this.txs.get(gtx) : null;
    }

    public void put(GlobalTransaction tx, TransactionEntry entry) {
        if (tx == null) {
            log.error((Object)"key (GlobalTransaction) is null");
            return;
        }
        this.txs.put(tx, entry);
    }

    public TransactionEntry remove(GlobalTransaction tx) {
        if (tx == null) {
            return null;
        }
        return this.txs.remove(tx);
    }

    public GlobalTransaction remove(Transaction tx) {
        if (tx == null) {
            return null;
        }
        return this.tx_map.remove(tx);
    }

    public void addModification(GlobalTransaction gtx, MethodCall m) {
        TransactionEntry entry = this.get(gtx);
        if (entry == null) {
            log.error((Object)("transaction not found (gtx=" + gtx + ")"));
            return;
        }
        entry.addModification(m);
    }

    public void addCacheLoaderModification(GlobalTransaction gtx, MethodCall m) {
        if (m != null) {
            TransactionEntry entry = this.get(gtx);
            if (entry == null) {
                log.error((Object)("transaction not found (gtx=" + gtx + ")"));
                return;
            }
            entry.addCacheLoaderModification(m);
        }
    }

    public void addUndoOperation(GlobalTransaction gtx, MethodCall m) {
        TransactionEntry entry = this.get(gtx);
        if (entry == null) {
            log.error((Object)("transaction not found (gtx=" + gtx + ")"));
            return;
        }
        entry.addUndoOperation(m);
    }

    public void addLock(GlobalTransaction gtx, NodeLock l) {
        TransactionEntry entry = this.get(gtx);
        if (entry == null) {
            log.error((Object)("transaction entry not found for (gtx=" + gtx + ")"));
            return;
        }
        entry.addLock(l);
    }

    public void addLocks(GlobalTransaction gtx, Collection<NodeLock> locks) {
        TransactionEntry entry = this.get(gtx);
        if (entry == null) {
            log.error((Object)("transaction entry not found for (gtx=" + gtx + ")"));
            return;
        }
        entry.addLocks(locks);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.tx_map.size()).append(" mappings, ");
        sb.append(this.txs.size()).append(" transactions");
        return sb.toString();
    }

    public String toString(boolean print_details) {
        if (!print_details) {
            return this.toString();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("LocalTransactions: ").append(this.tx_map.size()).append("\n");
        sb.append("GlobalTransactions: ").append(this.txs.size()).append("\n");
        sb.append("tx_map:\n");
        for (Map.Entry<Transaction, GlobalTransaction> entry : this.tx_map.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        sb.append("txs:\n");
        for (Map.Entry<Object, Object> entry : this.txs.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }
}

