/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.BuddyGroup;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.CacheLoaderManager;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.xml.XmlHelper;
import org.jgroups.Address;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional", "jgroups"})
public abstract class BuddyReplicationTestsBase {
    protected List<CacheImpl<Object, Object>> caches;
    protected static final int VIEW_BLOCK_TIMEOUT = 5000;

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        System.out.println("***** TEARING DOWN *****");
        System.setProperty("org.jboss.cache.shutdown.force", "true");
        if (this.caches != null) {
            for (CacheImpl<Object, Object> c : this.caches) {
                if (c == null || c.getBuddyManager() == null) continue;
                c.getBuddyManager().stop();
            }
            for (CacheImpl<Object, Object> c : this.caches) {
                CacheLoaderManager clm;
                if (c == null) continue;
                TransactionManager tm = c.getTransactionManager();
                if (tm != null) {
                    try {
                        if (tm.getTransaction() != null) {
                            tm.rollback();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if ((clm = c.getCacheLoaderManager()) != null) {
                    CacheLoader cl = c.getCacheLoaderManager().getCacheLoader();
                    try {
                        if (cl != null) {
                            cl.remove(Fqn.ROOT);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                c.stop();
                Object var2_2 = null;
            }
        }
        this.caches = null;
        System.gc();
    }

    protected CacheImpl<Object, Object> createCache(int numBuddies, String buddyPoolName) throws Exception {
        return this.createCache(numBuddies, buddyPoolName, false, true);
    }

    protected CacheImpl<Object, Object> createCache(int numBuddies, String buddyPoolName, boolean useDataGravitation) throws Exception {
        return this.createCache(numBuddies, buddyPoolName, useDataGravitation, true);
    }

    protected CacheImpl<Object, Object> createCache(int numBuddies, String buddyPoolName, boolean useDataGravitation, boolean start) throws Exception {
        return this.createCache(false, numBuddies, buddyPoolName, useDataGravitation, true, start);
    }

    protected CacheImpl<Object, Object> createCache(boolean optimisticLocks, int numBuddies, String buddyPoolName, boolean useDataGravitation, boolean start) throws Exception {
        return this.createCache(optimisticLocks, numBuddies, buddyPoolName, useDataGravitation, true, start);
    }

    protected CacheImpl<Object, Object> createCache(int numBuddies, String buddyPoolName, boolean useDataGravitation, boolean removeOnFind, boolean start) throws Exception {
        return this.createCache(false, numBuddies, buddyPoolName, useDataGravitation, removeOnFind, start);
    }

    protected CacheImpl<Object, Object> createCache(boolean optimisticLocks, int numBuddies, String buddyPoolName, boolean useDataGravitation, boolean removeOnFind, boolean start) throws Exception {
        CacheImpl c = (CacheImpl)DefaultCacheFactory.getInstance().createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC), false);
        c.getConfiguration().setClusterName("BuddyReplicationTest");
        String xmlString = "<config><buddyReplicationEnabled>true</buddyReplicationEnabled>\n<buddyCommunicationTimeout>500</buddyCommunicationTimeout>\n          <buddyLocatorClass>org.jboss.cache.buddyreplication.NextMemberBuddyLocator</buddyLocatorClass>\n          <autoDataGravitation>" + useDataGravitation + "</autoDataGravitation>\n" + "          <dataGravitationRemoveOnFind>" + removeOnFind + "</dataGravitationRemoveOnFind>\n" + "          <buddyLocatorProperties>numBuddies = " + numBuddies + "</buddyLocatorProperties>\n";
        if (buddyPoolName != null) {
            xmlString = xmlString + "<buddyPoolName>" + buddyPoolName + "</buddyPoolName>";
        }
        xmlString = xmlString + "</config>";
        Element element = XmlHelper.stringToElement((String)xmlString);
        BuddyReplicationConfig config = XmlConfigurationParser.parseBuddyReplicationConfig((Element)element);
        c.getConfiguration().setBuddyReplicationConfig(config);
        c.getConfiguration().setFetchInMemoryState(true);
        if (optimisticLocks) {
            c.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        }
        c.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        c.getConfiguration().setSyncCommitPhase(true);
        this.configureMultiplexer((Cache)c);
        if (start) {
            c.start();
            this.validateMultiplexer((Cache)c);
        }
        return c;
    }

    protected void configureMultiplexer(Cache cache) throws Exception {
    }

    protected void validateMultiplexer(Cache cache) {
        AssertJUnit.assertFalse((String)"Cache is not using multiplexer", (boolean)cache.getConfiguration().isUsingMultiplexer());
    }

    protected List<CacheImpl<Object, Object>> createCaches(int numCaches, boolean useBuddyPool) throws Exception {
        return this.createCaches(1, numCaches, useBuddyPool, false);
    }

    protected List<CacheImpl<Object, Object>> createCaches(int numCaches, boolean useBuddyPool, boolean useDataGravitation, boolean optimisticLocks) throws Exception {
        return this.createCaches(1, numCaches, useBuddyPool, useDataGravitation, optimisticLocks);
    }

    protected List<CacheImpl<Object, Object>> createCaches(int numCaches, boolean useBuddyPool, boolean useDataGravitation) throws Exception {
        return this.createCaches(1, numCaches, useBuddyPool, useDataGravitation);
    }

    protected List<CacheImpl<Object, Object>> createCachesWithCacheLoader(int numCaches, boolean useDataGravitation, boolean removeOnFind, boolean passivation) throws Exception {
        return this.createCachesWithCacheLoader(numCaches, useDataGravitation, removeOnFind, passivation, false);
    }

    protected List<CacheImpl<Object, Object>> createCachesWithCacheLoader(int numCaches, boolean useDataGravitation, boolean removeOnFind, boolean passivation, boolean fetchPersistent) throws Exception {
        String tmpLoc = System.getProperty("java.io.tmpdir", "/tmp");
        tmpLoc = tmpLoc + File.separator + "BuddyReplicationTestsBase-";
        ArrayList<CacheImpl<Object, Object>> caches = new ArrayList<CacheImpl<Object, Object>>();
        for (int i = 0; i < numCaches; ++i) {
            caches.add(this.createCacheWithCacheLoader(useDataGravitation, removeOnFind, passivation, fetchPersistent, true));
        }
        TestingUtil.blockUntilViewsReceived(caches.toArray(new CacheImpl[0]), 5000L);
        TestingUtil.sleepThread(this.getSleepTimeout());
        return caches;
    }

    protected CacheImpl<Object, Object> createCacheWithCacheLoader(boolean useDataGravitation, boolean removeOnFind, boolean passivation, boolean fetchPersistent, boolean start) throws Exception {
        CacheImpl<Object, Object> cache = this.createCache(1, null, useDataGravitation, removeOnFind, false);
        String cloader = "<config>\n<passivation>" + passivation + "</passivation>\n" + "<preload></preload>\n" + "<cacheloader>\n" + "<class>org.jboss.cache.loader.DummyInMemoryCacheLoader</class>\n" + "<async>false</async>\n" + "<shared>false</shared>\n" + "<fetchPersistentState>" + fetchPersistent + "</fetchPersistentState>\n" + "</cacheloader>\n" + "</config>";
        Element element = XmlHelper.stringToElement((String)cloader);
        CacheLoaderConfig cfg = XmlConfigurationParser.parseCacheLoaderConfig((Element)element);
        cache.getConfiguration().setCacheLoaderConfig(cfg);
        if (start) {
            cache.start();
        }
        return cache;
    }

    protected List<CacheImpl<Object, Object>> createCaches(int numBuddies, int numCaches, boolean useBuddyPool) throws Exception {
        return this.createCaches(numBuddies, numCaches, useBuddyPool, false);
    }

    protected List<CacheImpl<Object, Object>> createCaches(int numBuddies, int numCaches, boolean useBuddyPool, boolean useDataGravitation) throws Exception {
        return this.createCaches(numBuddies, numCaches, useBuddyPool, useDataGravitation, false);
    }

    protected List<CacheImpl<Object, Object>> createCaches(int numBuddies, int numCaches, boolean useBuddyPool, boolean useDataGravitation, boolean optimisticLocks) throws Exception {
        ArrayList<CacheImpl<Object, Object>> caches = new ArrayList<CacheImpl<Object, Object>>(numCaches);
        for (int i = 0; i < numCaches; ++i) {
            caches.add(this.createCache(optimisticLocks, numBuddies, useBuddyPool ? Character.toString((char)(65 + i)) : null, useDataGravitation, true));
        }
        TestingUtil.blockUntilViewsReceived(caches.toArray(new CacheImpl[0]), 5000L);
        TestingUtil.sleepThread(this.getSleepTimeout());
        return caches;
    }

    protected void printBuddyGroup(CacheSPI cache) {
        BuddyGroup bg = cache.getBuddyManager().buddyGroup;
        System.out.println("*** " + bg);
        System.out.println("    Groups I participate in: " + cache.getBuddyManager().buddyGroupsIParticipateIn.keySet());
    }

    protected int getSleepTimeout() {
        return 1000;
    }

    protected void assertIsBuddy(CacheSPI dataOwner, CacheSPI buddy, boolean onlyBuddy) {
        Address dataOwnerLocalAddress = dataOwner.getLocalAddress();
        Address buddyLocalAddress = buddy.getLocalAddress();
        System.out.println("*** assert with groups.  Testing that " + buddyLocalAddress + " is a buddy for owner " + dataOwnerLocalAddress + " only buddy? " + onlyBuddy);
        this.printBuddyGroup(dataOwner);
        BuddyManager dataOwnerBuddyManager = dataOwner.getBuddyManager();
        BuddyManager buddyBuddyManager = buddy.getBuddyManager();
        if (onlyBuddy) {
            AssertJUnit.assertEquals((String)"Should only have one buddy", (int)1, (int)dataOwnerBuddyManager.getBuddyAddresses().size());
        }
        AssertJUnit.assertTrue((String)(buddyLocalAddress + " should be a buddy to " + dataOwnerLocalAddress), (boolean)dataOwnerBuddyManager.getBuddyAddresses().contains(buddyLocalAddress));
        BuddyGroup group = (BuddyGroup)buddyBuddyManager.buddyGroupsIParticipateIn.get(BuddyManager.getGroupNameFromAddress((Object)dataOwnerLocalAddress));
        System.out.println("*** Groups I participate in: " + buddyBuddyManager.buddyGroupsIParticipateIn);
        System.out.println("*** Buddy's version of dataOwner's group " + group);
        AssertJUnit.assertTrue((String)"buddy's list of groups it participates in should contain data owner's group name", (boolean)buddyBuddyManager.buddyGroupsIParticipateIn.containsKey(BuddyManager.getGroupNameFromAddress((Object)dataOwnerLocalAddress)));
        if (onlyBuddy) {
            AssertJUnit.assertEquals((int)1, (int)group.getBuddies().size());
        }
        AssertJUnit.assertTrue((String)(buddyLocalAddress + " should be a buddy to " + group.getGroupName()), (boolean)group.getBuddies().contains(buddyLocalAddress));
    }

    protected void dumpCacheContents(List<CacheImpl<Object, Object>> caches) {
        System.out.println("**** START: Cache Contents ****");
        for (int i = 0; i < caches.size(); ++i) {
            if (caches.get(i) == null) {
                System.out.println("  ** Cache " + i + " is null!");
                continue;
            }
            System.out.println("  ** Cache " + i + " is " + caches.get(i).getLocalAddress());
            System.out.println("    " + caches.get(i).printLockInfo());
        }
        System.out.println("**** END: Cache Contents ****");
    }

    protected void assertNoLocks(List<CacheImpl<Object, Object>> caches) {
        for (CacheImpl<Object, Object> cache : caches) {
            if (cache == null) continue;
            AssertJUnit.assertEquals((int)0, (int)cache.getNumberOfLocksHeld());
        }
    }
}

